/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.client.renderer;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.client.ObjMesh;
import com.michelmuscle.slidersmod.client.VortexRenderTypes;
import com.michelmuscle.slidersmod.client.renderer.OgVortexObjRenderer;
import com.michelmuscle.slidersmod.entity.OgVortexBorderObjEntity;
import com.michelmuscle.slidersmod.util.CustomVortexVisuals;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.q_misc_util.my_util.DQuaternion;

public class OgVortexBorderObjRenderer
extends EntityRenderer<OgVortexBorderObjEntity> {
    private static ObjMesh MESH;
    private static ObjMesh CUSTOM_MESH;
    private static final ResourceLocation OBJ;
    private static final ResourceLocation CUSTOM_OBJ;
    private static final ResourceLocation TEX;
    public static float SCROLL_SPEED;
    public static float SCROLL_ANGLE_DEG;
    public static float SCALE;
    public static boolean GLOW;

    public OgVortexBorderObjRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.f_114477_ = 0.0f;
    }

    public void render(OgVortexBorderObjEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        ObjMesh mesh = this.resolveMesh(entity);
        if (mesh == null) {
            return;
        }
        float time = ((float)entity.m_9236_().m_46467_() + partialTicks) / 20.0f;
        float angle = (float)Math.toRadians(SCROLL_ANGLE_DEG);
        float du = ObjMesh.wrap01(time * SCROLL_SPEED * (float)Math.cos(angle));
        float dv = ObjMesh.wrap01(time * SCROLL_SPEED * (float)Math.sin(angle));
        float fadeProgress = entity.getScaleFactor(partialTicks);
        if (fadeProgress <= 0.0f) {
            return;
        }
        poseStack.m_85836_();
        Quaternionf rotation = OgVortexBorderObjRenderer.buildOrientationQuaternion(entity.getAxisW(), entity.getAxisH(), entity.getNormal());
        rotation.mul((Quaternionfc)new Quaternionf().rotateY((float)Math.PI));
        poseStack.m_252781_(rotation);
        poseStack.m_85841_(SCALE * fadeProgress, SCALE * fadeProgress, SCALE * fadeProgress);
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        ResourceLocation texture = OgVortexBorderObjRenderer.resolveTexture(entity);
        VertexConsumer translucent = buffer.m_6299_(VortexRenderTypes.vortex(texture));
        if (entity.hasCustomAppearance()) {
            int tint = entity.getCustomTint();
            int red = tint >> 16 & 0xFF;
            int green = tint >> 8 & 0xFF;
            int blue = tint & 0xFF;
            mesh.drawTinted(translucent, pose, 0xF000F0, du, dv, red, green, blue);
        } else {
            mesh.draw(translucent, pose, 0xF000F0, du, dv);
        }
        if (GLOW) {
            VertexConsumer glow = buffer.m_6299_(RenderType.m_110488_((ResourceLocation)texture));
            if (entity.hasCustomAppearance()) {
                int tint = entity.getCustomTint();
                int red = tint >> 16 & 0xFF;
                int green = tint >> 8 & 0xFF;
                int blue = tint & 0xFF;
                mesh.drawTinted(glow, pose, 0xF000F0, du, dv, red, green, blue);
            } else {
                mesh.draw(glow, pose, 0xF000F0, du, dv);
            }
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(OgVortexBorderObjEntity entity) {
        return OgVortexBorderObjRenderer.resolveTexture(entity);
    }

    private static ResourceLocation resolveTexture(OgVortexBorderObjEntity entity) {
        if (entity.hasCustomAppearance()) {
            return CustomVortexVisuals.resolveEntityTexture(entity.getCustomTextureId(), TEX);
        }
        return TEX;
    }

    private ObjMesh resolveMesh(OgVortexBorderObjEntity entity) {
        boolean useCustom = entity.hasCustomAppearance() && "customog".equals(entity.getCustomTextureId());
        try {
            if (useCustom) {
                if (CUSTOM_MESH == null) {
                    CUSTOM_MESH = ObjMesh.load(CUSTOM_OBJ);
                }
                return CUSTOM_MESH;
            }
            if (MESH == null) {
                MESH = ObjMesh.load(OBJ);
            }
            return MESH;
        }
        catch (Exception e) {
            SlidersMod.LOGGER.error("Unable to load OG vortex border OBJ", (Throwable)e);
            return null;
        }
    }

    private static Quaternionf buildOrientationQuaternion(Vec3 axisW, Vec3 axisH, Vec3 normal) {
        Vec3 w = OgVortexBorderObjRenderer.normalizeOrFallback(axisW, new Vec3(1.0, 0.0, 0.0));
        Vec3 h = OgVortexBorderObjRenderer.normalizeOrFallback(axisH, new Vec3(0.0, 1.0, 0.0));
        DQuaternion dq = PortalManipulation.getPortalOrientationQuaternion((Vec3)w, (Vec3)h);
        return new Quaternionf((float)dq.x, (float)dq.y, (float)dq.z, (float)dq.w);
    }

    private static Vec3 normalizeOrFallback(Vec3 vec, Vec3 fallback) {
        if (vec.m_82556_() < 1.0E-6) {
            return fallback;
        }
        Vec3 normalized = vec.m_82541_();
        if (normalized.m_82556_() < 1.0E-6) {
            return fallback;
        }
        return normalized;
    }

    static {
        OBJ = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"models/entity/ogvortexborder.obj");
        CUSTOM_OBJ = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"models/entity/customogborder.obj");
        TEX = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/entity/ogvortex.png");
        SCROLL_SPEED = OgVortexObjRenderer.SCROLL_SPEED;
        SCROLL_ANGLE_DEG = OgVortexObjRenderer.SCROLL_ANGLE_DEG;
        SCALE = OgVortexObjRenderer.SCALE;
        GLOW = OgVortexObjRenderer.GLOW;
    }
}

