/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.dimension;

import com.michelmuscle.slidersmod.dimension.DimState;
import com.michelmuscle.slidersmod.portal.VortexImmersivePortalHelper;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import snownee.pdgamerules.duck.PDDerivedLevelData;

@Mod.EventBusSubscriber(modid="slidersmod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DimRules {
    private static final Set<EntityType<?>> DLROWREVO_PASSIVES = Set.of(EntityType.f_20557_, EntityType.f_20510_, EntityType.f_20520_, EntityType.f_20555_, EntityType.f_20457_);
    private static final Map<String, Set<EntityType<?>>> EXCLUSIVE_SPAWNS = Map.ofEntries(Map.entry("alternate1", Set.of(EntityType.f_20511_, EntityType.f_20512_)), Map.entry("iles_inverses", Set.of(EntityType.f_20492_, EntityType.f_20553_, EntityType.f_20505_, EntityType.f_20460_, EntityType.f_20494_)), Map.entry("mousson", Set.of(EntityType.f_20504_)), Map.entry("felina", Set.of(EntityType.f_20553_, EntityType.f_20505_)), Map.entry("eldoggo", Set.of(EntityType.f_20499_)), Map.entry("vendavel", Set.of(EntityType.f_20460_, EntityType.f_20528_)), Map.entry("necropole", Set.of(EntityType.f_20501_, EntityType.f_20524_, EntityType.f_20481_)), Map.entry("twilight_world", Set.of(EntityType.f_20511_, EntityType.f_20512_, EntityType.f_20456_, EntityType.f_20482_)), Map.entry("skylands_world", Set.of(EntityType.f_20453_, EntityType.f_20551_, EntityType.f_20509_)), Map.entry("pillager_dimension", Set.of(EntityType.f_20513_)), Map.entry("badlands", Set.of()));
    private static final Map<String, Map<Block, Integer>> ORE_DROP_MULTIPLIERS = Map.ofEntries(Map.entry("alternate1", Map.of(Blocks.f_49995_, 4, Blocks.f_152467_, 4, Blocks.f_50089_, 4, Blocks.f_152474_, 4, Blocks.f_49996_, 4, Blocks.f_152468_, 4)), Map.entry("eclipse", Map.of(Blocks.f_49995_, 4, Blocks.f_152467_, 4, Blocks.f_50089_, 4, Blocks.f_152474_, 4, Blocks.f_49996_, 4, Blocks.f_152468_, 4)), Map.entry("sablier", Map.of(Blocks.f_49995_, 3, Blocks.f_152467_, 3, Blocks.f_50089_, 3, Blocks.f_152474_, 3, Blocks.f_49996_, 3, Blocks.f_152468_, 3)), Map.entry("necropole", Map.of(Blocks.f_49995_, 3, Blocks.f_152467_, 3, Blocks.f_50089_, 3, Blocks.f_152474_, 3, Blocks.f_49996_, 3, Blocks.f_152468_, 3)));
    private static final Map<String, List<PopulationTarget>> POPULATION_TARGETS = Map.ofEntries(Map.entry("alternate1", List.of(new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20511_, 12, 6), new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20512_, 4, 2))), Map.entry("iles_inverses", List.of(new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20492_, 8, 4), new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20553_, 10, 5), new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20460_, 4, 2))), Map.entry("mousson", List.of(new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20504_, 14, 6))), Map.entry("felina", List.of(new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20553_, 14, 6))), Map.entry("eldoggo", List.of(new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20499_, 14, 6))), Map.entry("vendavel", List.of(new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20460_, 4, 2), new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20528_, 6, 3))), Map.entry("necropole", List.of(new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20501_, 10, 5), new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20524_, 10, 5), new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20481_, 6, 3))), Map.entry("twilight_world", List.of(new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20511_, 10, 4), new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20512_, 4, 2), new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20456_, 6, 3))), Map.entry("skylands_world", List.of(new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20453_, 6, 3), new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20551_, 8, 4), new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20509_, 6, 3))), Map.entry("pillager_dimension", List.of(new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20513_, 10, 5))), Map.entry("dlrowrevo", List.of(new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20557_, 6, 3), new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20510_, 6, 3), new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20520_, 6, 3), new PopulationTarget((EntityType<? extends Mob>)EntityType.f_20555_, 8, 4))));
    private static final int SABLIER_DAY_INCREMENT = 10;
    private static final int POPULATION_RADIUS = 72;
    private static final int POPULATION_MIN_DISTANCE = 10;
    private static final int POPULATION_MAX_ATTEMPTS = 6;
    private static final boolean PD_GAMERULES_LOADED = ModList.get().isLoaded("pdgamerules");

    private static boolean inDim(ServerLevel sl, String id) {
        return sl.m_46472_().m_135782_().equals((Object)new ResourceLocation("slidersmod", id));
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent e) {
        long base;
        long dayTime;
        Level level;
        if (e.phase != TickEvent.Phase.END || !((level = e.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        DimState state = DimState.get(sl);
        long time = sl.m_46467_();
        if (DimRules.inDim(sl, "alternate1")) {
            sl.m_8606_(0, 600000, true, true);
            dayTime = sl.m_46468_();
            base = dayTime - dayTime % 24000L;
            if (dayTime != base + 18000L) {
                sl.m_8615_(base + 18000L);
            }
        }
        if (DimRules.inDim(sl, "mousson")) {
            sl.m_8606_(0, 600000, true, true);
            sl.m_46734_(1.0f);
            sl.m_46707_(1.0f);
        }
        if (DimRules.inDim(sl, "eclipse") && (dayTime = sl.m_46468_()) != (base = dayTime - dayTime % 24000L) + 18000L) {
            sl.m_8615_(base + 18000L);
        }
        if (DimRules.inDim(sl, "twilight_world") && (dayTime = sl.m_46468_()) != (base = dayTime - dayTime % 24000L) + 18000L) {
            sl.m_8615_(base + 18000L);
        }
        if (DimRules.inDim(sl, "frozen_world")) {
            sl.m_8606_(0, 600000, true, true);
            sl.m_46734_(1.0f);
            sl.m_46707_(0.0f);
        }
        if (DimRules.inDim(sl, "sablier")) {
            LevelData levelData;
            GameRules.IntegerValue tickRule;
            GameRules.BooleanValue dayRule = (GameRules.BooleanValue)sl.m_46469_().m_46170_(GameRules.f_46140_);
            if (!dayRule.m_46223_()) {
                dayRule.m_46246_(true, sl.m_7654_());
            }
            if ((tickRule = (GameRules.IntegerValue)sl.m_46469_().m_46170_(GameRules.f_46143_)).m_46288_() != 30) {
                tickRule.m_151489_(30, sl.m_7654_());
            }
            if (PD_GAMERULES_LOADED && (levelData = sl.m_6106_()) instanceof PDDerivedLevelData) {
                PDDerivedLevelData data = (PDDerivedLevelData)levelData;
                data.pdgamerules$setIndependentDayTime(true);
            }
            if (state.sablierDayTime < 0L) {
                state.sablierDayTime = sl.m_46468_();
            }
            state.sablierDayTime += 10L;
            sl.m_8615_(state.sablierDayTime);
            if (time >= state.nextEvent) {
                state.sablierBurst = !state.sablierBurst;
                state.nextEvent = time + (long)(state.sablierBurst ? 900 : 1800);
                state.m_77762_();
            } else {
                state.m_77762_();
            }
        }
        DimRules.enforceExclusivePresence(sl);
        DimRules.applyPopulationTargets(sl);
        if (DimRules.inDim(sl, "twilight_world")) {
            DimRules.applyTwilightCorruption(sl);
        }
        if (!sl.m_6907_().isEmpty() && time % 40L == 0L) {
            VortexImmersivePortalHelper.cleanupOrphanedPortals(sl, 48.0, 2.5);
        }
        if (time % 40L == 0L) {
            DimRules.applyPopulationTargets(sl);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase != TickEvent.Phase.END || e.player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel sl = (ServerLevel)e.player.m_9236_();
        DimState state = DimState.get(sl);
        if (DimRules.inDim(sl, "eclipse")) {
            e.player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 60, 0, true, false));
            e.player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 220, 0, true, false));
        }
        if (DimRules.inDim(sl, "vendavel")) {
            double angle = (double)(sl.m_46467_() % 6000L) / 6000.0 * (Math.PI * 2);
            double force = 0.15;
            e.player.m_5997_(Math.cos(angle) * force, 0.03, Math.sin(angle) * force);
        }
        if (DimRules.inDim(sl, "sablier") && state.sablierBurst) {
            e.player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 120, 1, true, false));
            e.player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 120, 1, true, false));
        }
        if (DimRules.inDim(sl, "sommets_aurore") && e.player.m_20186_() > 150.0 && sl.m_46803_(e.player.m_20183_()) < 11) {
            e.player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 0, true, false));
        }
        if (DimRules.inDim(sl, "skylands_world")) {
            e.player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 60, 5, true, false));
        }
    }

    @SubscribeEvent
    public static void onSpawnPlacement(MobSpawnEvent.SpawnPlacementCheck e) {
        ServerLevelAccessor serverLevelAccessor = e.getLevel();
        if (!(serverLevelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)serverLevelAccessor;
        EntityType type = e.getEntityType();
        if (!DimRules.isEntityAllowed(sl, type)) {
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onFinalizeSpawn(MobSpawnEvent.FinalizeSpawn e) {
        ServerLevelAccessor serverLevelAccessor = e.getLevel();
        if (!(serverLevelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)serverLevelAccessor;
        if (!DimRules.isEntityAllowed(sl, e.getEntity().m_6095_())) {
            e.setSpawnCancelled(true);
            DimRules.spawnReplacementIfNeeded(sl, e.getX(), e.getY(), e.getZ());
        }
    }

    @SubscribeEvent
    public static void onWolfHurt(LivingHurtEvent e) {
        Level level = e.getEntity().m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        if (!DimRules.inDim(sl, "eldoggo")) {
            return;
        }
        if (!(e.getEntity() instanceof Wolf)) {
            return;
        }
        for (Wolf w : sl.m_45976_(Wolf.class, e.getEntity().m_20191_().m_82400_(32.0))) {
            w.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 0, true, false));
            w.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 0, true, false));
        }
    }

    @SubscribeEvent
    public static void onSkylandsFallDamage(LivingHurtEvent e) {
        Level level = e.getEntity().m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        if (!DimRules.inDim(sl, "skylands_world")) {
            return;
        }
        if (e.getSource() == e.getEntity().m_269291_().m_268989_()) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onDimensionXpMultiplier(LivingExperienceDropEvent e) {
        Level level = e.getEntity().m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        String dimPath = sl.m_46472_().m_135782_().m_135815_();
        if (dimPath.equals("sablier") || dimPath.equals("eclipse")) {
            e.setDroppedExperience(e.getDroppedExperience() * 5);
        } else if (dimPath.equals("skylands_world") || dimPath.equals("pillager_dimension")) {
            e.setDroppedExperience(e.getDroppedExperience() * 4);
        } else if (dimPath.equals("pillager_dimension")) {
            e.setDroppedExperience(e.getDroppedExperience() * 3);
        }
    }

    private static boolean isEntityAllowed(ServerLevel sl, EntityType<?> type) {
        Set<EntityType<?>> allowed = EXCLUSIVE_SPAWNS.get(sl.m_46472_().m_135782_().m_135815_());
        if (allowed == null) {
            return true;
        }
        if (allowed.isEmpty()) {
            return false;
        }
        return allowed.contains(type);
    }

    private static void spawnReplacementIfNeeded(ServerLevel sl, double x, double y, double z) {
        String dimId = sl.m_46472_().m_135782_().m_135815_();
        if ("eldoggo".equals(dimId)) {
            DimRules.spawnWolf(sl, x, y, z);
        } else if ("felina".equals(dimId)) {
            DimRules.spawnFeline(sl, x, y, z);
        }
    }

    private static void spawnWolf(ServerLevel sl, double x, double y, double z) {
        Wolf wolf = (Wolf)EntityType.f_20499_.m_20615_((Level)sl);
        if (wolf != null) {
            RandomSource random = sl.m_213780_();
            wolf.m_7678_(x, y, z, random.m_188501_() * 360.0f, 0.0f);
            wolf.m_21530_();
            sl.m_7967_((Entity)wolf);
        }
    }

    private static void spawnFeline(ServerLevel sl, double x, double y, double z) {
        Cat cat = (Cat)EntityType.f_20553_.m_20615_((Level)sl);
        if (cat != null) {
            RandomSource random = sl.m_213780_();
            cat.m_7678_(x, y, z, random.m_188501_() * 360.0f, 0.0f);
            cat.m_21530_();
            sl.m_7967_((Entity)cat);
        }
    }

    private static void enforceExclusivePresence(ServerLevel sl) {
        Set<EntityType<?>> allowed = EXCLUSIVE_SPAWNS.get(sl.m_46472_().m_135782_().m_135815_());
        if (allowed == null) {
            return;
        }
        if (sl.m_6907_().isEmpty()) {
            return;
        }
        for (Player player : sl.m_6907_()) {
            AABB area = new AABB(player.m_20183_()).m_82400_(96.0);
            for (Mob mob : sl.m_45976_(Mob.class, area)) {
                if (!allowed.isEmpty() && allowed.contains(mob.m_6095_())) continue;
                mob.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private static void applyPopulationTargets(ServerLevel sl) {
        List<PopulationTarget> targets = POPULATION_TARGETS.get(sl.m_46472_().m_135782_().m_135815_());
        if (targets == null || sl.m_6907_().isEmpty()) {
            return;
        }
        for (PopulationTarget target : targets) {
            DimRules.enforcePopulation(sl, target.type(), target.desiredPerPlayer(), target.minBatch());
        }
    }

    private static void enforcePopulation(ServerLevel sl, EntityType<? extends Mob> allowedType, int desiredPerPlayer, int minSpawnBatch) {
        if (sl.m_6907_().isEmpty()) {
            return;
        }
        RandomSource random = sl.m_213780_();
        for (Player player : sl.m_6907_()) {
            BlockPos origin = player.m_20183_();
            AABB area = new AABB(origin).m_82400_(96.0);
            List mobs = sl.m_45976_(Mob.class, area);
            int allowedCount = 0;
            for (Mob mob : mobs) {
                if (mob.m_6095_() != allowedType) continue;
                ++allowedCount;
            }
            if (allowedCount >= desiredPerPlayer) continue;
            int toSpawn = Math.max(minSpawnBatch, desiredPerPlayer - allowedCount);
            int spawned = 0;
            for (int attempts = 0; spawned < toSpawn && attempts < 6 * toSpawn; ++attempts) {
                Mob mob;
                int spawnZ;
                int spawnX;
                BlockPos surface;
                int offsetX = random.m_188503_(145) - 72;
                int offsetZ = random.m_188503_(145) - 72;
                if (Math.abs(offsetX) < 10 && Math.abs(offsetZ) < 10 || (surface = DimRules.findSpawnSurface(sl, spawnX = origin.m_123341_() + offsetX, spawnZ = origin.m_123343_() + offsetZ)) == null || (mob = (Mob)allowedType.m_20615_((Level)sl)) == null) continue;
                mob.m_7678_((double)surface.m_123341_() + 0.5, (double)surface.m_123342_(), (double)surface.m_123343_() + 0.5, random.m_188501_() * 360.0f, 0.0f);
                mob.m_21530_();
                sl.m_7967_((Entity)mob);
                ++spawned;
            }
        }
    }

    private static BlockPos findSpawnSurface(ServerLevel sl, int x, int z) {
        int topY = sl.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
        if (topY <= sl.m_141937_()) {
            return null;
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos(x, topY, z);
        while (cursor.m_123342_() > sl.m_141937_() && sl.m_8055_((BlockPos)cursor).m_60795_()) {
            cursor.m_122173_(Direction.DOWN);
        }
        BlockPos surface = cursor.m_7494_();
        if (!sl.m_46749_(surface)) {
            return null;
        }
        if (!sl.m_8055_(surface).m_60795_()) {
            return null;
        }
        BlockState below = sl.m_8055_(surface.m_7495_());
        if (!below.m_280296_() || !below.m_60783_((BlockGetter)sl, surface.m_7495_(), Direction.UP)) {
            return null;
        }
        return surface.m_7949_();
    }

    private static void applyTwilightCorruption(ServerLevel sl) {
        if (sl.m_6907_().isEmpty()) {
            return;
        }
        if (sl.m_46467_() % 200L != 0L) {
            return;
        }
        RandomSource random = sl.m_213780_();
        for (Player player : sl.m_6907_()) {
            int attempts = 1;
            for (int attempt = 0; attempt < attempts; ++attempt) {
                BlockPos targetPos;
                BlockState current;
                int worldZ;
                int offsetX = random.m_188503_(65) - 32;
                int offsetZ = random.m_188503_(65) - 32;
                int worldX = player.m_20183_().m_123341_() + offsetX;
                int surfaceY = sl.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, worldX, worldZ = player.m_20183_().m_123343_() + offsetZ) - 1;
                if (surfaceY <= sl.m_141937_() || !DimRules.isOverworldSurface(current = sl.m_8055_(targetPos = new BlockPos(worldX, surfaceY, worldZ)))) continue;
                sl.m_7731_(targetPos, Blocks.f_50134_.m_49966_(), 2);
                BlockPos above = targetPos.m_7494_();
                if (!(random.m_188501_() < 0.25f) || !sl.m_8055_(above).m_60795_()) continue;
                BlockState deco = random.m_188499_() ? Blocks.f_50654_.m_49966_() : Blocks.f_50691_.m_49966_();
                sl.m_7731_(above, deco, 2);
            }
        }
    }

    private static boolean isOverworldSurface(BlockState state) {
        Block block = state.m_60734_();
        return block == Blocks.f_50440_ || block == Blocks.f_50493_ || block == Blocks.f_50546_ || block == Blocks.f_50599_ || block == Blocks.f_50069_ || block == Blocks.f_49994_ || block == Blocks.f_49992_ || block == Blocks.f_49993_ || block == Blocks.f_50195_;
    }

    @SubscribeEvent
    public static void onItemEntitySpawn(EntityJoinLevelEvent event) {
        try {
            Level level = event.getLevel();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel sl = (ServerLevel)level;
            Entity entity = event.getEntity();
            if (!(entity instanceof ItemEntity)) {
                return;
            }
            ItemEntity itemEntity = (ItemEntity)entity;
            String dimId = sl.m_46472_().m_135782_().m_135815_();
            ItemStack item = itemEntity.m_32055_();
            if (item == null || item.m_41619_()) {
                return;
            }
            Map<Block, Integer> dimensionMultipliers = ORE_DROP_MULTIPLIERS.get(dimId);
            if (dimensionMultipliers == null || dimensionMultipliers.isEmpty()) {
                return;
            }
            for (Map.Entry<Block, Integer> entry : dimensionMultipliers.entrySet()) {
                Block ore = entry.getKey();
                int multiplier = entry.getValue();
                if (!DimRules.isFromOreBlock(ore, item)) continue;
                int newCount = Math.min(item.m_41741_(), item.m_41613_() * multiplier);
                item.m_41764_(newCount);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isFromOreBlock(Block ore, ItemStack drop) {
        if (ore == Blocks.f_49996_ || ore == Blocks.f_152468_) {
            return drop.m_41720_() == Items.f_151050_;
        }
        if (ore == Blocks.f_49995_ || ore == Blocks.f_152467_) {
            return drop.m_41720_() == Items.f_151053_;
        }
        if (ore == Blocks.f_50089_ || ore == Blocks.f_152474_) {
            return drop.m_41720_() == Items.f_42415_;
        }
        if (ore == Blocks.f_49997_ || ore == Blocks.f_152469_) {
            return drop.m_41720_() == Items.f_42413_;
        }
        return false;
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (DimRules.isDlrowrevo(sl) && DLROWREVO_PASSIVES.contains(mob.m_6095_()) && mob instanceof PathfinderMob) {
                PathfinderMob pathfinder = (PathfinderMob)mob;
                pathfinder.f_21345_.m_25352_(2, (Goal)new PassiveAttackGoal(pathfinder, 1.2, 2.0f));
                pathfinder.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)pathfinder, Player.class, true));
            }
        }
    }

    private static boolean isDlrowrevo(ServerLevel sl) {
        return sl.m_46472_().m_135782_().equals((Object)new ResourceLocation("slidersmod", "dlrowrevo"));
    }

    @SubscribeEvent
    public static void onChangeTarget(LivingChangeTargetEvent event) {
        Mob mob;
        block6: {
            block5: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Mob)) break block5;
                mob = (Mob)livingEntity;
                if (event.getNewTarget() != null) break block6;
            }
            return;
        }
        Level level = mob.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        if (DimRules.isDlrowrevo(sl) && mob instanceof Monster && event.getNewTarget() instanceof Player) {
            event.setCanceled(true);
            mob.m_6710_(null);
        }
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        String dim = sl.m_46472_().m_135782_().m_135815_();
        if (dim.equals("eclipse") || dim.equals("alternate1") || dim.equals("twilight_world") || dim.equals("necropole")) {
            event.setAmount(event.getAmount() * 2.0f);
        }
    }

    private record PopulationTarget(EntityType<? extends Mob> type, int desiredPerPlayer, int minBatch) {
    }

    private static class PassiveAttackGoal
    extends Goal {
        private final PathfinderMob mob;
        private final double speed;
        private final float damage;
        private int attackCooldown;

        public PassiveAttackGoal(PathfinderMob mob, double speed, float damage) {
            this.mob = mob;
            this.speed = speed;
            this.damage = damage;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8041_() {
            this.mob.m_21573_().m_26573_();
            this.mob.m_6710_(null);
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            if (target == null) {
                return;
            }
            this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            this.mob.m_21573_().m_5624_((Entity)target, this.speed);
            double reachSq = (double)(this.mob.m_20205_() * 2.0f) * (double)(this.mob.m_20205_() * 2.0f) + (double)target.m_20205_();
            if (this.mob.m_20280_((Entity)target) <= reachSq && this.attackCooldown <= 0) {
                target.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), this.damage);
                this.attackCooldown = 20;
            }
            if (this.attackCooldown > 0) {
                --this.attackCooldown;
            }
        }
    }
}

