/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.entity;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.dimension.DimensionManager;
import com.michelmuscle.slidersmod.entity.VortexEntity;
import com.michelmuscle.slidersmod.init.ModEntities;
import com.michelmuscle.slidersmod.system.DimensionSeedRegistry;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ExodusVortexEntity
extends VortexEntity {
    private String generatedSeed = "";

    public ExodusVortexEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public ExodusVortexEntity(Level level, double x, double y, double z, UUID ownerUUID, ItemStack timerStack, String seed) {
        super((EntityType)ModEntities.EXODUS_VORTEX_ENTITY.get(), level);
        this.m_6034_(x, y, z);
        this.ownerUUID = ownerUUID;
        this.timerStack = timerStack.m_41777_();
        this.f_19804_.m_135381_(LIFETIME, (Object)0);
        this.f_19804_.m_135381_(IS_RETURN_PORTAL, (Object)false);
        this.f_19804_.m_135381_(IS_EXODUS_VORTEX, (Object)true);
        if (!level.f_46443_) {
            ServerLevel serverLevel = (ServerLevel)level;
            DimensionSeedRegistry registry = DimensionSeedRegistry.get(serverLevel.m_7654_());
            DimensionSeedRegistry.SeedDestination destination = registry.getDestination(seed);
            if (destination != null) {
                this.cachedDestination = new DimensionManager.RandomDestination(destination.dimension, destination.position);
                SlidersMod.LOGGER.info("ExodusVortexEntity created with seed {} -> destination: {} at {}", new Object[]{seed, destination.dimension.m_135782_(), destination.position});
            } else {
                SlidersMod.LOGGER.error("Invalid seed {}! Destination not found, falling back to random destination.", (Object)seed);
                this.cachedDestination = DimensionManager.generateRandomDestination(serverLevel.m_7654_(), DimensionManager.getTimerTier(timerStack), false);
            }
        }
    }

    public ExodusVortexEntity(Level level, double x, double y, double z, UUID ownerUUID, ItemStack timerStack) {
        super((EntityType)ModEntities.EXODUS_VORTEX_ENTITY.get(), level);
        this.m_6034_(x, y, z);
        this.ownerUUID = ownerUUID;
        this.timerStack = timerStack.m_41777_();
        this.f_19804_.m_135381_(LIFETIME, (Object)0);
        this.f_19804_.m_135381_(IS_RETURN_PORTAL, (Object)false);
        this.f_19804_.m_135381_(IS_EXODUS_VORTEX, (Object)true);
        if (!level.f_46443_) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.cachedDestination = DimensionManager.generateRandomDestination(serverLevel.m_7654_(), DimensionManager.getTimerTier(timerStack), false);
            SlidersMod.LOGGER.info("ExodusVortexEntity created with random destination: {} (IsExodusVortex=true)", this.cachedDestination != null ? this.cachedDestination.dimension.m_135782_() : "null");
        }
    }

    public ExodusVortexEntity(Level level, double x, double y, double z, boolean isReturnPortal, boolean alreadyUsed, ResourceKey<Level> dimension, BlockPos position) {
        super((EntityType)ModEntities.EXODUS_VORTEX_ENTITY.get(), level);
        this.m_6034_(x, y, z);
        this.f_19804_.m_135381_(LIFETIME, (Object)0);
        this.f_19804_.m_135381_(IS_RETURN_PORTAL, (Object)isReturnPortal);
        this.f_19804_.m_135381_(IS_EXODUS_VORTEX, (Object)true);
        if (alreadyUsed) {
            this.f_19804_.m_135381_(HAS_BEEN_USED, (Object)true);
            this.usedAtTick = 0;
        }
        if (!level.f_46443_ && isReturnPortal) {
            String seed;
            ServerLevel serverLevel = (ServerLevel)level;
            DimensionSeedRegistry registry = DimensionSeedRegistry.get(serverLevel.m_7654_());
            this.generatedSeed = seed = registry.generateUniqueSeed();
            registry.registerSeed(seed, dimension, position);
            SlidersMod.LOGGER.info("ExodusVortexEntity aesthetic vortex created: Generated seed {} for {} at {}", new Object[]{seed, dimension.m_135782_(), position});
        }
    }

    public ExodusVortexEntity(Level level, double x, double y, double z, boolean isReturnPortal) {
        this(level, x, y, z, isReturnPortal, false, (ResourceKey<Level>)Level.f_46428_, BlockPos.f_121853_);
    }

    @Override
    public boolean isExodusVortex() {
        return true;
    }

    @Override
    protected VortexEntity createAestheticVortex(ServerLevel targetLevel, double x, double y, double z) {
        if (this.cachedDestination != null) {
            ExodusVortexEntity aestheticVortex = new ExodusVortexEntity((Level)targetLevel, x, y, z, true, true, this.cachedDestination.dimension, this.cachedDestination.pos);
            return aestheticVortex;
        }
        SlidersMod.LOGGER.error("Cannot create aesthetic ExodusVortex: cachedDestination is null!");
        return new ExodusVortexEntity((Level)targetLevel, x, y, z, true);
    }

    public String getGeneratedSeed() {
        return this.generatedSeed;
    }
}

