/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LoganVortexBorderObjEntity
extends Entity {
    private static final Vector3f DEFAULT_AXIS_W = new Vector3f(1.0f, 0.0f, 0.0f);
    private static final Vector3f DEFAULT_AXIS_H = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final Vector3f DEFAULT_NORMAL = new Vector3f(0.0f, 0.0f, 1.0f);
    public static final int FADE_IN_TICKS = 10;
    private static final EntityDataAccessor<Vector3f> DATA_AXIS_W = SynchedEntityData.m_135353_(LoganVortexBorderObjEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Vector3f> DATA_AXIS_H = SynchedEntityData.m_135353_(LoganVortexBorderObjEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Vector3f> DATA_NORMAL = SynchedEntityData.m_135353_(LoganVortexBorderObjEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Boolean> DATA_FADING_OUT = SynchedEntityData.m_135353_(LoganVortexBorderObjEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_FADE_START_TICK = SynchedEntityData.m_135353_(LoganVortexBorderObjEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public LoganVortexBorderObjEntity(EntityType<? extends LoganVortexBorderObjEntity> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_AXIS_W, (Object)new Vector3f((Vector3fc)DEFAULT_AXIS_W));
        this.f_19804_.m_135372_(DATA_AXIS_H, (Object)new Vector3f((Vector3fc)DEFAULT_AXIS_H));
        this.f_19804_.m_135372_(DATA_NORMAL, (Object)new Vector3f((Vector3fc)DEFAULT_NORMAL));
        this.f_19804_.m_135372_(DATA_FADING_OUT, (Object)false);
        this.f_19804_.m_135372_(DATA_FADE_START_TICK, (Object)0);
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("AxisW")) {
            this.f_19804_.m_135381_(DATA_AXIS_W, (Object)LoganVortexBorderObjEntity.toVector3f(LoganVortexBorderObjEntity.vecFromTag(tag.m_128469_("AxisW"))));
        }
        if (tag.m_128441_("AxisH")) {
            this.f_19804_.m_135381_(DATA_AXIS_H, (Object)LoganVortexBorderObjEntity.toVector3f(LoganVortexBorderObjEntity.vecFromTag(tag.m_128469_("AxisH"))));
        }
        if (tag.m_128441_("Normal")) {
            this.f_19804_.m_135381_(DATA_NORMAL, (Object)LoganVortexBorderObjEntity.toVector3f(LoganVortexBorderObjEntity.vecFromTag(tag.m_128469_("Normal"))));
        }
        if (tag.m_128441_("FadingOut")) {
            this.f_19804_.m_135381_(DATA_FADING_OUT, (Object)tag.m_128471_("FadingOut"));
        }
        if (tag.m_128441_("FadeStart")) {
            this.f_19804_.m_135381_(DATA_FADE_START_TICK, (Object)tag.m_128451_("FadeStart"));
        }
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128365_("AxisW", (Tag)LoganVortexBorderObjEntity.vecToTag(this.getAxisW()));
        tag.m_128365_("AxisH", (Tag)LoganVortexBorderObjEntity.vecToTag(this.getAxisH()));
        tag.m_128365_("Normal", (Tag)LoganVortexBorderObjEntity.vecToTag(this.getNormal()));
        tag.m_128379_("FadingOut", this.isFadingOut());
        tag.m_128405_("FadeStart", ((Integer)this.f_19804_.m_135370_(DATA_FADE_START_TICK)).intValue());
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20242_(true);
        this.f_19794_ = true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void configureOrientation(Vec3 axisW, Vec3 axisH, Vec3 normal) {
        Vec3 normalizedW = LoganVortexBorderObjEntity.normalizeOrDefault(axisW, LoganVortexBorderObjEntity.toVec(DEFAULT_AXIS_W));
        Vec3 normalizedH = LoganVortexBorderObjEntity.normalizeOrDefault(axisH, LoganVortexBorderObjEntity.toVec(DEFAULT_AXIS_H));
        Vec3 normalizedN = LoganVortexBorderObjEntity.normalizeOrDefault(normal, LoganVortexBorderObjEntity.toVec(DEFAULT_NORMAL));
        this.f_19804_.m_135381_(DATA_AXIS_W, (Object)LoganVortexBorderObjEntity.toVector3f(normalizedW));
        this.f_19804_.m_135381_(DATA_AXIS_H, (Object)LoganVortexBorderObjEntity.toVector3f(normalizedH));
        this.f_19804_.m_135381_(DATA_NORMAL, (Object)LoganVortexBorderObjEntity.toVector3f(normalizedN));
    }

    public Vec3 getAxisW() {
        return LoganVortexBorderObjEntity.toVec((Vector3f)this.f_19804_.m_135370_(DATA_AXIS_W));
    }

    public Vec3 getAxisH() {
        return LoganVortexBorderObjEntity.toVec((Vector3f)this.f_19804_.m_135370_(DATA_AXIS_H));
    }

    public Vec3 getNormal() {
        return LoganVortexBorderObjEntity.toVec((Vector3f)this.f_19804_.m_135370_(DATA_NORMAL));
    }

    private static Vec3 normalizeOrDefault(Vec3 vec, Vec3 fallback) {
        if (vec.m_82556_() < 1.0E-6) {
            return fallback;
        }
        Vec3 normalized = vec.m_82541_();
        if (normalized.m_82556_() < 1.0E-6) {
            return fallback;
        }
        return normalized;
    }

    private static CompoundTag vecToTag(Vec3 vec) {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("x", vec.f_82479_);
        tag.m_128347_("y", vec.f_82480_);
        tag.m_128347_("z", vec.f_82481_);
        return tag;
    }

    private static Vec3 vecFromTag(CompoundTag tag) {
        return new Vec3(tag.m_128459_("x"), tag.m_128459_("y"), tag.m_128459_("z"));
    }

    private static Vector3f toVector3f(Vec3 vec) {
        return new Vector3f((float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_);
    }

    private static Vec3 toVec(Vector3f vector) {
        return new Vec3((double)vector.x(), (double)vector.y(), (double)vector.z());
    }

    public float getScaleFactor(float partialTicks) {
        if (this.isFadingOut()) {
            float start = ((Integer)this.f_19804_.m_135370_(DATA_FADE_START_TICK)).intValue();
            float elapsed = (float)(this.m_9236_() != null ? this.m_9236_().m_46467_() : 0L) + partialTicks - start;
            return Mth.m_14036_((float)(1.0f - elapsed / 10.0f), (float)0.0f, (float)1.0f);
        }
        return Mth.m_14036_((float)(((float)this.f_19797_ + partialTicks) / 10.0f), (float)0.0f, (float)1.0f);
    }

    public void startFadeOut() {
        this.f_19804_.m_135381_(DATA_FADING_OUT, (Object)true);
        int startTick = (int)(this.m_9236_() != null ? this.m_9236_().m_46467_() : 0L);
        this.f_19804_.m_135381_(DATA_FADE_START_TICK, (Object)startTick);
    }

    private boolean isFadingOut() {
        return (Boolean)this.f_19804_.m_135370_(DATA_FADING_OUT);
    }
}

