/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.entity;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class OgVortexBackObjEntity
extends Entity {
    private static final Vector3f DEFAULT_AXIS_W = new Vector3f(1.0f, 0.0f, 0.0f);
    private static final Vector3f DEFAULT_AXIS_H = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final Vector3f DEFAULT_NORMAL = new Vector3f(0.0f, 0.0f, 1.0f);
    private static final EntityDataAccessor<Vector3f> DATA_AXIS_W = SynchedEntityData.m_135353_(OgVortexBackObjEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Vector3f> DATA_AXIS_H = SynchedEntityData.m_135353_(OgVortexBackObjEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Vector3f> DATA_NORMAL = SynchedEntityData.m_135353_(OgVortexBackObjEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Boolean> DATA_VISIBLE = SynchedEntityData.m_135353_(OgVortexBackObjEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> DATA_CUSTOM_TEXTURE = SynchedEntityData.m_135353_(OgVortexBackObjEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> DATA_CUSTOM_TINT = SynchedEntityData.m_135353_(OgVortexBackObjEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int spawnDelayTicks = 0;
    @Nullable
    private UUID ownerVortexId = null;

    public OgVortexBackObjEntity(EntityType<? extends OgVortexBackObjEntity> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_AXIS_W, (Object)new Vector3f((Vector3fc)DEFAULT_AXIS_W));
        this.f_19804_.m_135372_(DATA_AXIS_H, (Object)new Vector3f((Vector3fc)DEFAULT_AXIS_H));
        this.f_19804_.m_135372_(DATA_NORMAL, (Object)new Vector3f((Vector3fc)DEFAULT_NORMAL));
        this.f_19804_.m_135372_(DATA_VISIBLE, (Object)true);
        this.f_19804_.m_135372_(DATA_CUSTOM_TEXTURE, (Object)"");
        this.f_19804_.m_135372_(DATA_CUSTOM_TINT, (Object)0xFFFFFF);
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128365_("AxisW", (Tag)OgVortexBackObjEntity.vecToTag(this.getAxisW()));
        tag.m_128365_("AxisH", (Tag)OgVortexBackObjEntity.vecToTag(this.getAxisH()));
        tag.m_128365_("Normal", (Tag)OgVortexBackObjEntity.vecToTag(this.getNormal()));
        tag.m_128405_("SpawnDelay", this.spawnDelayTicks);
        tag.m_128379_("Visible", ((Boolean)this.f_19804_.m_135370_(DATA_VISIBLE)).booleanValue());
        String customTexture = (String)this.f_19804_.m_135370_(DATA_CUSTOM_TEXTURE);
        if (!customTexture.isEmpty()) {
            tag.m_128359_("CustomTexture", customTexture);
        }
        tag.m_128405_("CustomTint", ((Integer)this.f_19804_.m_135370_(DATA_CUSTOM_TINT)).intValue());
        if (this.ownerVortexId != null) {
            tag.m_128362_("OwnerVortex", this.ownerVortexId);
        }
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("AxisW")) {
            this.f_19804_.m_135381_(DATA_AXIS_W, (Object)OgVortexBackObjEntity.toVector3f(OgVortexBackObjEntity.vecFromTag(tag.m_128469_("AxisW"))));
        }
        if (tag.m_128441_("AxisH")) {
            this.f_19804_.m_135381_(DATA_AXIS_H, (Object)OgVortexBackObjEntity.toVector3f(OgVortexBackObjEntity.vecFromTag(tag.m_128469_("AxisH"))));
        }
        if (tag.m_128441_("Normal")) {
            this.f_19804_.m_135381_(DATA_NORMAL, (Object)OgVortexBackObjEntity.toVector3f(OgVortexBackObjEntity.vecFromTag(tag.m_128469_("Normal"))));
        }
        if (tag.m_128441_("SpawnDelay")) {
            this.spawnDelayTicks = tag.m_128451_("SpawnDelay");
        }
        this.f_19804_.m_135381_(DATA_VISIBLE, (Object)(!tag.m_128441_("Visible") || tag.m_128471_("Visible") ? 1 : 0));
        if (tag.m_128441_("CustomTexture")) {
            this.f_19804_.m_135381_(DATA_CUSTOM_TEXTURE, (Object)tag.m_128461_("CustomTexture"));
        }
        if (tag.m_128441_("CustomTint")) {
            this.f_19804_.m_135381_(DATA_CUSTOM_TINT, (Object)tag.m_128451_("CustomTint"));
        }
        if (tag.m_128403_("OwnerVortex")) {
            this.ownerVortexId = tag.m_128342_("OwnerVortex");
        }
    }

    public void m_8119_() {
        ServerLevel server;
        Entity owner;
        Level level;
        super.m_8119_();
        this.m_20242_(true);
        this.f_19794_ = true;
        if (!(this.m_9236_().f_46443_ || this.ownerVortexId == null || !((level = this.m_9236_()) instanceof ServerLevel) || (owner = (server = (ServerLevel)level).m_8791_(this.ownerVortexId)) != null && owner.m_6084_())) {
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().f_46443_ && this.spawnDelayTicks > 0) {
            --this.spawnDelayTicks;
            if (this.spawnDelayTicks <= 0) {
                this.f_19804_.m_135381_(DATA_VISIBLE, (Object)true);
            }
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void configureOrientation(Vec3 axisW, Vec3 axisH, Vec3 normal) {
        Vec3 normalizedW = OgVortexBackObjEntity.normalizeOrDefault(axisW, OgVortexBackObjEntity.toVec(DEFAULT_AXIS_W));
        Vec3 normalizedH = OgVortexBackObjEntity.normalizeOrDefault(axisH, OgVortexBackObjEntity.toVec(DEFAULT_AXIS_H));
        Vec3 normalizedN = OgVortexBackObjEntity.normalizeOrDefault(normal, OgVortexBackObjEntity.toVec(DEFAULT_NORMAL));
        this.f_19804_.m_135381_(DATA_AXIS_W, (Object)OgVortexBackObjEntity.toVector3f(normalizedW));
        this.f_19804_.m_135381_(DATA_AXIS_H, (Object)OgVortexBackObjEntity.toVector3f(normalizedH));
        this.f_19804_.m_135381_(DATA_NORMAL, (Object)OgVortexBackObjEntity.toVector3f(normalizedN));
    }

    public Vec3 getAxisW() {
        return OgVortexBackObjEntity.toVec((Vector3f)this.f_19804_.m_135370_(DATA_AXIS_W));
    }

    public Vec3 getAxisH() {
        return OgVortexBackObjEntity.toVec((Vector3f)this.f_19804_.m_135370_(DATA_AXIS_H));
    }

    public Vec3 getNormal() {
        return OgVortexBackObjEntity.toVec((Vector3f)this.f_19804_.m_135370_(DATA_NORMAL));
    }

    public void setSpawnDelay(int ticks) {
        this.spawnDelayTicks = Math.max(0, ticks);
        this.f_19804_.m_135381_(DATA_VISIBLE, (Object)(this.spawnDelayTicks <= 0 ? 1 : 0));
    }

    public void setOwnerVortex(@Nullable UUID ownerId) {
        this.ownerVortexId = ownerId;
    }

    public boolean isVisible() {
        return (Boolean)this.f_19804_.m_135370_(DATA_VISIBLE);
    }

    public void hide() {
        this.f_19804_.m_135381_(DATA_VISIBLE, (Object)false);
    }

    public void setCustomAppearance(@Nullable String textureId, int tint) {
        this.f_19804_.m_135381_(DATA_CUSTOM_TEXTURE, (Object)(textureId == null ? "" : textureId));
        this.f_19804_.m_135381_(DATA_CUSTOM_TINT, (Object)tint);
    }

    public String getCustomTextureId() {
        return (String)this.f_19804_.m_135370_(DATA_CUSTOM_TEXTURE);
    }

    public int getCustomTint() {
        return (Integer)this.f_19804_.m_135370_(DATA_CUSTOM_TINT);
    }

    public boolean hasCustomAppearance() {
        return !this.getCustomTextureId().isEmpty();
    }

    private static Vec3 normalizeOrDefault(Vec3 vec, Vec3 fallback) {
        if (vec.m_82556_() < 1.0E-6) {
            return fallback;
        }
        Vec3 normalized = vec.m_82541_();
        if (normalized.m_82556_() < 1.0E-6) {
            return fallback;
        }
        return normalized;
    }

    private static CompoundTag vecToTag(Vec3 vec) {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("x", vec.f_82479_);
        tag.m_128347_("y", vec.f_82480_);
        tag.m_128347_("z", vec.f_82481_);
        return tag;
    }

    private static Vec3 vecFromTag(CompoundTag tag) {
        return new Vec3(tag.m_128459_("x"), tag.m_128459_("y"), tag.m_128459_("z"));
    }

    private static Vector3f toVector3f(Vec3 vec) {
        return new Vector3f((float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_);
    }

    private static Vec3 toVec(Vector3f vector) {
        return new Vec3((double)vector.x(), (double)vector.y(), (double)vector.z());
    }
}

