/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VortexCollisionObjEntity
extends Entity {
    private static final double COLLISION_RADIUS = 1.5;
    private static final double COLLISION_THICKNESS = 0.35;
    private static final double COLLISION_MARGIN = 0.1;
    private static final Vector3f DEFAULT_AXIS_W = new Vector3f(1.0f, 0.0f, 0.0f);
    private static final Vector3f DEFAULT_AXIS_H = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final Vector3f DEFAULT_NORMAL = new Vector3f(0.0f, 0.0f, 1.0f);
    private static final EntityDataAccessor<Integer> DATA_ROLE = SynchedEntityData.m_135353_(VortexCollisionObjEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.m_135353_(VortexCollisionObjEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_KNOCKBACK = SynchedEntityData.m_135353_(VortexCollisionObjEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Vector3f> DATA_AXIS_W = SynchedEntityData.m_135353_(VortexCollisionObjEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Vector3f> DATA_AXIS_H = SynchedEntityData.m_135353_(VortexCollisionObjEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Vector3f> DATA_NORMAL = SynchedEntityData.m_135353_(VortexCollisionObjEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private ResourceLocation collisionModel;

    public VortexCollisionObjEntity(EntityType<? extends VortexCollisionObjEntity> type, Level level) {
        super(type, level);
        this.m_6842_(true);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_AXIS_W, (Object)new Vector3f((Vector3fc)DEFAULT_AXIS_W));
        this.f_19804_.m_135372_(DATA_AXIS_H, (Object)new Vector3f((Vector3fc)DEFAULT_AXIS_H));
        this.f_19804_.m_135372_(DATA_NORMAL, (Object)new Vector3f((Vector3fc)DEFAULT_NORMAL));
        this.f_19804_.m_135372_(DATA_ROLE, (Object)CollisionRole.FRONT.ordinal());
        this.f_19804_.m_135372_(DATA_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_KNOCKBACK, (Object)Float.valueOf(0.0f));
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20242_(true);
        this.f_19794_ = true;
        this.m_6842_(true);
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("AxisW")) {
            this.f_19804_.m_135381_(DATA_AXIS_W, (Object)VortexCollisionObjEntity.toVector3f(VortexCollisionObjEntity.vecFromTag(tag.m_128469_("AxisW"))));
        }
        if (tag.m_128441_("AxisH")) {
            this.f_19804_.m_135381_(DATA_AXIS_H, (Object)VortexCollisionObjEntity.toVector3f(VortexCollisionObjEntity.vecFromTag(tag.m_128469_("AxisH"))));
        }
        if (tag.m_128441_("Normal")) {
            this.f_19804_.m_135381_(DATA_NORMAL, (Object)VortexCollisionObjEntity.toVector3f(VortexCollisionObjEntity.vecFromTag(tag.m_128469_("Normal"))));
        }
        if (tag.m_128441_("CollisionRole")) {
            this.f_19804_.m_135381_(DATA_ROLE, (Object)tag.m_128451_("CollisionRole"));
        }
        if (tag.m_128441_("Damage")) {
            this.f_19804_.m_135381_(DATA_DAMAGE, (Object)Float.valueOf(tag.m_128457_("Damage")));
        }
        if (tag.m_128441_("Knockback")) {
            this.f_19804_.m_135381_(DATA_KNOCKBACK, (Object)Float.valueOf(tag.m_128457_("Knockback")));
        }
        if (tag.m_128441_("CollisionModel")) {
            this.collisionModel = ResourceLocation.m_135820_((String)tag.m_128461_("CollisionModel"));
        }
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128365_("AxisW", (Tag)VortexCollisionObjEntity.vecToTag(this.getAxisW()));
        tag.m_128365_("AxisH", (Tag)VortexCollisionObjEntity.vecToTag(this.getAxisH()));
        tag.m_128365_("Normal", (Tag)VortexCollisionObjEntity.vecToTag(this.getNormal()));
        tag.m_128405_("CollisionRole", ((Integer)this.f_19804_.m_135370_(DATA_ROLE)).intValue());
        tag.m_128350_("Damage", ((Float)this.f_19804_.m_135370_(DATA_DAMAGE)).floatValue());
        tag.m_128350_("Knockback", ((Float)this.f_19804_.m_135370_(DATA_KNOCKBACK)).floatValue());
        if (this.collisionModel != null) {
            tag.m_128359_("CollisionModel", this.collisionModel.toString());
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void configurePlacement(Vec3 center, Vec3 axisW, Vec3 axisH, Vec3 normal) {
        this.m_7678_(center.f_82479_, center.f_82480_, center.f_82481_, 0.0f, 0.0f);
        this.f_19804_.m_135381_(DATA_AXIS_W, (Object)VortexCollisionObjEntity.toVector3f(VortexCollisionObjEntity.normalizeOrDefault(axisW, VortexCollisionObjEntity.toVec(DEFAULT_AXIS_W))));
        this.f_19804_.m_135381_(DATA_AXIS_H, (Object)VortexCollisionObjEntity.toVector3f(VortexCollisionObjEntity.normalizeOrDefault(axisH, VortexCollisionObjEntity.toVec(DEFAULT_AXIS_H))));
        this.f_19804_.m_135381_(DATA_NORMAL, (Object)VortexCollisionObjEntity.toVector3f(VortexCollisionObjEntity.normalizeOrDefault(normal, VortexCollisionObjEntity.toVec(DEFAULT_NORMAL))));
    }

    public void configureRole(CollisionRole role, float damageHearts, float knockbackStrength) {
        this.f_19804_.m_135381_(DATA_ROLE, (Object)role.ordinal());
        this.f_19804_.m_135381_(DATA_DAMAGE, (Object)Float.valueOf(Math.max(damageHearts, 0.0f)));
        this.f_19804_.m_135381_(DATA_KNOCKBACK, (Object)Float.valueOf(Math.max(knockbackStrength, 0.0f)));
    }

    public boolean isEntityTouching(Entity entity) {
        Vec3[] samplePoints;
        AABB box = entity.m_20191_();
        if (box == null) {
            return false;
        }
        for (Vec3 point : samplePoints = this.getSamplePoints(box)) {
            if (!this.isPointInside(point)) continue;
            return true;
        }
        return false;
    }

    private boolean isPointInside(Vec3 point) {
        double radiusSq;
        double height;
        Vec3 rel = point.m_82546_(this.m_20182_());
        Vec3 axisW = this.getAxisW();
        Vec3 axisH = this.getAxisH();
        Vec3 normal = this.getNormal();
        double depthSigned = rel.m_82526_(normal);
        double depthAbs = Math.abs(depthSigned);
        CollisionRole role = this.getRole();
        if (role == CollisionRole.FRONT ? depthSigned > 0.1 : depthSigned < -0.1) {
            return false;
        }
        if (depthAbs > 0.44999999999999996) {
            return false;
        }
        double width = rel.m_82526_(axisW);
        double planarDistanceSq = width * width + (height = rel.m_82526_(axisH)) * height;
        return planarDistanceSq <= (radiusSq = 2.5600000000000005);
    }

    public CollisionRole getRole() {
        int idx = (Integer)this.f_19804_.m_135370_(DATA_ROLE);
        if (idx < 0 || idx >= CollisionRole.values().length) {
            return CollisionRole.FRONT;
        }
        return CollisionRole.values()[idx];
    }

    public float getDamageAmount() {
        return ((Float)this.f_19804_.m_135370_(DATA_DAMAGE)).floatValue();
    }

    public float getKnockback() {
        return ((Float)this.f_19804_.m_135370_(DATA_KNOCKBACK)).floatValue();
    }

    public void setCollisionModel(ResourceLocation model) {
        this.collisionModel = model;
    }

    @Nullable
    public ResourceLocation getCollisionModel() {
        return this.collisionModel;
    }

    private Vec3[] getSamplePoints(AABB box) {
        return new Vec3[]{new Vec3(box.f_82288_, box.f_82289_, box.f_82290_), new Vec3(box.f_82288_, box.f_82289_, box.f_82293_), new Vec3(box.f_82288_, box.f_82292_, box.f_82290_), new Vec3(box.f_82288_, box.f_82292_, box.f_82293_), new Vec3(box.f_82291_, box.f_82289_, box.f_82290_), new Vec3(box.f_82291_, box.f_82289_, box.f_82293_), new Vec3(box.f_82291_, box.f_82292_, box.f_82290_), new Vec3(box.f_82291_, box.f_82292_, box.f_82293_), box.m_82399_()};
    }

    private Vec3 getAxisW() {
        return VortexCollisionObjEntity.toVec((Vector3f)this.f_19804_.m_135370_(DATA_AXIS_W));
    }

    private Vec3 getAxisH() {
        return VortexCollisionObjEntity.toVec((Vector3f)this.f_19804_.m_135370_(DATA_AXIS_H));
    }

    public Vec3 getNormal() {
        return VortexCollisionObjEntity.toVec((Vector3f)this.f_19804_.m_135370_(DATA_NORMAL));
    }

    private static Vec3 normalizeOrDefault(Vec3 vec, Vec3 fallback) {
        if (vec.m_82556_() < 1.0E-6) {
            return fallback;
        }
        Vec3 normalized = vec.m_82541_();
        if (normalized.m_82556_() < 1.0E-6) {
            return fallback;
        }
        return normalized;
    }

    private static CompoundTag vecToTag(Vec3 vec) {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("x", vec.f_82479_);
        tag.m_128347_("y", vec.f_82480_);
        tag.m_128347_("z", vec.f_82481_);
        return tag;
    }

    private static Vec3 vecFromTag(CompoundTag tag) {
        return new Vec3(tag.m_128459_("x"), tag.m_128459_("y"), tag.m_128459_("z"));
    }

    private static Vector3f toVector3f(Vec3 vec) {
        return new Vector3f((float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_);
    }

    private static Vec3 toVec(Vector3f vector) {
        return new Vec3((double)vector.x(), (double)vector.y(), (double)vector.z());
    }

    public static enum CollisionRole {
        FRONT,
        BACK;

    }
}

