/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.events;

import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.item.QuantumRelocatorItem;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="slidersmod")
public class GiveQuantumRelocatorCommand {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        LiteralCommandNode<CommandSourceStack> root = GiveQuantumRelocatorCommand.getOrCreateSlidersRoot((CommandDispatcher<CommandSourceStack>)dispatcher);
        root.addChild((CommandNode)GiveQuantumRelocatorCommand.buildGiveQuantumRelocatorBranch().build());
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildGiveQuantumRelocatorBranch() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"givequantumrelocator").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"seed", (ArgumentType)StringArgumentType.word()).executes(ctx -> GiveQuantumRelocatorCommand.execute((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"seed"), ((CommandSourceStack)ctx.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> GiveQuantumRelocatorCommand.execute((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"seed"), EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))));
    }

    private static LiteralCommandNode<CommandSourceStack> getOrCreateSlidersRoot(CommandDispatcher<CommandSourceStack> dispatcher) {
        CommandNode existing = dispatcher.getRoot().getChild("sliders");
        if (existing instanceof LiteralCommandNode) {
            LiteralCommandNode literal = (LiteralCommandNode)existing;
            return literal;
        }
        LiteralCommandNode root = ((LiteralArgumentBuilder)Commands.m_82127_((String)"sliders").requires(src -> src.m_6761_(2))).build();
        dispatcher.getRoot().addChild((CommandNode)root);
        return root;
    }

    private static int execute(CommandSourceStack source, String seed, ServerPlayer target) throws CommandSyntaxException {
        if (!seed.matches("\\d{8}")) {
            source.m_81352_((Component)Component.m_237113_((String)"Le seed doit \u00eatre compos\u00e9 de 8 chiffres. Exemple: 12345678"));
            return 0;
        }
        ItemStack relocator = new ItemStack((ItemLike)ModItems.QUANTUM_RELOCATOR.get());
        QuantumRelocatorItem.encodeSeed(relocator, seed);
        boolean success = target.m_36356_(relocator);
        if (!success) {
            source.m_81352_((Component)Component.m_237113_((String)("L'inventaire de " + target.m_7755_().getString() + " est plein.")));
            return 0;
        }
        source.m_288197_(() -> Component.m_237113_((String)("Quantum Relocator actif avec seed " + seed + " donn\u00e9 \u00e0 " + target.m_7755_().getString())), true);
        return 1;
    }
}

