/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.events;

import com.michelmuscle.slidersmod.dimension.DimensionManager;
import com.michelmuscle.slidersmod.util.TimerUpgradeData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="slidersmod")
public class GiveUpgradeCommand {
    private static final List<String> UPGRADE_IDS = Arrays.asList("cooldown", "overheat", "temporal", "tracker", "seed", "seed_slot", "portal_stability", "window_stabilizer", "dimensional_buffer", "phase_modulator", "crystal_buffer", "advanced_crystal_buffer", "ultimate_crystal_buffer");

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        LiteralCommandNode<CommandSourceStack> root = GiveUpgradeCommand.getOrCreateSlidersRoot((CommandDispatcher<CommandSourceStack>)dispatcher);
        root.addChild((CommandNode)GiveUpgradeCommand.buildGiveUpgradeBranch().build());
        root.addChild((CommandNode)GiveUpgradeCommand.buildGiveAllUpgradeBranch().build());
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildGiveUpgradeBranch() {
        LiteralArgumentBuilder builder = Commands.m_82127_((String)"giveupgrade");
        builder.then(((RequiredArgumentBuilder)Commands.m_82129_((String)"upgrade", (ArgumentType)StringArgumentType.word()).suggests((ctx, sb) -> SharedSuggestionProvider.m_82970_(UPGRADE_IDS, (SuggestionsBuilder)sb)).executes(ctx -> GiveUpgradeCommand.executeSingle((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"upgrade"), ((CommandSourceStack)ctx.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> GiveUpgradeCommand.executeSingle((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"upgrade"), EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))));
        return builder;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildGiveAllUpgradeBranch() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"giveallupgrade").executes(ctx -> GiveUpgradeCommand.executeAll((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_()));
        builder.then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> GiveUpgradeCommand.executeAll((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player"))));
        return builder;
    }

    private static LiteralCommandNode<CommandSourceStack> getOrCreateSlidersRoot(CommandDispatcher<CommandSourceStack> dispatcher) {
        CommandNode existing = dispatcher.getRoot().getChild("sliders");
        if (existing instanceof LiteralCommandNode) {
            LiteralCommandNode literal = (LiteralCommandNode)existing;
            return literal;
        }
        LiteralCommandNode root = ((LiteralArgumentBuilder)Commands.m_82127_((String)"sliders").requires(src -> src.m_6761_(2))).build();
        dispatcher.getRoot().addChild((CommandNode)root);
        return root;
    }

    private static int executeSingle(CommandSourceStack source, String rawUpgrade, ServerPlayer target) throws CommandSyntaxException {
        ItemStack held = target.m_21205_();
        if (held.m_41619_()) {
            source.m_81352_((Component)Component.m_237113_((String)"Player has nothing in their hand."));
            return 0;
        }
        String upgrade = rawUpgrade.toLowerCase(Locale.ROOT);
        boolean applied = GiveUpgradeCommand.applyUpgrade(held, upgrade);
        if (!applied) {
            source.m_81352_((Component)Component.m_237113_((String)("Upgrade '" + upgrade + "' is incompatible or already applied.")));
            return 0;
        }
        target.f_36095_.m_38946_();
        source.m_288197_(() -> Component.m_237113_((String)("Applied upgrade '" + upgrade + "' to " + target.m_7755_().getString() + "'s timer")), true);
        return 1;
    }

    private static int executeAll(CommandSourceStack source, ServerPlayer target) throws CommandSyntaxException {
        long currentDuration;
        CompoundTag tag;
        ItemStack held = target.m_21205_();
        if (held.m_41619_()) {
            source.m_81352_((Component)Component.m_237113_((String)"Player has nothing in their hand."));
            return 0;
        }
        boolean changed = false;
        while (DimensionManager.canUpgradeTimerTier(held)) {
            DimensionManager.upgradeTimerTier(held);
            changed = true;
        }
        while (TimerUpgradeData.canIncreaseCooldownTier(held)) {
            TimerUpgradeData.increaseCooldownTier(held);
            changed = true;
        }
        while (TimerUpgradeData.canDecreaseOverheatChance(held)) {
            TimerUpgradeData.increaseOverheatReductionTier(held);
            changed = true;
        }
        if (TimerUpgradeData.supportsTemporalUpgrade(held)) {
            TimerUpgradeData.increaseTemporalTier(held);
            TimerUpgradeData.increaseTemporalTier(held);
            TimerUpgradeData.increaseTemporalTier(held);
            changed = true;
        }
        if (TimerUpgradeData.canAddTrackerUpgrade(held)) {
            TimerUpgradeData.addTrackerUpgrade(held);
            changed = true;
        }
        if (TimerUpgradeData.canAddSeedUpgrade(held)) {
            TimerUpgradeData.addSeedUpgrade(held);
            changed = true;
        }
        while (TimerUpgradeData.canAddSeedSlot(held)) {
            TimerUpgradeData.increaseSeedSlots(held);
            changed = true;
        }
        if (TimerUpgradeData.canAddPortalStabilityUpgrade(held)) {
            TimerUpgradeData.addPortalStabilityUpgrade(held);
            changed = true;
        }
        if ((tag = held.m_41784_()).m_128471_("IsOverheated")) {
            tag.m_128379_("IsOverheated", false);
            tag.m_128473_("CooldownEndTime");
            tag.m_128473_("IsCooldownOverheat");
            changed = true;
        }
        if (GiveUpgradeCommand.isDamagedTimer(held) && (currentDuration = tag.m_128454_("RemainingTime")) > 0L) {
            int divisor = 4 + (int)(Math.random() * 6.0);
            long newDuration = currentDuration / (long)divisor;
            tag.m_128356_("RemainingTime", newDuration);
            changed = true;
        }
        if (!changed) {
            source.m_81352_((Component)Component.m_237113_((String)("No applicable upgrades for " + target.m_7755_().getString() + "'s timer")));
            return 0;
        }
        target.f_36095_.m_38946_();
        source.m_288197_(() -> Component.m_237113_((String)("Applied all possible upgrades to " + target.m_7755_().getString() + "'s timer")), true);
        return 1;
    }

    private static boolean applyUpgrade(ItemStack stack, String upgrade) {
        switch (upgrade) {
            case "cooldown": {
                if (TimerUpgradeData.canIncreaseCooldownTier(stack)) {
                    TimerUpgradeData.increaseCooldownTier(stack);
                    return true;
                }
                return false;
            }
            case "overheat": {
                if (TimerUpgradeData.canDecreaseOverheatChance(stack)) {
                    TimerUpgradeData.increaseOverheatReductionTier(stack);
                    return true;
                }
                return false;
            }
            case "temporal": {
                if (TimerUpgradeData.supportsTemporalUpgrade(stack)) {
                    TimerUpgradeData.increaseTemporalTier(stack);
                    return true;
                }
                return false;
            }
            case "tracker": {
                if (TimerUpgradeData.canAddTrackerUpgrade(stack)) {
                    TimerUpgradeData.addTrackerUpgrade(stack);
                    return true;
                }
                return false;
            }
            case "seed": {
                if (TimerUpgradeData.canAddSeedUpgrade(stack)) {
                    TimerUpgradeData.addSeedUpgrade(stack);
                    return true;
                }
                return false;
            }
            case "seed_slot": {
                if (TimerUpgradeData.canAddSeedSlot(stack)) {
                    TimerUpgradeData.increaseSeedSlots(stack);
                    return true;
                }
                return false;
            }
            case "portal_stability": 
            case "window_stabilizer": {
                if (TimerUpgradeData.canAddPortalStabilityUpgrade(stack)) {
                    TimerUpgradeData.addPortalStabilityUpgrade(stack);
                    return true;
                }
                return false;
            }
            case "dimensional_buffer": {
                if (DimensionManager.canUpgradeTimerTier(stack)) {
                    return DimensionManager.upgradeTimerTier(stack);
                }
                return false;
            }
            case "phase_modulator": {
                CompoundTag tag = stack.m_41784_();
                if (tag.m_128471_("IsOverheated")) {
                    tag.m_128379_("IsOverheated", false);
                    tag.m_128473_("CooldownEndTime");
                    tag.m_128473_("IsCooldownOverheat");
                    return true;
                }
                return false;
            }
            case "crystal_buffer": {
                CompoundTag bufferTag;
                long currentDuration;
                if (GiveUpgradeCommand.isDamagedTimer(stack) && (currentDuration = (bufferTag = stack.m_41784_()).m_128454_("RemainingTime")) > 0L) {
                    double multiplier = 0.5 + Math.random() * 0.25;
                    long newDuration = (long)((double)currentDuration * multiplier);
                    bufferTag.m_128356_("RemainingTime", newDuration);
                    return true;
                }
                return false;
            }
            case "advanced_crystal_buffer": {
                CompoundTag advTag;
                long currentDuration;
                if (GiveUpgradeCommand.isDamagedTimer(stack) && (currentDuration = (advTag = stack.m_41784_()).m_128454_("RemainingTime")) > 0L) {
                    int divisor = 2 + (int)(Math.random() * 4.0);
                    long newDuration = currentDuration / (long)divisor;
                    advTag.m_128356_("RemainingTime", newDuration);
                    return true;
                }
                return false;
            }
            case "ultimate_crystal_buffer": {
                CompoundTag ultTag;
                long currentDuration;
                if (GiveUpgradeCommand.isDamagedTimer(stack) && (currentDuration = (ultTag = stack.m_41784_()).m_128454_("RemainingTime")) > 0L) {
                    int divisor = 4 + (int)(Math.random() * 6.0);
                    long newDuration = currentDuration / (long)divisor;
                    ultTag.m_128356_("RemainingTime", newDuration);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private static boolean isDamagedTimer(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_("RemainingTime") && tag.m_128454_("RemainingTime") > 0L;
    }
}

