/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.events;

import com.michelmuscle.slidersmod.system.PlayerSeedRegistry;
import com.michelmuscle.slidersmod.util.TimerUpgradeData;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="slidersmod")
public final class ListSeedsCommand {
    private ListSeedsCommand() {
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"listseeds").executes(context -> {
            Entity patt1022$temp = ((CommandSourceStack)context.getSource()).m_81373_();
            if (patt1022$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt1022$temp;
                if (!ListSeedsCommand.isHoldingAnchorTimer(player)) {
                    player.m_5661_((Component)Component.m_237115_((String)"command.slidersmod.listseeds.anchor_required").m_130940_(ChatFormatting.RED), false);
                    return 0;
                }
                PlayerSeedRegistry registry = PlayerSeedRegistry.get(player.m_20194_());
                Set<String> playerSeeds = registry.getPlayerSeeds(player.m_20148_());
                if (playerSeeds.isEmpty()) {
                    player.m_5661_((Component)Component.m_237115_((String)"command.slidersmod.listseeds.none").m_130940_(ChatFormatting.GOLD), false);
                    return 0;
                }
                player.m_5661_((Component)Component.m_237110_((String)"command.slidersmod.listseeds.header", (Object[])new Object[]{playerSeeds.size()}).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC}), false);
                TreeSet<String> sortedSeeds = new TreeSet<String>(playerSeeds);
                for (String seed : sortedSeeds) {
                    player.m_5661_((Component)Component.m_237110_((String)"command.slidersmod.listseeds.entry", (Object[])new Object[]{seed}).m_130940_(ChatFormatting.GRAY), false);
                }
                return 1;
            }
            return 0;
        }));
    }

    private static boolean isHoldingAnchorTimer(ServerPlayer player) {
        return ListSeedsCommand.hasAnchor(player.m_21205_()) || ListSeedsCommand.hasAnchor(player.m_21206_());
    }

    private static boolean hasAnchor(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return TimerUpgradeData.getSeedSlots(stack) > 0;
    }
}

