/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.events;

import com.michelmuscle.slidersmod.system.SlidersRaidManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="slidersmod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class SlidersRaidCommand {
    private static final SimpleCommandExceptionType FAILED = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Impossible d'ouvrir un Sliders Raid dans cette dimension."));

    private SlidersRaidCommand() {
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"forceraid").executes(ctx -> SlidersRaidCommand.execute((CommandContext<CommandSourceStack>)ctx, null, null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"theme", (ArgumentType)StringArgumentType.word()).suggests((context, builder1) -> SlidersRaidCommand.suggest(builder1, SlidersRaidManager.RaidTheme.names())).executes(ctx -> SlidersRaidCommand.execute((CommandContext<CommandSourceStack>)ctx, SlidersRaidCommand.parseTheme((CommandContext<CommandSourceStack>)ctx, "theme"), null))).then(Commands.m_82129_((String)"timer", (ArgumentType)StringArgumentType.word()).suggests((context, builder12) -> SlidersRaidCommand.suggest(builder12, SlidersRaidManager.TimerStyle.names())).executes(ctx -> SlidersRaidCommand.execute((CommandContext<CommandSourceStack>)ctx, SlidersRaidCommand.parseTheme((CommandContext<CommandSourceStack>)ctx, "theme"), SlidersRaidCommand.parseStyle((CommandContext<CommandSourceStack>)ctx, "timer")))));
        LiteralCommandNode<CommandSourceStack> root = SlidersRaidCommand.getOrCreateSlidersRoot((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        root.addChild((CommandNode)builder.build());
    }

    private static int execute(CommandContext<CommandSourceStack> ctx, SlidersRaidManager.RaidTheme theme, SlidersRaidManager.TimerStyle style) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.m_81375_();
        boolean success = SlidersRaidManager.forceRaid(player, theme, style);
        if (!success) {
            throw FAILED.create();
        }
        return 1;
    }

    private static SlidersRaidManager.RaidTheme parseTheme(CommandContext<CommandSourceStack> ctx, String name) throws CommandSyntaxException {
        String value = StringArgumentType.getString(ctx, (String)name);
        SlidersRaidManager.RaidTheme theme = SlidersRaidManager.RaidTheme.fromName(value);
        if (theme == null) {
            throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)("Theme inconnu : " + value))).create();
        }
        return theme;
    }

    private static SlidersRaidManager.TimerStyle parseStyle(CommandContext<CommandSourceStack> ctx, String name) throws CommandSyntaxException {
        String value = StringArgumentType.getString(ctx, (String)name);
        SlidersRaidManager.TimerStyle style = SlidersRaidManager.TimerStyle.fromName(value);
        if (style == null) {
            throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)("Timer inconnu : " + value))).create();
        }
        return style;
    }

    private static CompletableFuture<Suggestions> suggest(SuggestionsBuilder builder, String[] options) {
        for (String option : options) {
            builder.suggest(option);
        }
        return builder.buildFuture();
    }

    private static LiteralCommandNode<CommandSourceStack> getOrCreateSlidersRoot(CommandDispatcher<CommandSourceStack> dispatcher) {
        CommandNode existing = dispatcher.getRoot().getChild("sliders");
        if (existing instanceof LiteralCommandNode) {
            LiteralCommandNode literal = (LiteralCommandNode)existing;
            return literal;
        }
        LiteralCommandNode root = ((LiteralArgumentBuilder)Commands.m_82127_((String)"sliders").requires(src -> src.m_6761_(2))).build();
        dispatcher.getRoot().addChild((CommandNode)root);
        return root;
    }
}

