/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class ProgressArrow {
    private final ResourceLocation texture;
    private final int width;
    private final int height;
    private final int textureX;
    private final int textureY;

    public ProgressArrow(ResourceLocation texture, int width, int height, int guiX, int guiY) {
        this.texture = texture;
        this.width = width;
        this.height = height;
        this.textureX = guiX;
        this.textureY = guiY;
    }

    public static ProgressArrow smallRightArrow(int guiX, int guiY) {
        return new ProgressArrow(ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"textures/gui/progress/small_right.png"), 8, 8, guiX, guiY);
    }

    public static ProgressArrow largeRightArrow(int guiX, int guiY) {
        return new ProgressArrow(ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"textures/gui/progress/large_right.png"), 16, 16, guiX, guiY);
    }

    public static ProgressArrow smallLeftArrow(int guiX, int guiY) {
        return new ProgressArrow(ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"textures/gui/progress/small_left.png"), 8, 8, guiX, guiY);
    }

    public static ProgressArrow largeLeftArrow(int guiX, int guiY) {
        return new ProgressArrow(ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"textures/gui/progress/large_left.png"), 16, 16, guiX, guiY);
    }

    public void render(GuiGraphics graphics, int screenX, int screenY, int progress, boolean isActive) {
        progress = Math.max(0, Math.min(100, progress));
        int frameIndex = this.getFrameIndex(progress, isActive);
        int textureYOffset = frameIndex * this.height;
        graphics.m_280163_(this.texture, screenX, screenY, (float)this.textureX, (float)(this.textureY + textureYOffset), this.width, this.height, this.width, this.height * 3);
    }

    public void renderScaled(GuiGraphics graphics, int screenX, int screenY, int scaleWidth, int scaleHeight, int progress, boolean isActive) {
        progress = Math.max(0, Math.min(100, progress));
        int frameIndex = this.getFrameIndex(progress, isActive);
        int textureYOffset = frameIndex * this.height;
        graphics.m_280163_(this.texture, screenX, screenY, (float)this.textureX, (float)(this.textureY + textureYOffset), scaleWidth, scaleHeight, this.width, this.height * 3);
    }

    private int getFrameIndex(int progress, boolean isActive) {
        if (!isActive) {
            return 2;
        }
        if (progress >= 1) {
            return 1;
        }
        return 0;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTextureX() {
        return this.textureX;
    }

    public int getTextureY() {
        return this.textureY;
    }
}

