/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.item;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.entity.VortexEntity;
import com.michelmuscle.slidersmod.init.ModSounds;
import com.michelmuscle.slidersmod.item.TimerItemBase;
import com.michelmuscle.slidersmod.network.ModNetworking;
import com.michelmuscle.slidersmod.network.ShowTimerHudPacket;
import com.michelmuscle.slidersmod.network.VortexBeamPacket;
import com.michelmuscle.slidersmod.portal.VortexImmersivePortalHelper;
import com.michelmuscle.slidersmod.portal.VortexPortalPlacement;
import com.michelmuscle.slidersmod.portal.VortexPortalTargets;
import com.michelmuscle.slidersmod.screen.DamagedTimerScreen;
import com.michelmuscle.slidersmod.util.ClassicTimerHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.Portal;

public class OriginalTimerDamagedItem
extends TimerItemBase {
    private static final String TAG_REMAINING_TIME = "RemainingTime";
    private static final String TAG_ACTIVATION_TIME = "ActivationTime";
    private static final String TAG_VORTEX_WINDOW_ACTIVE = "VortexWindowActive";
    private static final String TAG_VORTEX_OPENED = "VortexOpened";
    private static final Map<UUID, ScheduledVortexSpawn> scheduledSpawns = new ConcurrentHashMap<UUID, ScheduledVortexSpawn>();
    private static final int PORTAL_DELAY_TICKS = 20;
    private static final int PORTAL_GROWTH_TOTAL_TICKS = 10;
    private static final int GROWTH_START_TICKS_BEFORE_SPAWN = 4;
    private static final double MAX_RAY_DISTANCE = 7.0;
    private static final double DEFAULT_VORTEX_DISTANCE = 5.0;
    private static final double AXIS_EPSILON = 1.0E-4;
    private static final Vec3 WORLD_UP = new Vec3(0.0, 1.0, 0.0);
    private static final Vec3 WORLD_FORWARD = new Vec3(0.0, 0.0, 1.0);
    private static final float VERTICAL_ALIGN_PITCH_MIN = -15.0f;
    private static final float VERTICAL_ALIGN_PITCH_MAX = 20.0f;
    private static final double FREE_SHOT_VERTICAL_Y = 2.2;

    public OriginalTimerDamagedItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            Minecraft.m_91087_().m_91152_((Screen)new DamagedTimerScreen(stack));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public static void onSwing(Player player, ItemStack stack, Level level) {
        boolean inVortexWindow;
        if (level.f_46443_) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        long remainingTime = tag.m_128454_(TAG_REMAINING_TIME);
        long activationTime = tag.m_128454_(TAG_ACTIVATION_TIME);
        long currentTime = level.m_46467_();
        long elapsed = currentTime - activationTime;
        long timeLeft = remainingTime - elapsed;
        boolean bl = inVortexWindow = timeLeft <= 60L && timeLeft > 0L;
        if (inVortexWindow && !tag.m_128471_(TAG_VORTEX_OPENED)) {
            OriginalTimerDamagedItem.openDamagedVortex(player, stack, level);
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModNetworking.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ShowTimerHudPacket(timeLeft, false, false));
        }
    }

    private static void openDamagedVortex(Player player, ItemStack stack, Level level) {
        ServerLevel serverLevel;
        SlidersMod.LOGGER.info("Player {} opened damaged vortex in time window!", (Object)player.m_7755_().getString());
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_(TAG_VORTEX_OPENED, true);
        tag.m_128379_("IsDamagedVortex", true);
        tag.m_128379_("IsActive", true);
        VortexPortalPlacement placement = OriginalTimerDamagedItem.computeVortexPlacement(player, level);
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Vec3 startPos = player.m_20299_(1.0f).m_82549_(player.m_20154_().m_82490_(0.5));
                Vec3 endPos = placement.center();
                ModNetworking.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> serverPlayer), (Object)new VortexBeamPacket(startPos, endPos));
                SlidersMod.LOGGER.info("Damaged vortex beam effect triggered from {} to {}", (Object)startPos, (Object)endPos);
            }
        }
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            BlockPos soundPos = BlockPos.m_274446_((Position)placement.center());
            serverLevel.m_5594_(null, soundPos, (SoundEvent)ModSounds.VORTEX_OPEN.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            UUID previewPortalId = VortexImmersivePortalHelper.spawnPreviewPortal(serverLevel, placement, VortexPortalTargets.ORIGINAL).map(Entity::m_20148_).orElse(null);
            long spawnTime = serverLevel.m_46467_() + 20L;
            scheduledSpawns.put(UUID.randomUUID(), new ScheduledVortexSpawn(spawnTime, serverLevel, placement, player, stack, previewPortalId));
            SlidersMod.LOGGER.info("Damaged vortex spawn scheduled for game time {}", (Object)spawnTime);
        }
        player.m_5661_((Component)Component.m_237113_((String)"\u00a7aDamaged vortex opening! Jump in within 30 seconds!"), true);
    }

    public static void tickScheduledSpawns(ServerLevel level) {
        long currentTime = level.m_46467_();
        Iterator<Map.Entry<UUID, ScheduledVortexSpawn>> iterator = scheduledSpawns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, ScheduledVortexSpawn> entry = iterator.next();
            ScheduledVortexSpawn spawn = entry.getValue();
            long ticksLeft = spawn.spawnTime - currentTime;
            if (ticksLeft <= 0L) {
                OriginalTimerDamagedItem.spawnDamagedVortex(spawn.level, spawn);
                iterator.remove();
                SlidersMod.LOGGER.info("Damaged vortex spawned (scheduled)");
                continue;
            }
            if (spawn.previewPortalId == null) continue;
            OriginalTimerDamagedItem.updatePreviewPortal(spawn.level, spawn, ticksLeft);
        }
    }

    private static void updatePreviewPortal(ServerLevel level, ScheduledVortexSpawn spawn, long ticksLeft) {
        Portal portal = VortexImmersivePortalHelper.findPortal(level, spawn.previewPortalId);
        if (portal == null) {
            return;
        }
        long growthTicks = 15L;
        if (ticksLeft > growthTicks) {
            VortexImmersivePortalHelper.updatePortalSize(portal, VortexPortalTargets.ORIGINAL, 0.05);
            VortexImmersivePortalHelper.setPortalVisibility(portal, false);
            return;
        }
        int ticksSinceStart = (int)(4L - ticksLeft);
        double progress = Mth.m_14008_((double)((double)ticksSinceStart / 10.0), (double)0.0, (double)1.0);
        double size = Mth.m_14139_((double)progress, (double)0.05, (double)3.0);
        VortexImmersivePortalHelper.updatePortalSize(portal, VortexPortalTargets.ORIGINAL, size);
        VortexImmersivePortalHelper.setPortalVisibility(portal, true);
    }

    private static VortexPortalPlacement computeVortexPlacement(Player player, Level level) {
        boolean snapToVertical;
        Vec3 lookVec;
        Vec3 endPos;
        Vec3 eyePos = player.m_20299_(1.0f);
        ClipContext context = new ClipContext(eyePos, endPos = eyePos.m_82549_((lookVec = player.m_20154_().m_82541_()).m_82490_(7.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult result = level.m_45547_(context);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos hitPos = result.m_82425_();
            Direction face = result.m_82434_();
            Vec3 normal = Vec3.m_82528_((Vec3i)face.m_122436_()).m_82541_();
            if (normal.m_82526_(lookVec) < 0.0) {
                normal = normal.m_82490_(-1.0);
            }
            Vec3 center = Vec3.m_82512_((Vec3i)hitPos.m_121945_(face));
            Vec3 axisH = OriginalTimerDamagedItem.resolveAxisH(normal, WORLD_UP);
            Vec3 axisW = normal.m_82537_(axisH).m_82541_();
            axisH = axisW.m_82537_(normal).m_82541_();
            return new VortexPortalPlacement(center, axisW, axisH, normal, true);
        }
        Vec3 center = eyePos.m_82549_(lookVec.m_82490_(5.0));
        float pitch = player.m_146909_();
        boolean bl = snapToVertical = pitch >= -15.0f && pitch <= 20.0f;
        if (snapToVertical) {
            Vec3 axisH;
            Vec3 normal;
            Vec3 axisW;
            Vec3 horizontal = new Vec3(lookVec.f_82479_, 0.0, lookVec.f_82481_);
            if (horizontal.m_82556_() < 1.0E-4) {
                double yawRad = Math.toRadians(player.m_146908_());
                horizontal = new Vec3(-Math.sin(yawRad), 0.0, Math.cos(yawRad));
            }
            axisW = (axisW = (normal = horizontal.m_82541_()).m_82537_(axisH = WORLD_UP)).m_82556_() < 1.0E-4 ? WORLD_FORWARD : axisW.m_82541_();
            axisH = axisW.m_82537_(normal).m_82541_();
            Vec3 adjustedCenter = new Vec3(center.f_82479_, player.m_20182_().f_82480_ + 2.2, center.f_82481_);
            return new VortexPortalPlacement(adjustedCenter, axisW, axisH, normal, false);
        }
        Vec3 normal = lookVec.m_82541_();
        Vec3 axisH = OriginalTimerDamagedItem.resolveAxisH(normal, player.m_20289_(1.0f));
        Vec3 axisW = normal.m_82537_(axisH).m_82541_();
        axisH = axisW.m_82537_(normal).m_82541_();
        return new VortexPortalPlacement(center, axisW, axisH, normal, false);
    }

    private static Vec3 resolveAxisH(Vec3 normal, Vec3 preferredUp) {
        Vec3 axisH;
        Vec3 candidate = preferredUp.m_82546_(normal.m_82490_(preferredUp.m_82526_(normal)));
        if (candidate.m_82556_() < 1.0E-4) {
            Vec3 fallback = Math.abs(normal.f_82480_) < 0.9 ? WORLD_UP : WORLD_FORWARD;
            candidate = fallback.m_82546_(normal.m_82490_(fallback.m_82526_(normal)));
        }
        if (candidate.m_82556_() < 1.0E-4) {
            candidate = normal.m_82537_(WORLD_FORWARD);
        }
        if (candidate.m_82556_() < 1.0E-4) {
            candidate = normal.m_82537_(new Vec3(1.0, 0.0, 0.0));
        }
        if ((axisH = candidate.m_82541_()).m_82526_(WORLD_UP) < 0.0 && Math.abs(normal.f_82480_) < 0.999) {
            axisH = axisH.m_82490_(-1.0);
        }
        return axisH;
    }

    private static void spawnDamagedVortex(ServerLevel level, ScheduledVortexSpawn spawn) {
        Vec3 center = spawn.placement.center();
        VortexEntity vortex = new VortexEntity((Level)level, center.f_82479_, center.f_82480_ + 1.0, center.f_82481_, spawn.player.m_20148_(), spawn.stack);
        vortex.setLightAnchor(BlockPos.m_274561_((double)center.f_82479_, (double)Math.floor(center.f_82480_), (double)center.f_82481_));
        level.m_7967_((Entity)vortex);
        VortexImmersivePortalHelper.attachVisuals(level, vortex, spawn.placement, spawn.previewPortalId);
        SlidersMod.LOGGER.info("Damaged vortex spawned at: {}", (Object)center);
    }

    public static void initializeDamagedTimer(ItemStack stack, Level level) {
        long randomDuration = ClassicTimerHelper.generateDamagedTimerDuration();
        CompoundTag tag = stack.m_41784_();
        tag.m_128356_(TAG_REMAINING_TIME, randomDuration);
        tag.m_128356_(TAG_ACTIVATION_TIME, level.m_46467_());
        tag.m_128379_(TAG_VORTEX_WINDOW_ACTIVE, false);
        tag.m_128379_(TAG_VORTEX_OPENED, false);
        SlidersMod.LOGGER.info("Damaged timer initialized with {} ticks ({} seconds)", (Object)randomDuration, (Object)(randomDuration / 20L));
    }

    public static long getRemainingTime(ItemStack stack, Level level) {
        CompoundTag tag = stack.m_41784_();
        long remainingTime = tag.m_128454_(TAG_REMAINING_TIME);
        long activationTime = tag.m_128454_(TAG_ACTIVATION_TIME);
        long currentTime = level.m_46467_();
        long elapsed = currentTime - activationTime;
        return Math.max(0L, remainingTime - elapsed);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        long totalTime = tag.m_128454_(TAG_REMAINING_TIME);
        if (totalTime <= 0L) {
            return 0;
        }
        Level level = this.getClientLevel();
        if (level == null) {
            return 13;
        }
        long timeLeft = OriginalTimerDamagedItem.getRemainingTime(stack, level);
        if (timeLeft <= 0L) {
            return 0;
        }
        float percentage = (float)timeLeft / (float)totalTime;
        return Math.max(0, Math.min(13, Math.round(percentage * 13.0f)));
    }

    public int m_142159_(ItemStack stack) {
        Level level = this.getClientLevel();
        if (level == null) {
            return 0xFF6600;
        }
        CompoundTag tag = stack.m_41784_();
        long totalTime = tag.m_128454_(TAG_REMAINING_TIME);
        long timeLeft = OriginalTimerDamagedItem.getRemainingTime(stack, level);
        if (totalTime <= 0L) {
            return 0xFF0000;
        }
        float percentage = (float)timeLeft / (float)totalTime;
        if (percentage > 0.25f) {
            return 0xFF6600;
        }
        return 0xFF0000;
    }

    @Nullable
    private Level getClientLevel() {
        try {
            return Minecraft.m_91087_().f_91073_;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (level != null) {
            long timeLeft = OriginalTimerDamagedItem.getRemainingTime(stack, level);
            tooltip.add((Component)Component.m_237113_((String)"\u00a7c  Damaged - Random jumps"));
            tooltip.add((Component)Component.m_237113_((String)("\u00a77Remaining: " + this.formatTime(timeLeft / 20L))));
        } else {
            tooltip.add((Component)Component.m_237113_((String)"\u00a7c  Damaged - Random jumps"));
        }
    }

    private String formatTime(long totalSeconds) {
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        if (hours > 0L) {
            return String.format("%02dh %02dm %02ds", hours, minutes, seconds);
        }
        if (minutes > 0L) {
            return String.format("%02dm %02ds", minutes, seconds);
        }
        return String.format("%02ds", seconds);
    }

    private static class ScheduledVortexSpawn {
        final long spawnTime;
        final ServerLevel level;
        final VortexPortalPlacement placement;
        final Player player;
        final ItemStack stack;
        @Nullable
        final UUID previewPortalId;

        ScheduledVortexSpawn(long spawnTime, ServerLevel level, VortexPortalPlacement placement, Player player, ItemStack stack, @Nullable UUID previewPortalId) {
            this.spawnTime = spawnTime;
            this.level = level;
            this.placement = placement;
            this.player = player;
            this.stack = stack.m_41777_();
            this.previewPortalId = previewPortalId;
        }
    }
}

