/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.item;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.dimension.DimensionManager;
import com.michelmuscle.slidersmod.entity.VortexEntity;
import com.michelmuscle.slidersmod.init.ModSounds;
import com.michelmuscle.slidersmod.item.TimerItemBase;
import com.michelmuscle.slidersmod.network.ModNetworking;
import com.michelmuscle.slidersmod.network.VortexBeamPacket;
import com.michelmuscle.slidersmod.portal.VortexImmersivePortalHelper;
import com.michelmuscle.slidersmod.portal.VortexPortalPlacement;
import com.michelmuscle.slidersmod.portal.VortexPortalTargets;
import com.michelmuscle.slidersmod.screen.TimerConfigScreen;
import com.michelmuscle.slidersmod.system.ForceVortexManager;
import com.michelmuscle.slidersmod.system.VortexRegistry;
import com.michelmuscle.slidersmod.util.TimerUpgradeData;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.Portal;

public class OriginalTimerItem
extends TimerItemBase {
    private static final String TAG_CONFIGURED_TIME = "ConfiguredTime";
    private static final String TAG_IS_ACTIVE = "IsActive";
    private static final String TAG_ACTIVATION_TIME = "ActivationTime";
    private static final String TAG_RETURN_DIM = "ReturnDimension";
    private static final String TAG_RETURN_X = "ReturnX";
    private static final String TAG_RETURN_Y = "ReturnY";
    private static final String TAG_RETURN_Z = "ReturnZ";
    private static final String TAG_IS_OVERHEATED = "IsOverheated";
    private static final Map<UUID, ScheduledVortexSpawn> scheduledSpawns = new ConcurrentHashMap<UUID, ScheduledVortexSpawn>();
    private static final int PORTAL_DELAY_TICKS = 20;
    private static final int PORTAL_GROWTH_TOTAL_TICKS = 10;
    private static final int GROWTH_START_TICKS_BEFORE_SPAWN = 4;
    private static final double MAX_RAY_DISTANCE = 7.0;
    private static final double DEFAULT_VORTEX_DISTANCE = 5.0;
    private static final double AXIS_EPSILON = 1.0E-4;
    private static final Vec3 WORLD_UP = new Vec3(0.0, 1.0, 0.0);
    private static final Vec3 WORLD_FORWARD = new Vec3(0.0, 0.0, 1.0);
    @Nullable
    private static final float VERTICAL_ALIGN_PITCH_MIN = -15.0f;
    private static final float VERTICAL_ALIGN_PITCH_MAX = 20.0f;
    private static final double FREE_SHOT_VERTICAL_Y = 2.2;

    public OriginalTimerItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            Minecraft.m_91087_().m_91152_((Screen)new TimerConfigScreen(stack));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level.f_46443_) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_("IsCooldownOverheat") && tag.m_128441_("CooldownEndTime")) {
            long cooldownEndTime = tag.m_128454_("CooldownEndTime");
            long currentTime = level.m_46467_();
            if (currentTime >= cooldownEndTime) {
                OriginalTimerItem.setOverheated(stack, false);
                tag.m_128473_("CooldownEndTime");
                tag.m_128473_("IsCooldownOverheat");
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    serverPlayer.m_5661_((Component)Component.m_237115_((String)"message.slidersmod.timer.cooldown_complete").m_130940_(ChatFormatting.GREEN), true);
                }
                SlidersMod.LOGGER.info("Timer cooldown expired for player {}", (Object)entity.m_7755_().getString());
            }
        }
    }

    public static void onSwing(Player player, ItemStack stack, Level level) {
        if (level.f_46443_) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_(TAG_IS_OVERHEATED)) {
            player.m_5661_((Component)Component.m_237115_((String)"message.slidersmod.timer.overheated").m_130940_(ChatFormatting.RED), true);
            return;
        }
        long configuredTime = tag.m_128454_(TAG_CONFIGURED_TIME);
        if (configuredTime <= 0L) {
            player.m_5661_((Component)Component.m_237115_((String)"message.slidersmod.timer.not_configured").m_130940_(ChatFormatting.RED), true);
            return;
        }
        if (tag.m_128471_(TAG_IS_ACTIVE)) {
            boolean trulyAtOrigin;
            String returnDim = tag.m_128461_(TAG_RETURN_DIM);
            String currentDim = level.m_46472_().m_135782_().toString();
            double returnX = tag.m_128459_(TAG_RETURN_X);
            double returnY = tag.m_128459_(TAG_RETURN_Y);
            double returnZ = tag.m_128459_(TAG_RETURN_Z);
            double currentX = player.m_20185_();
            double currentY = player.m_20186_();
            double currentZ = player.m_20189_();
            double distanceSq = Math.pow(currentX - returnX, 2.0) + Math.pow(currentY - returnY, 2.0) + Math.pow(currentZ - returnZ, 2.0);
            boolean atOriginPosition = distanceSq < 2500.0;
            boolean inOriginDimension = returnDim.equals(currentDim);
            boolean bl = trulyAtOrigin = inOriginDimension && atOriginPosition;
            if (trulyAtOrigin) {
                if (OriginalTimerItem.hasActiveVortexNearby(player)) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.slidersmod.timer.already_active").m_130940_(ChatFormatting.RED), true);
                    return;
                }
                SlidersMod.LOGGER.info("Vortex closed without traversal in origin dimension, resetting timer");
                OriginalTimerItem.resetTimer(stack);
            } else {
                ServerPlayer serverPlayer;
                int slotIndex;
                SlidersMod.LOGGER.info("Player NOT at origin: dim match={}, distance={} blocks", (Object)inOriginDimension, (Object)Math.sqrt(distanceSq));
                if (OriginalTimerItem.hasActiveVortexNearby(player)) {
                    player.m_5661_((Component)Component.m_237113_((String)"\u00a7cWait for the arrival vortex to close before forcing a new one."), true);
                    return;
                }
                if (player instanceof ServerPlayer && (slotIndex = OriginalTimerItem.findTimerSlotIndex((Player)(serverPlayer = (ServerPlayer)player), stack)) >= 0) {
                    ForceVortexManager.handleTimerSwingWhileActive(serverPlayer, stack, slotIndex);
                }
                return;
            }
        }
        OriginalTimerItem.openNormalVortex(player, stack, level);
    }

    private static int findTimerSlotIndex(Player player, ItemStack targetStack) {
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (stack != targetStack) continue;
            return i;
        }
        return -1;
    }

    private static boolean hasActiveVortexNearby(Player player) {
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        AABB searchBounds = new AABB(player.m_20185_() - 20.0, player.m_20186_() - 20.0, player.m_20189_() - 20.0, player.m_20185_() + 20.0, player.m_20186_() + 20.0, player.m_20189_() + 20.0);
        List nearbyVortexes = serverLevel.m_45976_(VortexEntity.class, searchBounds);
        return !nearbyVortexes.isEmpty();
    }

    private static void openNormalVortex(Player player, ItemStack stack, Level level) {
        CompoundTag tag = stack.m_41784_();
        VortexPortalPlacement placement = OriginalTimerItem.computeVortexPlacement(player, level);
        if (placement == null) {
            player.m_5661_((Component)Component.m_237115_((String)"message.slidersmod.timer.cannot_open").m_130940_(ChatFormatting.RED), true);
            return;
        }
        Vec3 spawnPos = placement.center();
        tag.m_128359_(TAG_RETURN_DIM, level.m_46472_().m_135782_().toString());
        tag.m_128347_(TAG_RETURN_X, player.m_20185_());
        tag.m_128347_(TAG_RETURN_Y, player.m_20186_());
        tag.m_128347_(TAG_RETURN_Z, player.m_20189_());
        tag.m_128379_(TAG_IS_ACTIVE, true);
        tag.m_128356_(TAG_ACTIVATION_TIME, level.m_46467_());
        SlidersMod.LOGGER.info("Saved return position: dim={}, pos=({}, {}, {})", new Object[]{level.m_46472_().m_135782_(), player.m_20185_(), player.m_20186_(), player.m_20189_()});
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Vec3 startPos = player.m_20299_(1.0f).m_82549_(player.m_20154_().m_82490_(0.5));
                Vec3 endPos = spawnPos.m_82520_(0.0, 1.0, 0.0);
                ModNetworking.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> serverPlayer), (Object)new VortexBeamPacket(startPos, endPos));
                SlidersMod.LOGGER.info("Vortex beam effect triggered from {} to {}", (Object)startPos, (Object)endPos);
            }
        }
        UUID previewPortalId = null;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos soundPos = BlockPos.m_274446_((Position)spawnPos);
            serverLevel.m_5594_(null, soundPos, (SoundEvent)ModSounds.VORTEX_OPEN.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            SlidersMod.LOGGER.info("VORTEX_OPEN sound played at {}", (Object)soundPos);
            Portal previewPortal = VortexImmersivePortalHelper.spawnPreviewPortal(serverLevel, placement, VortexPortalTargets.ORIGINAL).orElse(null);
            previewPortalId = previewPortal != null ? previewPortal.m_20148_() : null;
            long spawnTime = serverLevel.m_46467_() + 20L;
            scheduledSpawns.put(UUID.randomUUID(), new ScheduledVortexSpawn(spawnTime, level, placement, player, stack, previewPortalId));
            SlidersMod.LOGGER.info("Vortex spawn scheduled for game time {}", (Object)spawnTime);
        }
        player.m_5661_((Component)Component.m_237113_((String)"\u00a7aVortex opening..."), true);
    }

    public static void tickScheduledSpawns(ServerLevel level) {
        long currentTime = level.m_46467_();
        Iterator<Map.Entry<UUID, ScheduledVortexSpawn>> iterator = scheduledSpawns.entrySet().iterator();
        while (iterator.hasNext()) {
            Level level2;
            Map.Entry<UUID, ScheduledVortexSpawn> entry = iterator.next();
            ScheduledVortexSpawn spawn = entry.getValue();
            long ticksLeft = spawn.spawnTime - currentTime;
            if (ticksLeft <= 0L) {
                OriginalTimerItem.spawnVortex(spawn.level, spawn.placement, spawn.player, spawn.stack, spawn.previewPortalId);
                iterator.remove();
                SlidersMod.LOGGER.info("Vortex spawned (scheduled)");
                continue;
            }
            if (spawn.previewPortalId == null || !((level2 = spawn.level) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level2;
            OriginalTimerItem.updatePreviewPortal(serverLevel, spawn, ticksLeft);
        }
    }

    private static VortexPortalPlacement computeVortexPlacement(Player player, Level level) {
        boolean snapToVertical;
        Vec3 lookVec;
        Vec3 endPos;
        Vec3 eyePos = player.m_20299_(1.0f);
        ClipContext context = new ClipContext(eyePos, endPos = eyePos.m_82549_((lookVec = player.m_20154_().m_82541_()).m_82490_(7.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult result = level.m_45547_(context);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos hitPos = result.m_82425_();
            Direction face = result.m_82434_();
            Vec3 normal = Vec3.m_82528_((Vec3i)face.m_122436_()).m_82541_();
            if (normal.m_82526_(lookVec) < 0.0) {
                normal = normal.m_82490_(-1.0);
            }
            Vec3 center = Vec3.m_82512_((Vec3i)hitPos.m_121945_(face));
            Vec3 axisH = OriginalTimerItem.resolveAxisH(normal, WORLD_UP);
            Vec3 axisW = normal.m_82537_(axisH).m_82541_();
            axisH = axisW.m_82537_(normal).m_82541_();
            return new VortexPortalPlacement(center, axisW, axisH, normal, true);
        }
        Vec3 center = eyePos.m_82549_(lookVec.m_82490_(5.0));
        float pitch = player.m_146909_();
        boolean bl = snapToVertical = pitch >= -15.0f && pitch <= 20.0f;
        if (snapToVertical) {
            Vec3 axisH;
            Vec3 normal;
            Vec3 axisW;
            Vec3 horizontal = new Vec3(lookVec.f_82479_, 0.0, lookVec.f_82481_);
            if (horizontal.m_82556_() < 1.0E-4) {
                double yawRad = Math.toRadians(player.m_146908_());
                horizontal = new Vec3(-Math.sin(yawRad), 0.0, Math.cos(yawRad));
            }
            axisW = (axisW = (normal = horizontal.m_82541_()).m_82537_(axisH = WORLD_UP)).m_82556_() < 1.0E-4 ? new Vec3(1.0, 0.0, 0.0) : axisW.m_82541_();
            axisH = axisW.m_82537_(normal).m_82541_();
            Vec3 adjustedCenter = new Vec3(center.f_82479_, player.m_20182_().f_82480_ + 2.2, center.f_82481_);
            return new VortexPortalPlacement(adjustedCenter, axisW, axisH, normal, false);
        }
        Vec3 normal = lookVec.m_82541_();
        Vec3 axisH = OriginalTimerItem.resolveAxisH(normal, player.m_20289_(1.0f));
        Vec3 axisW = normal.m_82537_(axisH).m_82541_();
        axisH = axisW.m_82537_(normal).m_82541_();
        return new VortexPortalPlacement(center, axisW, axisH, normal, false);
    }

    private static Vec3 resolveAxisH(Vec3 normal, Vec3 preferredUp) {
        Vec3 axisH;
        Vec3 candidate = preferredUp.m_82546_(normal.m_82490_(preferredUp.m_82526_(normal)));
        if (candidate.m_82556_() < 1.0E-4) {
            Vec3 fallback = Math.abs(normal.f_82480_) < 0.9 ? WORLD_UP : WORLD_FORWARD;
            candidate = fallback.m_82546_(normal.m_82490_(fallback.m_82526_(normal)));
        }
        if (candidate.m_82556_() < 1.0E-4) {
            candidate = normal.m_82537_(WORLD_FORWARD);
        }
        if (candidate.m_82556_() < 1.0E-4) {
            candidate = normal.m_82537_(new Vec3(1.0, 0.0, 0.0));
        }
        if ((axisH = candidate.m_82541_()).m_82526_(WORLD_UP) < 0.0 && Math.abs(normal.f_82480_) < 0.999) {
            axisH = axisH.m_82490_(-1.0);
        }
        return axisH;
    }

    private static void spawnVortex(Level level, VortexPortalPlacement placement, Player player, ItemStack stack, @Nullable UUID previewPortalId) {
        ServerLevel serverLevel;
        Vec3 center = placement.center();
        VortexEntity vortex = new VortexEntity(level, center.f_82479_, center.f_82480_ + 1.0, center.f_82481_, player.m_20148_(), stack);
        vortex.setLightAnchor(BlockPos.m_274561_((double)center.f_82479_, (double)Math.floor(center.f_82480_), (double)center.f_82481_));
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            VortexImmersivePortalHelper.attachVisuals(serverLevel, vortex, placement, previewPortalId);
        }
        level.m_7967_((Entity)vortex);
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (vortex.getCachedDestination() != null) {
                DimensionManager.RandomDestination destination = vortex.getCachedDestination();
                VortexRegistry.registerVortex(BlockPos.m_274561_((double)center.f_82479_, (double)(center.f_82480_ + 1.0), (double)center.f_82481_), destination.dimension, destination.pos, serverLevel.m_46467_());
                SlidersMod.LOGGER.info("Original Timer vortex registered in VortexRegistry: dest={}, pos={}", (Object)destination.dimension.m_135782_(), (Object)destination.pos);
            }
        }
        SlidersMod.LOGGER.info("Vortex spawned at: {}", (Object)center);
    }

    @Nullable
    private static void updatePreviewPortal(ServerLevel level, ScheduledVortexSpawn spawn, long ticksLeft) {
        Portal portal = VortexImmersivePortalHelper.findPortal(level, spawn.previewPortalId);
        if (portal == null) {
            return;
        }
        long growthTicks = 15L;
        if (ticksLeft > growthTicks) {
            VortexImmersivePortalHelper.updatePortalSize(portal, VortexPortalTargets.ORIGINAL, 0.05);
            VortexImmersivePortalHelper.setPortalVisibility(portal, false);
            return;
        }
        int ticksSinceStart = (int)(4L - ticksLeft);
        double progress = Mth.m_14008_((double)((double)ticksSinceStart / 10.0), (double)0.0, (double)1.0);
        double size = Mth.m_14139_((double)progress, (double)0.05, (double)3.0);
        VortexImmersivePortalHelper.updatePortalSize(portal, VortexPortalTargets.ORIGINAL, size);
        VortexImmersivePortalHelper.setPortalVisibility(portal, true);
    }

    public static long getConfiguredTime(ItemStack stack) {
        return stack.m_41784_().m_128454_(TAG_CONFIGURED_TIME);
    }

    public static long getActivationTime(ItemStack stack) {
        return stack.m_41784_().m_128454_(TAG_ACTIVATION_TIME);
    }

    public static void setConfiguredTime(ItemStack stack, long seconds) {
        long clamped = TimerUpgradeData.clampConfiguredSeconds(stack, seconds);
        stack.m_41784_().m_128356_(TAG_CONFIGURED_TIME, clamped);
    }

    public static boolean isActive(ItemStack stack) {
        return stack.m_41784_().m_128471_(TAG_IS_ACTIVE);
    }

    public static void setOverheated(ItemStack stack, boolean overheated) {
        CompoundTag tag = stack.m_41784_();
        if (overheated) {
            tag.m_128379_(TAG_IS_OVERHEATED, true);
        } else {
            tag.m_128473_(TAG_IS_OVERHEATED);
        }
    }

    public static boolean isOverheated(ItemStack stack) {
        return stack.m_41784_().m_128471_(TAG_IS_OVERHEATED);
    }

    public static void repairOverheat(ItemStack stack) {
        OriginalTimerItem.setOverheated(stack, false);
    }

    public static void resetTimer(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_(TAG_IS_ACTIVE, false);
        tag.m_128473_(TAG_ACTIVATION_TIME);
        tag.m_128473_(TAG_RETURN_DIM);
        tag.m_128473_(TAG_RETURN_X);
        tag.m_128473_(TAG_RETURN_Y);
        tag.m_128473_(TAG_RETURN_Z);
        tag.m_128473_("IsCooldownOverheat");
        tag.m_128473_("CooldownEndTime");
    }

    public boolean m_142522_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128471_(TAG_IS_OVERHEATED) || tag.m_128471_(TAG_IS_ACTIVE);
    }

    public int m_142158_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128471_(TAG_IS_ACTIVE)) {
            return 13;
        }
        long configuredTime = tag.m_128454_(TAG_CONFIGURED_TIME);
        long activationTime = tag.m_128454_(TAG_ACTIVATION_TIME);
        if (configuredTime <= 0L) {
            return 13;
        }
        Level level = this.getClientLevel();
        if (level == null) {
            return 13;
        }
        long currentTime = level.m_46467_();
        long elapsedTicks = currentTime - activationTime;
        long elapsedSeconds = elapsedTicks / 20L;
        long remainingSeconds = configuredTime - elapsedSeconds;
        if (remainingSeconds <= 0L) {
            return 0;
        }
        float percentage = (float)remainingSeconds / (float)configuredTime;
        return Math.max(0, Math.min(13, Math.round(percentage * 13.0f)));
    }

    public int m_142159_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_(TAG_IS_OVERHEATED)) {
            return 0xFF0000;
        }
        if (!tag.m_128471_(TAG_IS_ACTIVE)) {
            return 65280;
        }
        long configuredTime = tag.m_128454_(TAG_CONFIGURED_TIME);
        long activationTime = tag.m_128454_(TAG_ACTIVATION_TIME);
        if (configuredTime <= 0L) {
            return 65280;
        }
        Level level = this.getClientLevel();
        if (level == null) {
            return 65280;
        }
        long currentTime = level.m_46467_();
        long elapsedTicks = currentTime - activationTime;
        long elapsedSeconds = elapsedTicks / 20L;
        long remainingSeconds = configuredTime - elapsedSeconds;
        float percentage = (float)remainingSeconds / (float)configuredTime;
        if (percentage > 0.5f) {
            return 65280;
        }
        if (percentage > 0.25f) {
            return 0xFFFF00;
        }
        return 0xFF0000;
    }

    @Nullable
    private Level getClientLevel() {
        try {
            return Minecraft.m_91087_().f_91073_;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        long configuredTime;
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_(TAG_IS_OVERHEATED)) {
            tooltip.add((Component)Component.m_237113_((String)"\u00a74\u00a7l  OVERHEATED  "));
            tooltip.add((Component)Component.m_237113_((String)"\u00a7cRepair with Phase Modulator"));
            if (tag.m_128471_("IsCooldownOverheat") && tag.m_128441_("CooldownEndTime")) {
                Level clientLevel = this.getClientLevel();
                if (clientLevel != null) {
                    long currentTime;
                    long cooldownEndTime = tag.m_128454_("CooldownEndTime");
                    long remainingTicks = cooldownEndTime - (currentTime = clientLevel.m_46467_());
                    if (remainingTicks > 0L) {
                        long remainingSeconds = (remainingTicks + 19L) / 20L;
                        tooltip.add((Component)Component.m_237113_((String)("\u00a76  Cooldown: " + this.formatTime(remainingSeconds))));
                    } else {
                        tooltip.add((Component)Component.m_237113_((String)"\u00a76  Cooldown expiring soon..."));
                    }
                } else {
                    tooltip.add((Component)Component.m_237113_((String)"\u00a76  Temporary cooldown active"));
                }
            } else {
                tooltip.add((Component)Component.m_237113_((String)"\u00a7c(Permanent - requires Phase Modulator)"));
            }
            tooltip.add((Component)Component.m_237113_((String)""));
        }
        if ((configuredTime = tag.m_128454_(TAG_CONFIGURED_TIME)) > 0L) {
            tooltip.add((Component)Component.m_237113_((String)("\u00a77Duration: " + this.formatTime(configuredTime))));
        } else {
            tooltip.add((Component)Component.m_237113_((String)"\u00a77Not configured"));
        }
        if (tag.m_128471_(TAG_IS_ACTIVE)) {
            tooltip.add((Component)Component.m_237113_((String)"\u00a7c  Active"));
        }
    }

    private String formatTime(long totalSeconds) {
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        if (days > 0L) {
            return String.format("%dd %02dh %02dm %02ds", days, hours, minutes, seconds);
        }
        if (hours > 0L) {
            return String.format("%02dh %02dm %02ds", hours, minutes, seconds);
        }
        if (minutes > 0L) {
            return String.format("%02dm %02ds", minutes, seconds);
        }
        return String.format("%02ds", seconds);
    }

    private static class ScheduledVortexSpawn {
        final long spawnTime;
        final Level level;
        final VortexPortalPlacement placement;
        final Player player;
        final ItemStack stack;
        final UUID previewPortalId;

        ScheduledVortexSpawn(long spawnTime, Level level, VortexPortalPlacement placement, Player player, ItemStack stack, @Nullable UUID previewPortalId) {
            this.spawnTime = spawnTime;
            this.level = level;
            this.placement = placement;
            this.player = player;
            this.stack = stack.m_41777_();
            this.previewPortalId = previewPortalId;
        }
    }
}

