/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.item;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class QuantumRelocatorItem
extends Item {
    private static final String TAG_ENCODED_SEED = "EncodedSeed";

    public QuantumRelocatorItem(Item.Properties properties) {
        super(properties);
    }

    public static boolean hasEncodedSeed(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_(TAG_ENCODED_SEED) && !tag.m_128461_(TAG_ENCODED_SEED).isEmpty();
    }

    public static String getEncodedSeed(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128461_(TAG_ENCODED_SEED);
    }

    public static void encodeSeed(ItemStack stack, String seed) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(TAG_ENCODED_SEED, seed);
    }

    public static void clearSeed(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_(TAG_ENCODED_SEED);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (QuantumRelocatorItem.hasEncodedSeed(stack)) {
            String seed = QuantumRelocatorItem.getEncodedSeed(stack);
            tooltip.add((Component)Component.m_237113_((String)"\u00a76  Active Quantum Relocator"));
            tooltip.add((Component)Component.m_237113_((String)("\u00a77Encoded Seed: \u00a7e" + seed)));
        } else {
            tooltip.add((Component)Component.m_237113_((String)"\u00a77Blank Quantum Relocator"));
            tooltip.add((Component)Component.m_237113_((String)"\u00a77Use in Proto-Synchronizer with"));
            tooltip.add((Component)Component.m_237113_((String)"\u00a77an Exodus Timer to encode a seed"));
        }
        super.m_7373_(stack, level, tooltip, flag);
    }

    public boolean m_5812_(ItemStack stack) {
        return QuantumRelocatorItem.hasEncodedSeed(stack);
    }
}

