/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.menu;

import com.michelmuscle.slidersmod.block.entity.AnalyzerStationBlockEntity;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.init.ModMenuTypes;
import com.michelmuscle.slidersmod.util.TimerUpgradeSlots;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class AnalyzerStationMenu
extends AbstractContainerMenu {
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int INV_SLOT_COUNT = 27;
    private static final int PLAYER_SLOT_COUNT = 36;
    private static final int SLOT_TIMER = 36;
    private static final int SLOT_MODULATOR = 37;
    private static final int SLOT_OUTPUT = 38;
    private final AnalyzerStationBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;

    public AnalyzerStationMenu(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerId, inventory, inventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(3));
    }

    public AnalyzerStationMenu(int containerId, Inventory inventory, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.ANALYZER_STATION_MENU.get(), containerId);
        if (!(entity instanceof AnalyzerStationBlockEntity)) {
            throw new IllegalStateException("AnalyzerStationMenu requires correct block entity");
        }
        AnalyzerStationBlockEntity station = (AnalyzerStationBlockEntity)entity;
        this.blockEntity = station;
        this.level = inventory.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.getItemHandler(), 0, 44, 34){

            public boolean m_5857_(ItemStack stack) {
                return TimerUpgradeSlots.isTimer(stack);
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.getItemHandler(), 1, 80, 34){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_((Item)ModItems.PHASE_MODULATOR.get()) || stack.m_150930_((Item)ModItems.SINGLE_USE_CRYSTAL_BUFFER.get()) || stack.m_150930_((Item)ModItems.SINGLE_USE_ADV_CRYSTAL_BUFFER.get()) || stack.m_150930_((Item)ModItems.SINGLE_USE_ULTIMATE_CRYSTAL_BUFFER.get()) || stack.m_150930_((Item)ModItems.CRYSTAL_BUFFER.get()) || stack.m_150930_((Item)ModItems.ADVANCED_CRYSTAL_BUFFER.get()) || stack.m_150930_((Item)ModItems.ULTIMATE_CRYSTAL_BUFFER.get());
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.getItemHandler(), 2, 134, 34){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        this.m_38884_(data);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int slot = 0; slot < 9; ++slot) {
            this.m_38897_(new Slot((Container)playerInventory, slot, 8 + slot * 18, 142));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index < 36 ? !this.m_38903_(slotStack, 36, 39, false) : !this.m_38903_(slotStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return AnalyzerStationMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)this.blockEntity.m_58900_().m_60734_());
    }

    public int getScaledEnergy() {
        int energy = this.data.m_6413_(1);
        int max = this.blockEntity.getMaxEnergyStored();
        if (max == 0) {
            return 0;
        }
        return energy * 52 / max;
    }

    public boolean isAnalyzing() {
        return this.data.m_6413_(2) != 0;
    }

    public int getProcessTime() {
        return 200;
    }

    public int getProgress() {
        return this.data.m_6413_(0);
    }

    public int getEnergyStored() {
        return this.data.m_6413_(1);
    }

    public int getMaxEnergyStored() {
        return this.blockEntity.getMaxEnergyStored();
    }
}

