/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.menu;

import com.michelmuscle.slidersmod.block.entity.QuantumGatePrototypeBlockEntity;
import com.michelmuscle.slidersmod.init.ModMenuTypes;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class QuantumGatePrototypeMenu
extends AbstractContainerMenu {
    public static final int SLOT_ENDER_PEARL = 0;
    private final QuantumGatePrototypeBlockEntity blockEntity;
    private final Inventory playerInventory;
    private final ContainerLevelAccess access;
    private final ContainerData data;

    public QuantumGatePrototypeMenu(int containerId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(containerId, playerInventory, playerInventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), playerInventory.f_35978_);
    }

    public QuantumGatePrototypeMenu(int containerId, Inventory playerInventory, final BlockEntity blockEntity, Player player) {
        super((MenuType)ModMenuTypes.QUANTUM_GATE_PROTOTYPE_MENU.get(), containerId);
        int col;
        if (!(blockEntity instanceof QuantumGatePrototypeBlockEntity)) {
            throw new IllegalStateException("Wrong block entity");
        }
        final QuantumGatePrototypeBlockEntity qgpBlockEntity = (QuantumGatePrototypeBlockEntity)blockEntity;
        this.blockEntity = qgpBlockEntity;
        this.playerInventory = playerInventory;
        this.access = ContainerLevelAccess.m_39289_((Level)playerInventory.f_35978_.m_9236_(), (BlockPos)qgpBlockEntity.m_58899_());
        boolean isServerSide = !playerInventory.f_35978_.m_9236_().m_5776_();
        this.data = isServerSide ? new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> qgpBlockEntity.getEnergyStored() & 0xFFFF;
                    case 1 -> qgpBlockEntity.getEnergyStored() >> 16 & 0xFFFF;
                    case 2 -> qgpBlockEntity.getMaxEnergyStored() & 0xFFFF;
                    case 3 -> qgpBlockEntity.getMaxEnergyStored() >> 16 & 0xFFFF;
                    case 4 -> qgpBlockEntity.getTriggerCooldownTicks();
                    case 5 -> qgpBlockEntity.getCooldownSecondsRemaining();
                    case 6 -> qgpBlockEntity.getExplorationSecondsRemaining();
                    case 7 -> {
                        if (qgpBlockEntity.isOverheated()) {
                            yield 1;
                        }
                        yield 0;
                    }
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
            }

            public int m_6499_() {
                return 8;
            }
        } : new SimpleContainerData(8);
        this.m_38884_(this.data);
        this.m_38897_(new Slot(new PearlContainer(), 0, 32, 31){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_(Items.f_42584_);
            }

            public int m_6641_() {
                return 64;
            }

            public void m_6654_() {
                super.m_6654_();
                blockEntity.m_6596_();
            }
        });
        int invX = 33;
        int invY = 84;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, invX + col * 18, invY + row * 18));
            }
        }
        int hotbarY = 142;
        for (col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, invX + col * 18, hotbarY));
        }
    }

    public QuantumGatePrototypeBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public int getEnergyStored() {
        int low = this.data.m_6413_(0);
        int high = this.data.m_6413_(1);
        return high << 16 | low;
    }

    public int getMaxEnergyStored() {
        int low = this.data.m_6413_(2);
        int high = this.data.m_6413_(3);
        return high << 16 | low;
    }

    public int getScaledEnergy() {
        int max = this.getMaxEnergyStored();
        if (max == 0) {
            return 0;
        }
        return this.getEnergyStored() * 52 / max;
    }

    public int getTriggerCooldownTicks() {
        return this.data.m_6413_(4);
    }

    public int getCooldownSecondsRemaining() {
        return this.data.m_6413_(5);
    }

    public int getExplorationSecondsRemaining() {
        return this.data.m_6413_(6);
    }

    public boolean isOverheated() {
        return this.data.m_6413_(7) == 1;
    }

    public boolean isCharging() {
        return this.getTriggerCooldownTicks() > 0;
    }

    public String getStateText() {
        return this.blockEntity.getStateText();
    }

    public int getVortexDistance() {
        return this.blockEntity.getVortexDistance();
    }

    public boolean canTrigger() {
        if (this.isOverheated() || this.isCharging()) {
            return false;
        }
        if (this.getEnergyStored() < 15000) {
            return false;
        }
        ItemStack pearlStack = this.getEnderPearlStack();
        return pearlStack.m_41720_() == Items.f_42584_ && pearlStack.m_41613_() >= 3;
    }

    public ItemStack getEnderPearlStack() {
        return this.blockEntity.getEnderPearlStack();
    }

    public void setVortexDistance(int distance) {
        this.blockEntity.setVortexDistance(distance);
    }

    public void setEnderPearlStack(ItemStack stack) {
        this.blockEntity.setEnderPearlStack(stack);
    }

    private static String formatSeconds(int seconds) {
        int value = Math.max(0, seconds);
        int minutes = value / 60;
        int secs = value % 60;
        return String.format(Locale.ROOT, "%02d:%02d", minutes, secs);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            int invEndExclusive;
            int pearlSlotEndExclusive;
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            int invStart = pearlSlotEndExclusive = 1;
            int hotbarStart = invEndExclusive = invStart + 27;
            int hotbarEndExclusive = hotbarStart + 9;
            if (index < pearlSlotEndExclusive) {
                return ItemStack.f_41583_;
            }
            if (stack.m_150930_(Items.f_42584_) ? !this.m_38903_(stack, 0, 1, false) : (index < invEndExclusive ? !this.m_38903_(stack, hotbarStart, hotbarEndExclusive, false) : !this.m_38903_(stack, invStart, invEndExclusive, false))) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return QuantumGatePrototypeMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)this.blockEntity.m_58900_().m_60734_());
    }

    private class PearlContainer
    implements Container {
        private PearlContainer() {
        }

        public int m_6643_() {
            return 1;
        }

        public boolean m_7983_() {
            return QuantumGatePrototypeMenu.this.blockEntity.getEnderPearlStack().m_41619_();
        }

        public ItemStack m_8020_(int index) {
            return QuantumGatePrototypeMenu.this.blockEntity.getEnderPearlStack();
        }

        public ItemStack m_7407_(int index, int amount) {
            ItemStack stack = QuantumGatePrototypeMenu.this.blockEntity.getEnderPearlStack();
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            ItemStack split = stack.m_41777_();
            split.m_41764_(Math.min(amount, stack.m_41613_()));
            stack.m_41774_(split.m_41613_());
            QuantumGatePrototypeMenu.this.blockEntity.setEnderPearlStack(stack);
            this.m_6596_();
            return split;
        }

        public ItemStack m_8016_(int index) {
            ItemStack stack = QuantumGatePrototypeMenu.this.blockEntity.getEnderPearlStack();
            QuantumGatePrototypeMenu.this.blockEntity.setEnderPearlStack(ItemStack.f_41583_);
            return stack;
        }

        public void m_6836_(int index, ItemStack stack) {
            QuantumGatePrototypeMenu.this.blockEntity.setEnderPearlStack(stack);
        }

        public void m_6596_() {
            QuantumGatePrototypeMenu.this.blockEntity.m_6596_();
        }

        public boolean m_6542_(Player player) {
            return true;
        }

        public void m_6211_() {
            QuantumGatePrototypeMenu.this.blockEntity.setEnderPearlStack(ItemStack.f_41583_);
        }
    }
}

