/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.menu;

import com.michelmuscle.slidersmod.block.entity.TimerCustomizerBlockEntity;
import com.michelmuscle.slidersmod.init.ModMenuTypes;
import com.michelmuscle.slidersmod.item.CustomTimerItem;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class TimerCustomizerMenu
extends AbstractContainerMenu {
    private final TimerCustomizerBlockEntity blockEntity;
    private final ContainerData data;
    private final BlockPos blockPos;

    public TimerCustomizerMenu(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerId, inventory, TimerCustomizerMenu.readBlockEntity(inventory, extraData));
    }

    private static TimerCustomizerBlockEntity readBlockEntity(Inventory inventory, FriendlyByteBuf buf) {
        Level level = inventory.f_35978_.m_9236_();
        if (level == null) {
            throw new IllegalStateException("World is null for TimerCustomizerMenu");
        }
        BlockPos pos = buf.m_130135_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof TimerCustomizerBlockEntity)) {
            throw new IllegalStateException("TimerCustomizerMenu requires a TimerCustomizerBlockEntity at " + String.valueOf(pos));
        }
        TimerCustomizerBlockEntity customizer = (TimerCustomizerBlockEntity)blockEntity;
        return customizer;
    }

    public TimerCustomizerMenu(int containerId, Inventory inventory, TimerCustomizerBlockEntity blockEntity) {
        super((MenuType)ModMenuTypes.TIMER_CUSTOMIZER_MENU.get(), containerId);
        this.blockEntity = blockEntity;
        this.data = blockEntity.getDataAccess();
        this.blockPos = blockEntity.m_58899_();
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)blockEntity.getItemHandler(), 0, 34, 34){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof CustomTimerItem;
            }
        });
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        this.m_38884_(this.data);
    }

    private void addPlayerInventory(Inventory inventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)inventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory inventory) {
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)inventory, col, 8 + col * 18, 142));
        }
    }

    public boolean m_6875_(Player player) {
        return this.blockEntity.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (index == 0 ? !this.m_38903_(slotStack, 1, 37, true) : !this.m_38903_(slotStack, 0, 1, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return stack;
    }

    public int getModelIndex() {
        return this.data.m_6413_(0);
    }

    public int getTextureIndex() {
        return this.data.m_6413_(1);
    }

    public int getTintValue() {
        return this.data.m_6413_(2);
    }

    public boolean isTrackingMode() {
        return this.data.m_6413_(3) > 0;
    }

    public boolean isTrackerAvailable() {
        return this.data.m_6413_(4) > 0;
    }

    public TimerCustomizerBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }
}

