/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.network;

import com.michelmuscle.slidersmod.advancements.AchievementManager;
import com.michelmuscle.slidersmod.item.EgyptianTimerItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class EgyptianTimerConfigPacket {
    private final long configuredSeconds;

    public EgyptianTimerConfigPacket(long configuredSeconds) {
        this.configuredSeconds = configuredSeconds;
    }

    public static void encode(EgyptianTimerConfigPacket packet, FriendlyByteBuf buf) {
        buf.writeLong(packet.configuredSeconds);
    }

    public static EgyptianTimerConfigPacket decode(FriendlyByteBuf buf) {
        return new EgyptianTimerConfigPacket(buf.readLong());
    }

    public static void handle(EgyptianTimerConfigPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                ItemStack mainHand = player.m_21205_();
                ItemStack offHand = player.m_21206_();
                ItemStack timerStack = null;
                if (mainHand.m_41720_() instanceof EgyptianTimerItem) {
                    timerStack = mainHand;
                } else if (offHand.m_41720_() instanceof EgyptianTimerItem) {
                    timerStack = offHand;
                }
                if (timerStack != null) {
                    EgyptianTimerItem.setConfiguredTime(timerStack, packet.configuredSeconds);
                    if (packet.configuredSeconds == 69L) {
                        AchievementManager.trigger69SecondTimer(player);
                    }
                    if (packet.configuredSeconds > 3600L) {
                        AchievementManager.triggerGoodLuckWithThat(player);
                    }
                    if (packet.configuredSeconds > 86400L) {
                        AchievementManager.triggerMrPatience(player);
                    }
                    player.m_5661_((Component)Component.m_237113_((String)("\u00a7aEgyptian Timer configured: " + EgyptianTimerConfigPacket.formatTime(packet.configuredSeconds))), true);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static String formatTime(long totalSeconds) {
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        if (hours > 0L) {
            return String.format("%02dh %02dm %02ds", hours, minutes, seconds);
        }
        if (minutes > 0L) {
            return String.format("%02dm %02ds", minutes, seconds);
        }
        return String.format("%02ds", seconds);
    }
}

