/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.network;

import com.michelmuscle.slidersmod.util.TimerUpgradeData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PortalStabilityConfigPacket {
    private final int portalDurationTicks;
    private final int returnDurationTicks;

    public PortalStabilityConfigPacket(int portalDurationTicks, int returnDurationTicks) {
        this.portalDurationTicks = portalDurationTicks;
        this.returnDurationTicks = returnDurationTicks;
    }

    public static void encode(PortalStabilityConfigPacket packet, FriendlyByteBuf buf) {
        buf.m_130130_(packet.portalDurationTicks);
        buf.m_130130_(packet.returnDurationTicks);
    }

    public static PortalStabilityConfigPacket decode(FriendlyByteBuf buf) {
        return new PortalStabilityConfigPacket(buf.m_130242_(), buf.m_130242_());
    }

    public static void handle(PortalStabilityConfigPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ItemStack timerStack = PortalStabilityConfigPacket.findTimerWithUpgrade(player);
            if (timerStack.m_41619_()) {
                return;
            }
            TimerUpgradeData.setPortalDurations(timerStack, packet.portalDurationTicks, packet.returnDurationTicks);
            double portalSeconds = (double)TimerUpgradeData.getPortalDurationTicks(timerStack) / 20.0;
            double returnSeconds = (double)TimerUpgradeData.getReturnPortalDurationTicks(timerStack) / 20.0;
            player.m_5661_((Component)Component.m_237113_((String)String.format("Window stabilized: %.0fs / %.0fs", portalSeconds, returnSeconds)), true);
        });
        ctx.get().setPacketHandled(true);
    }

    private static ItemStack findTimerWithUpgrade(ServerPlayer player) {
        ItemStack main = player.m_21205_();
        if (TimerUpgradeData.hasPortalStabilityUpgrade(main)) {
            return main;
        }
        ItemStack offhand = player.m_21206_();
        if (TimerUpgradeData.hasPortalStabilityUpgrade(offhand)) {
            return offhand;
        }
        return ItemStack.f_41583_;
    }
}

