/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.network;

import com.michelmuscle.slidersmod.block.entity.QuantumGatePrototypeBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class QuantumGateSetDistancePacket {
    private final BlockPos blockPos;
    private final int distance;

    public QuantumGateSetDistancePacket(BlockPos blockPos, int distance) {
        this.blockPos = blockPos;
        this.distance = distance;
    }

    public static void encode(QuantumGateSetDistancePacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.blockPos);
        buf.m_130130_(packet.distance);
    }

    public static QuantumGateSetDistancePacket decode(FriendlyByteBuf buf) {
        return new QuantumGateSetDistancePacket(buf.m_130135_(), buf.m_130242_());
    }

    public static void handle(QuantumGateSetDistancePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            BlockEntity blockEntity = player.m_9236_().m_7702_(packet.blockPos);
            if (blockEntity instanceof QuantumGatePrototypeBlockEntity) {
                QuantumGatePrototypeBlockEntity gate = (QuantumGatePrototypeBlockEntity)blockEntity;
                gate.handleDistanceUpdate(packet.distance);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

