/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.network;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.block.entity.QuantumGatePrototypeBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class QuantumGateTriggerPacket {
    private final BlockPos blockPos;

    public QuantumGateTriggerPacket(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    public static void encode(QuantumGateTriggerPacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.blockPos);
    }

    public static QuantumGateTriggerPacket decode(FriendlyByteBuf buf) {
        return new QuantumGateTriggerPacket(buf.m_130135_());
    }

    public static void handle(QuantumGateTriggerPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            BlockEntity blockEntity = player.m_9236_().m_7702_(packet.blockPos);
            if (!(blockEntity instanceof QuantumGatePrototypeBlockEntity)) {
                SlidersMod.LOGGER.warn("Player {} tried to trigger vortex on invalid block at {}", (Object)player.m_7755_().getString(), (Object)packet.blockPos);
                return;
            }
            QuantumGatePrototypeBlockEntity qgp = (QuantumGatePrototypeBlockEntity)blockEntity;
            qgp.triggerVortex(player);
            SlidersMod.LOGGER.info("Player {} triggered vortex on Quantum Gate Prototype at {}", (Object)player.m_7755_().getString(), (Object)packet.blockPos);
        });
        ctx.get().setPacketHandled(true);
    }
}

