/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.network;

import com.michelmuscle.slidersmod.block.entity.TimerCustomizerBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class TimerCustomizerUpdatePacket {
    private final BlockPos pos;
    private final int modelIndex;
    private final int textureIndex;
    private final int tint;
    private final boolean trackingMode;

    public TimerCustomizerUpdatePacket(BlockPos pos, int modelIndex, int textureIndex, int tint, boolean trackingMode) {
        this.pos = pos;
        this.modelIndex = modelIndex;
        this.textureIndex = textureIndex;
        this.tint = tint;
        this.trackingMode = trackingMode;
    }

    public static void encode(TimerCustomizerUpdatePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.writeInt(packet.modelIndex);
        buffer.writeInt(packet.textureIndex);
        buffer.writeInt(packet.tint);
        buffer.writeBoolean(packet.trackingMode);
    }

    public static TimerCustomizerUpdatePacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        int model = buffer.readInt();
        int texture = buffer.readInt();
        int tint = buffer.readInt();
        boolean tracking = buffer.readBoolean();
        return new TimerCustomizerUpdatePacket(pos, model, texture, tint, tracking);
    }

    public static void handle(TimerCustomizerUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            BlockEntity patt1883$temp = player.m_9236_().m_7702_(packet.pos);
            if (!(patt1883$temp instanceof TimerCustomizerBlockEntity)) {
                return;
            }
            TimerCustomizerBlockEntity customizer = (TimerCustomizerBlockEntity)patt1883$temp;
            customizer.applySettings(packet.modelIndex, packet.textureIndex, packet.tint, packet.trackingMode);
        });
        ctx.get().setPacketHandled(true);
    }
}

