/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.network;

import com.michelmuscle.slidersmod.advancements.AchievementManager;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1Item;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2Item;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3Item;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class UpgradedLoganTimerConfigPacket {
    private final int configuredX;
    private final int configuredZ;
    private final long configuredTime;

    public UpgradedLoganTimerConfigPacket(int configuredX, int configuredZ, long configuredTime) {
        this.configuredX = configuredX;
        this.configuredZ = configuredZ;
        this.configuredTime = configuredTime;
    }

    public static void encode(UpgradedLoganTimerConfigPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.configuredX);
        buf.writeInt(packet.configuredZ);
        buf.writeLong(packet.configuredTime);
    }

    public static UpgradedLoganTimerConfigPacket decode(FriendlyByteBuf buf) {
        return new UpgradedLoganTimerConfigPacket(buf.readInt(), buf.readInt(), buf.readLong());
    }

    public static void handle(UpgradedLoganTimerConfigPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                ItemStack mainHand = player.m_21205_();
                ItemStack offHand = player.m_21206_();
                ItemStack timerStack = null;
                if (mainHand.m_41720_() instanceof UpgradedLoganTimerTier1Item) {
                    timerStack = mainHand;
                    UpgradedLoganTimerTier1Item.setConfiguredX(timerStack, packet.configuredX);
                    UpgradedLoganTimerTier1Item.setConfiguredZ(timerStack, packet.configuredZ);
                    UpgradedLoganTimerTier1Item.setConfiguredTime(timerStack, packet.configuredTime);
                } else if (mainHand.m_41720_() instanceof UpgradedLoganTimerTier2Item) {
                    timerStack = mainHand;
                    UpgradedLoganTimerTier2Item.setConfiguredX(timerStack, packet.configuredX);
                    UpgradedLoganTimerTier2Item.setConfiguredZ(timerStack, packet.configuredZ);
                    UpgradedLoganTimerTier2Item.setConfiguredTime(timerStack, packet.configuredTime);
                } else if (mainHand.m_41720_() instanceof UpgradedLoganTimerTier3Item) {
                    timerStack = mainHand;
                    UpgradedLoganTimerTier3Item.setConfiguredX(timerStack, packet.configuredX);
                    UpgradedLoganTimerTier3Item.setConfiguredZ(timerStack, packet.configuredZ);
                    UpgradedLoganTimerTier3Item.setConfiguredTime(timerStack, packet.configuredTime);
                } else if (offHand.m_41720_() instanceof UpgradedLoganTimerTier1Item) {
                    timerStack = offHand;
                    UpgradedLoganTimerTier1Item.setConfiguredX(timerStack, packet.configuredX);
                    UpgradedLoganTimerTier1Item.setConfiguredZ(timerStack, packet.configuredZ);
                    UpgradedLoganTimerTier1Item.setConfiguredTime(timerStack, packet.configuredTime);
                } else if (offHand.m_41720_() instanceof UpgradedLoganTimerTier2Item) {
                    timerStack = offHand;
                    UpgradedLoganTimerTier2Item.setConfiguredX(timerStack, packet.configuredX);
                    UpgradedLoganTimerTier2Item.setConfiguredZ(timerStack, packet.configuredZ);
                    UpgradedLoganTimerTier2Item.setConfiguredTime(timerStack, packet.configuredTime);
                } else if (offHand.m_41720_() instanceof UpgradedLoganTimerTier3Item) {
                    timerStack = offHand;
                    UpgradedLoganTimerTier3Item.setConfiguredX(timerStack, packet.configuredX);
                    UpgradedLoganTimerTier3Item.setConfiguredZ(timerStack, packet.configuredZ);
                    UpgradedLoganTimerTier3Item.setConfiguredTime(timerStack, packet.configuredTime);
                }
                if (timerStack != null) {
                    if (packet.configuredTime == 69L) {
                        AchievementManager.trigger69SecondTimer(player);
                    }
                    if (packet.configuredTime > 3600L) {
                        AchievementManager.triggerGoodLuckWithThat(player);
                    }
                    if (packet.configuredTime > 86400L) {
                        AchievementManager.triggerMrPatience(player);
                    }
                    String timeStr = UpgradedLoganTimerConfigPacket.formatTime(packet.configuredTime);
                    player.m_5661_((Component)Component.m_237113_((String)("\u00a7aTimer configured: X=" + packet.configuredX + ", Z=" + packet.configuredZ + ", Duration: " + timeStr)), true);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static String formatTime(long totalSeconds) {
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        if (hours > 0L) {
            return String.format("%02dh %02dm %02ds", hours, minutes, seconds);
        }
        if (minutes > 0L) {
            return String.format("%02dm %02ds", minutes, seconds);
        }
        return String.format("%02ds", seconds);
    }
}

