/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.recipe;

import com.google.gson.JsonObject;
import com.michelmuscle.slidersmod.init.ModRecipeSerializers;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class PreserveNbtShapedRecipe
implements CraftingRecipe {
    private final ShapedRecipe delegate;
    private final int copyIndex;
    private final ResourceLocation id;

    public PreserveNbtShapedRecipe(ShapedRecipe delegate, int copyIndex) {
        this.delegate = delegate;
        this.copyIndex = Math.max(0, Math.min(8, copyIndex));
        this.id = delegate.m_6423_();
    }

    public boolean matches(CraftingContainer container, Level level) {
        return this.delegate.m_5818_(container, level);
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack source;
        ItemStack result = this.delegate.m_5874_(container, registryAccess);
        if (!result.m_41619_() && !(source = container.m_8020_(this.copyIndex)).m_41619_() && source.m_41782_()) {
            result.m_41751_(source.m_41783_().m_6426_());
        }
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return this.delegate.m_8004_(width, height);
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.delegate.m_8043_(registryAccess);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.PRESERVE_NBT_SHAPED.get();
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        return this.delegate.m_7457_((Container)container);
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.delegate.m_7527_();
    }

    public String m_6076_() {
        return this.delegate.m_6076_();
    }

    public CraftingBookCategory m_245232_() {
        return this.delegate.m_245232_();
    }

    @Nullable
    public ItemStack m_8042_() {
        return this.delegate.m_8042_();
    }

    public static class Serializer
    implements RecipeSerializer<PreserveNbtShapedRecipe> {
        private final ShapedRecipe.Serializer shapedSerializer = new ShapedRecipe.Serializer();

        public PreserveNbtShapedRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe base = this.shapedSerializer.m_6729_(recipeId, json);
            int copyIndex = 4;
            if (json.has("copy_nbt_index")) {
                copyIndex = json.get("copy_nbt_index").getAsInt();
            }
            return new PreserveNbtShapedRecipe(base, copyIndex);
        }

        @Nullable
        public PreserveNbtShapedRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapedRecipe base = this.shapedSerializer.m_8005_(recipeId, buffer);
            int copyIndex = buffer.m_130242_();
            return new PreserveNbtShapedRecipe(base, copyIndex);
        }

        public void toNetwork(FriendlyByteBuf buffer, PreserveNbtShapedRecipe recipe) {
            this.shapedSerializer.m_6178_(buffer, recipe.delegate);
            buffer.m_130130_(recipe.copyIndex);
        }
    }
}

