/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.screen;

import com.michelmuscle.slidersmod.gui.EnergyBarRenderer;
import com.michelmuscle.slidersmod.gui.ProgressArrowRenderer;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.menu.AnalyzerStationMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AnalyzerStationScreen
extends AbstractContainerScreen<AnalyzerStationMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("slidersmod", "textures/gui/analyzer_station.png");

    public AnalyzerStationScreen(AnalyzerStationMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        this.f_97730_ = 8;
        this.f_97731_ = this.f_97727_ - 92;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = 8;
        this.f_97729_ = 6;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280163_(TEXTURE, x, y, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
        this.renderEnergyBar(guiGraphics, x, y);
        this.renderProgress(guiGraphics, x, y);
        this.renderInputOverlay(guiGraphics, x, y);
    }

    private void renderEnergyBar(GuiGraphics guiGraphics, int x, int y) {
        int barX = x + 12;
        int barY = y + 18;
        int energyMax = ((AnalyzerStationMenu)this.f_97732_).getMaxEnergyStored();
        int energyPercent = energyMax > 0 ? ((AnalyzerStationMenu)this.f_97732_).getEnergyStored() * 100 / energyMax : 0;
        EnergyBarRenderer.renderEnergyBar(guiGraphics, barX, barY, energyPercent);
    }

    private void renderProgress(GuiGraphics guiGraphics, int x, int y) {
        int arrowX = x + 101;
        int arrowY = y + 38;
        int progress = (int)((float)((AnalyzerStationMenu)this.f_97732_).getProgress() * 100.0f / (float)Math.max(((AnalyzerStationMenu)this.f_97732_).getProcessTime(), 1));
        if (((AnalyzerStationMenu)this.f_97732_).isAnalyzing()) {
            ProgressArrowRenderer.renderProgressArrow(guiGraphics, arrowX, arrowY, progress);
        } else {
            ProgressArrowRenderer.renderProgressArrow(guiGraphics, arrowX, arrowY, 0);
        }
    }

    private void renderInputOverlay(GuiGraphics g, int x, int y) {
        boolean showMod = System.currentTimeMillis() / 1000L % 2L == 0L;
        ItemStack timer = new ItemStack((ItemLike)ModItems.ORIGINAL_TIMER.get());
        ItemStack item = showMod ? new ItemStack((ItemLike)ModItems.PHASE_MODULATOR.get()) : new ItemStack((ItemLike)ModItems.SINGLE_USE_CRYSTAL_BUFFER.get());
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.35f);
        g.m_280203_(timer, x + 44, y + 34);
        g.m_280203_(item, x + 80, y + 34);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }
}

