/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.screen;

import com.michelmuscle.slidersmod.item.EgyptianTimerItem;
import com.michelmuscle.slidersmod.network.EgyptianTimerConfigPacket;
import com.michelmuscle.slidersmod.network.ModNetworking;
import com.michelmuscle.slidersmod.network.TrackVortexPacket;
import com.michelmuscle.slidersmod.screen.component.PortalStabilityUi;
import com.michelmuscle.slidersmod.util.GuiTextureHelper;
import com.michelmuscle.slidersmod.util.TimerUpgradeData;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class EgyptianTimerConfigScreen
extends Screen {
    private static final int GUI_WIDTH = GuiTextureHelper.DISPLAY_SIZE;
    private static final int GUI_HEIGHT = GuiTextureHelper.DISPLAY_SIZE;
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/gui/egyptian.png");
    private static final ResourceLocation EGYPTIANLED_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/gui/egyptianled.png");
    private static final ResourceLocation EGYPTIANBIGLED_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/gui/egyptianbigled.png");
    private static final int EGYPTIANLED_X = 114;
    private static final int EGYPTIANLED_Y = 35;
    private static final int EGYPTIANLED_WIDTH = 105;
    private static final int EGYPTIANLED_HEIGHT = 78;
    private static final int EGYPTIANLED_FRAMES = 10;
    private static final int EGYPTIANLED_TICKS_PER_FRAME = 20;
    private static final int EGYPTIANBIGLED_X = 148;
    private static final int EGYPTIANBIGLED_Y = 422;
    private static final int EGYPTIANBIGLED_WIDTH = 36;
    private static final int EGYPTIANBIGLED_HEIGHT = 34;
    private static final GuiTextureHelper.TextureRect HOURS_FIELD = new GuiTextureHelper.TextureRect(96, 132, 139, 167);
    private static final GuiTextureHelper.TextureRect MINUTES_FIELD = new GuiTextureHelper.TextureRect(144, 132, 187, 167);
    private static final GuiTextureHelper.TextureRect SECONDS_FIELD = new GuiTextureHelper.TextureRect(193, 132, 236, 167);
    private static final GuiTextureHelper.TextureRect INFO_PANEL_AREA = new GuiTextureHelper.TextureRect(278, 29, 478, 285);
    private static final GuiTextureHelper.TextureRect RANDOM_SLIDE_BUTTON_AREA = new GuiTextureHelper.TextureRect(278, 308, 478, 353);
    private static final GuiTextureHelper.TextureRect TRACK_BUTTON_AREA = new GuiTextureHelper.TextureRect(278, 372, 478, 417);
    private static final GuiTextureHelper.TextureRect CANCEL_BUTTON_AREA = new GuiTextureHelper.TextureRect(278, 436, 478, 481);
    private static final boolean SHOW_DEBUG_OVERLAY = false;
    private static final int LED_INSET = Math.max(2, GuiTextureHelper.toLogicalWidth(4));
    private final ItemStack timerStack;
    private final boolean isTimerActive;
    private long maxConfigSeconds;
    private EditBox hoursInput;
    private EditBox minutesInput;
    private EditBox secondsInput;
    private Button randomSlideButton;
    private Button trackButton;
    private Button cancelButton;
    private int guiLeft;
    private int guiTop;
    private long remainingTime = 0L;
    private int tickCounter = 0;

    public EgyptianTimerConfigScreen(ItemStack stack) {
        super((Component)Component.m_237113_((String)"Egyptian Timer Configuration"));
        this.timerStack = stack;
        this.isTimerActive = EgyptianTimerItem.isActive(stack);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - GUI_WIDTH) / 2;
        this.guiTop = (this.f_96544_ - GUI_HEIGHT) / 2;
        this.maxConfigSeconds = TimerUpgradeData.getMaxConfiguredSeconds(this.timerStack);
        long currentSeconds = EgyptianTimerItem.getConfiguredTime(this.timerStack);
        int hours = (int)(currentSeconds % 86400L / 3600L);
        int minutes = (int)(currentSeconds % 3600L / 60L);
        int seconds = (int)(currentSeconds % 60L);
        if (this.isTimerActive) {
            this.updateRemainingTime();
            long remainingSeconds = this.remainingTime / 20L;
            hours = (int)(remainingSeconds % 86400L / 3600L);
            minutes = (int)(remainingSeconds % 3600L / 60L);
            seconds = (int)(remainingSeconds % 60L);
        }
        this.hoursInput = this.createLedInputField(HOURS_FIELD, (Component)Component.m_237113_((String)"Hours"));
        this.hoursInput.m_94144_(String.format("%02d", hours));
        this.hoursInput.m_94186_(!this.isTimerActive);
        this.m_142416_((GuiEventListener)this.hoursInput);
        this.minutesInput = this.createLedInputField(MINUTES_FIELD, (Component)Component.m_237113_((String)"Minutes"));
        this.minutesInput.m_94144_(String.format("%02d", minutes));
        this.minutesInput.m_94186_(!this.isTimerActive);
        this.m_142416_((GuiEventListener)this.minutesInput);
        this.secondsInput = this.createLedInputField(SECONDS_FIELD, (Component)Component.m_237113_((String)"Seconds"));
        this.secondsInput.m_94144_(String.format("%02d", seconds));
        this.secondsInput.m_94186_(!this.isTimerActive);
        this.m_142416_((GuiEventListener)this.secondsInput);
        if (!this.isTimerActive) {
            this.randomSlideButton = this.buildButton(RANDOM_SLIDE_BUTTON_AREA, (Component)Component.m_237113_((String)"Random Slide").m_130940_(ChatFormatting.WHITE), this::onConfirm);
            this.m_142416_((GuiEventListener)this.randomSlideButton);
            this.trackButton = this.buildButton(TRACK_BUTTON_AREA, (Component)Component.m_237113_((String)"Track Vortex").m_130940_(ChatFormatting.WHITE), this::onTrackVortex);
            this.trackButton.f_93623_ = TimerUpgradeData.hasTrackerUpgrade(this.timerStack);
            this.m_142416_((GuiEventListener)this.trackButton);
        }
        this.cancelButton = this.buildButton(CANCEL_BUTTON_AREA, (Component)Component.m_237113_((String)"Cancel").m_130940_(ChatFormatting.WHITE), this::onCancel);
        this.m_142416_((GuiEventListener)this.cancelButton);
        this.addPortalStabilityControls();
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.isTimerActive) {
            ++this.tickCounter;
            if (this.tickCounter >= 20) {
                this.tickCounter = 0;
                this.updateRemainingTime();
                this.updateDisplayedTime();
            }
        }
    }

    private void updateRemainingTime() {
        if (this.isTimerActive && this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            long activationTime = EgyptianTimerItem.getActivationTime(this.timerStack);
            long configuredTime = EgyptianTimerItem.getConfiguredTime(this.timerStack);
            long currentGameTime = this.f_96541_.f_91073_.m_46467_();
            long elapsed = currentGameTime - activationTime;
            this.remainingTime = Math.max(0L, configuredTime * 20L - elapsed);
        }
    }

    private void updateDisplayedTime() {
        long remainingSeconds = this.remainingTime / 20L;
        int hours = (int)(remainingSeconds % 86400L / 3600L);
        int minutes = (int)(remainingSeconds % 3600L / 60L);
        int seconds = (int)(remainingSeconds % 60L);
        this.hoursInput.m_94144_(String.format("%02d", hours));
        this.minutesInput.m_94144_(String.format("%02d", minutes));
        this.secondsInput.m_94144_(String.format("%02d", seconds));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        this.renderTimerTexture(graphics);
        this.drawInputBackgrounds(graphics);
        this.drawInfoPanel(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void addPortalStabilityControls() {
        if (!PortalStabilityUi.shouldShow(this.timerStack)) {
            return;
        }
        int width = Math.max(80, INFO_PANEL_AREA.getLogicalWidth() - 20);
        int x = this.guiLeft + INFO_PANEL_AREA.getLogicalX() + 10;
        int baseY = this.guiTop + INFO_PANEL_AREA.getLogicalY() + INFO_PANEL_AREA.getLogicalHeight() - 52;
        this.m_142416_((GuiEventListener)PortalStabilityUi.createPortalButton(this.timerStack, x, baseY, width));
        this.m_142416_((GuiEventListener)PortalStabilityUi.createReturnButton(this.timerStack, x, baseY + 24, width));
    }

    private void drawInputBackgrounds(GuiGraphics graphics) {
        this.fillRect(graphics, HOURS_FIELD, -268435456);
        this.fillRect(graphics, MINUTES_FIELD, -268435456);
        this.fillRect(graphics, SECONDS_FIELD, -268435456);
    }

    private void drawInfoPanel(GuiGraphics graphics) {
        int x = this.guiLeft + INFO_PANEL_AREA.getLogicalX();
        int y = this.guiTop + INFO_PANEL_AREA.getLogicalY();
        int w = INFO_PANEL_AREA.getLogicalWidth();
        int h = INFO_PANEL_AREA.getLogicalHeight();
        graphics.m_280509_(x, y, x + w, y + h, -822083584);
        graphics.m_280509_(x, y, x + w, y + 1, 0x40FFFFFF);
        graphics.m_280509_(x, y + h - 1, x + w, y + h, 0x40666666);
        graphics.m_280509_(x, y, x + 1, y + h, 0x40666666);
        graphics.m_280509_(x + w - 1, y, x + w, y + h, 0x40FFFFFF);
        int padding = GuiTextureHelper.toLogicalX(8);
        int cursorY = y + padding;
        int textX = x + padding;
        long configuredSeconds = EgyptianTimerItem.getConfiguredTime(this.timerStack);
        graphics.m_280488_(this.f_96547_, "Time set:", textX, cursorY, -1);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280488_(this.f_96547_, this.formatTimeSet(configuredSeconds), textX, cursorY += 9, -1);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280488_(this.f_96547_, "Range:", textX, cursorY += 9 + 4, -1);
        Objects.requireNonNull(this.f_96547_);
        String rangeValue = "30s to " + TimerUpgradeData.formatDurationSeconds(this.maxConfigSeconds);
        graphics.m_280488_(this.f_96547_, rangeValue, textX, cursorY += 9, -1);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280488_(this.f_96547_, "Tracker:", textX, cursorY += 9 + 6, -1);
        Objects.requireNonNull(this.f_96547_);
        String trackerStatus = TimerUpgradeData.hasTrackerUpgrade(this.timerStack) ? "Installed" : "Upgrade required";
        graphics.m_280488_(this.f_96547_, trackerStatus, textX, cursorY += 9, -1);
    }

    private void renderTimerTexture(GuiGraphics graphics) {
        graphics.m_280411_(GUI_TEXTURE, this.guiLeft, this.guiTop, GUI_WIDTH, GUI_HEIGHT, 0.0f, 0.0f, 500, 500, 500, 500);
        if (this.isTimerActive) {
            this.renderEgyptianLed(graphics);
            this.renderEgyptianBigLed(graphics);
        }
    }

    private void renderEgyptianLed(GuiGraphics graphics) {
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            return;
        }
        long gameTime = this.f_96541_.f_91073_.m_46467_();
        int frame = (int)(gameTime / 20L % 10L);
        int screenX = this.guiLeft + GuiTextureHelper.toLogicalWidth(114);
        int screenY = this.guiTop + GuiTextureHelper.toLogicalHeight(35);
        int screenWidth = GuiTextureHelper.toLogicalWidth(105);
        int screenHeight = GuiTextureHelper.toLogicalHeight(78);
        int textureY = frame * 78;
        int textureWidth = 105;
        int textureSheetHeight = 780;
        graphics.m_280411_(EGYPTIANLED_TEXTURE, screenX, screenY, screenWidth, screenHeight, 0.0f, (float)textureY, textureWidth, 78, textureWidth, textureSheetHeight);
    }

    private void renderEgyptianBigLed(GuiGraphics graphics) {
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            return;
        }
        long gameTime = this.f_96541_.f_91073_.m_46467_();
        if (gameTime / 20L % 2L == 0L) {
            int screenX = this.guiLeft + GuiTextureHelper.toLogicalWidth(148);
            int screenY = this.guiTop + GuiTextureHelper.toLogicalHeight(422);
            int screenWidth = GuiTextureHelper.toLogicalWidth(36);
            int screenHeight = GuiTextureHelper.toLogicalHeight(34);
            graphics.m_280411_(EGYPTIANBIGLED_TEXTURE, screenX, screenY, screenWidth, screenHeight, 0.0f, 0.0f, 36, 34, 36, 34);
        }
    }

    private void drawDebugOverlay(GuiGraphics graphics) {
        graphics.m_280509_(this.guiLeft, this.guiTop, this.guiLeft + GUI_WIDTH, this.guiTop + GUI_HEIGHT, 0x2000FFFF);
        for (int i = 0; i <= GUI_WIDTH; i += 10) {
            graphics.m_280509_(this.guiLeft + i, this.guiTop, this.guiLeft + i + 1, this.guiTop + GUI_HEIGHT, 0x20000000);
            graphics.m_280509_(this.guiLeft, this.guiTop + i, this.guiLeft + GUI_WIDTH, this.guiTop + i + 1, 0x20000000);
        }
    }

    private EditBox createLedInputField(GuiTextureHelper.TextureRect rect, Component label) {
        int rectWidth = rect.getLogicalWidth();
        int rectHeight = rect.getLogicalHeight();
        int fieldWidth = Math.max(14, rectWidth - LED_INSET * 2);
        int fieldHeight = Math.max(14, rectHeight - LED_INSET * 2);
        int x = this.guiLeft + rect.getLogicalX() + Math.max(0, (rectWidth - fieldWidth) / 2);
        int y = this.guiTop + rect.getLogicalY() + Math.max(0, (rectHeight - fieldHeight) / 2);
        EditBox field = new EditBox(this.f_96547_, x, y, fieldWidth, fieldHeight, label);
        field.m_94182_(false);
        field.m_94202_(-50130);
        field.m_94205_(-10867925);
        field.m_94199_(2);
        return field;
    }

    private Button buildButton(GuiTextureHelper.TextureRect rect, Component label, Button.OnPress onPress) {
        return Button.m_253074_((Component)label, (Button.OnPress)onPress).m_252987_(this.guiLeft + rect.getLogicalX(), this.guiTop + rect.getLogicalY(), rect.getLogicalWidth(), rect.getLogicalHeight()).m_253136_();
    }

    private void fillRect(GuiGraphics graphics, GuiTextureHelper.TextureRect rect, int color) {
        int x1 = this.guiLeft + rect.getLogicalX();
        int y1 = this.guiTop + rect.getLogicalY();
        int x2 = x1 + rect.getLogicalWidth();
        int y2 = y1 + rect.getLogicalHeight();
        graphics.m_280509_(x1, y1, x2, y2, color);
    }

    private String formatTimeSet(long totalSeconds) {
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    private void onConfirm(Button button) {
        int hours = this.parseInput(this.hoursInput.m_94155_(), 0, 23);
        int minutes = this.parseInput(this.minutesInput.m_94155_(), 0, 59);
        int seconds = this.parseInput(this.secondsInput.m_94155_(), 0, 59);
        if (hours == 0 && minutes == 0 && seconds == 0) {
            this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)"Please set a duration!").m_130940_(ChatFormatting.RED), true);
            return;
        }
        long totalSeconds = (long)hours * 3600L + (long)minutes * 60L + (long)seconds;
        ModNetworking.CHANNEL.sendToServer((Object)new EgyptianTimerConfigPacket(totalSeconds));
        this.m_7379_();
    }

    private void onTrackVortex(Button button) {
        int seconds;
        int minutes;
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        int hours = this.parseInput(this.hoursInput.m_94155_(), 0, 23);
        long totalSeconds = (long)hours * 3600L + (long)(minutes = this.parseInput(this.minutesInput.m_94155_(), 0, 59)) * 60L + (long)(seconds = this.parseInput(this.secondsInput.m_94155_(), 0, 59));
        if (totalSeconds == 0L) {
            totalSeconds = 300L;
        }
        ModNetworking.CHANNEL.sendToServer((Object)new EgyptianTimerConfigPacket(totalSeconds));
        this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)"Searching for vortex...").m_130940_(ChatFormatting.GOLD), true);
        ModNetworking.CHANNEL.sendToServer((Object)new TrackVortexPacket());
        this.m_7379_();
    }

    private void onCancel(Button button) {
        this.m_7379_();
    }

    private int parseInput(String value, int min, int max) {
        try {
            int num = Integer.parseInt(value);
            if (num < min) {
                return min;
            }
            if (num > max) {
                return max;
            }
            return num;
        }
        catch (NumberFormatException e) {
            return min;
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }
}

