/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.screen;

import com.michelmuscle.slidersmod.item.ExodusTimerItem;
import com.michelmuscle.slidersmod.network.ExodusTimerConfigPacket;
import com.michelmuscle.slidersmod.network.ModNetworking;
import com.michelmuscle.slidersmod.screen.component.PortalStabilityUi;
import com.michelmuscle.slidersmod.util.GuiTextureHelper;
import com.michelmuscle.slidersmod.util.TimerUpgradeData;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ExodusTimerConfigScreen
extends Screen {
    private static final int GUI_WIDTH = GuiTextureHelper.DISPLAY_SIZE;
    private static final int GUI_HEIGHT = GuiTextureHelper.DISPLAY_SIZE;
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/gui/exodus.png");
    private static final ResourceLocation EXODUS_ON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/gui/exoduson.png");
    private static final GuiTextureHelper.TextureRect HOURS_FIELD = new GuiTextureHelper.TextureRect(69, 105, 112, 144);
    private static final GuiTextureHelper.TextureRect MINUTES_FIELD = new GuiTextureHelper.TextureRect(113, 105, 156, 144);
    private static final GuiTextureHelper.TextureRect SECONDS_FIELD = new GuiTextureHelper.TextureRect(157, 105, 200, 144);
    private static final GuiTextureHelper.TextureRect INFO_PANEL_AREA = new GuiTextureHelper.TextureRect(280, 14, 485, 320);
    private static final GuiTextureHelper.TextureRect SEED_FIELD_AREA = new GuiTextureHelper.TextureRect(280, 336, 485, 376);
    private static final GuiTextureHelper.TextureRect CONFIRM_BUTTON_AREA = new GuiTextureHelper.TextureRect(280, 391, 485, 431);
    private static final GuiTextureHelper.TextureRect CANCEL_BUTTON_AREA = new GuiTextureHelper.TextureRect(280, 446, 485, 486);
    private static final GuiTextureHelper.TextureRect EXODUS_ON_AREA = new GuiTextureHelper.TextureRect(195, 204, 259, 309);
    private static final boolean SHOW_DEBUG_OVERLAY = false;
    private static final int LED_INSET = Math.max(2, GuiTextureHelper.toLogicalWidth(4));
    private final ItemStack timerStack;
    private final boolean isTimerActive;
    private long maxConfigSeconds;
    private EditBox hoursInput;
    private EditBox minutesInput;
    private EditBox secondsInput;
    private EditBox seedInput;
    private Button confirmButton;
    private Button cancelButton;
    private int guiLeft;
    private int guiTop;
    private long remainingTime = 0L;

    public ExodusTimerConfigScreen(ItemStack timerStack) {
        super((Component)Component.m_237113_((String)"Exodus Timer Configuration"));
        this.timerStack = timerStack;
        this.isTimerActive = ExodusTimerItem.isActive(timerStack);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - GUI_WIDTH) / 2;
        this.guiTop = (this.f_96544_ - GUI_HEIGHT) / 2;
        this.maxConfigSeconds = TimerUpgradeData.getMaxConfiguredSeconds(this.timerStack);
        long currentSeconds = ExodusTimerItem.getConfiguredTime(this.timerStack);
        int hours = (int)(currentSeconds % 86400L / 3600L);
        int minutes = (int)(currentSeconds % 3600L / 60L);
        int seconds = (int)(currentSeconds % 60L);
        if (this.isTimerActive) {
            this.updateRemainingTime();
            long remainingSeconds = this.remainingTime / 20L;
            hours = (int)(remainingSeconds % 86400L / 3600L);
            minutes = (int)(remainingSeconds % 3600L / 60L);
            seconds = (int)(remainingSeconds % 60L);
        }
        this.hoursInput = this.createLedInputField(HOURS_FIELD, (Component)Component.m_237113_((String)"Hours"));
        this.hoursInput.m_94144_(String.format("%02d", hours));
        this.hoursInput.m_94186_(!this.isTimerActive);
        this.m_142416_((GuiEventListener)this.hoursInput);
        this.minutesInput = this.createLedInputField(MINUTES_FIELD, (Component)Component.m_237113_((String)"Minutes"));
        this.minutesInput.m_94144_(String.format("%02d", minutes));
        this.minutesInput.m_94186_(!this.isTimerActive);
        this.m_142416_((GuiEventListener)this.minutesInput);
        this.secondsInput = this.createLedInputField(SECONDS_FIELD, (Component)Component.m_237113_((String)"Seconds"));
        this.secondsInput.m_94144_(String.format("%02d", seconds));
        this.secondsInput.m_94186_(!this.isTimerActive);
        this.m_142416_((GuiEventListener)this.secondsInput);
        this.seedInput = this.createSeedInputField(SEED_FIELD_AREA, (Component)Component.m_237113_((String)"Dimension Seed"));
        String currentSeed = ExodusTimerItem.getConfiguredSeed(this.timerStack);
        this.seedInput.m_94144_(currentSeed.isEmpty() ? "" : currentSeed);
        this.seedInput.m_94186_(!this.isTimerActive && TimerUpgradeData.hasSeedUpgrade(this.timerStack));
        this.m_142416_((GuiEventListener)this.seedInput);
        if (!this.isTimerActive) {
            this.confirmButton = this.buildButton(CONFIRM_BUTTON_AREA, (Component)Component.m_237113_((String)"Confirm").m_130940_(ChatFormatting.WHITE), this::onConfirm);
            this.m_142416_((GuiEventListener)this.confirmButton);
        }
        this.cancelButton = this.buildButton(CANCEL_BUTTON_AREA, (Component)Component.m_237113_((String)"Cancel").m_130940_(ChatFormatting.WHITE), this::onCancel);
        this.m_142416_((GuiEventListener)this.cancelButton);
        this.addPortalStabilityControls();
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.isTimerActive) {
            this.updateRemainingTime();
            this.updateDisplayedTime();
        }
    }

    private void updateRemainingTime() {
        if (this.isTimerActive && this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            long activationTime = ExodusTimerItem.getActivationTime(this.timerStack);
            long configuredTime = ExodusTimerItem.getConfiguredTime(this.timerStack);
            long currentGameTime = this.f_96541_.f_91073_.m_46467_();
            long elapsed = currentGameTime - activationTime;
            this.remainingTime = Math.max(0L, configuredTime * 20L - elapsed);
        }
    }

    private void updateDisplayedTime() {
        long remainingSeconds = this.remainingTime / 20L;
        int hours = (int)(remainingSeconds % 86400L / 3600L);
        int minutes = (int)(remainingSeconds % 3600L / 60L);
        int seconds = (int)(remainingSeconds % 60L);
        this.hoursInput.m_94144_(String.format("%02d", hours));
        this.minutesInput.m_94144_(String.format("%02d", minutes));
        this.secondsInput.m_94144_(String.format("%02d", seconds));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        this.renderTimerTexture(graphics);
        this.drawInputBackgrounds(graphics);
        this.drawSeedBackground(graphics);
        this.drawInfoPanel(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void addPortalStabilityControls() {
        if (!PortalStabilityUi.shouldShow(this.timerStack)) {
            return;
        }
        int width = Math.max(80, INFO_PANEL_AREA.getLogicalWidth() - 20);
        int x = this.guiLeft + INFO_PANEL_AREA.getLogicalX() + 10;
        int baseY = this.guiTop + INFO_PANEL_AREA.getLogicalY() + INFO_PANEL_AREA.getLogicalHeight() - 52;
        this.m_142416_((GuiEventListener)PortalStabilityUi.createPortalButton(this.timerStack, x, baseY, width));
        this.m_142416_((GuiEventListener)PortalStabilityUi.createReturnButton(this.timerStack, x, baseY + 24, width));
    }

    private void drawInputBackgrounds(GuiGraphics graphics) {
        this.fillRect(graphics, HOURS_FIELD, -268435456);
        this.fillRect(graphics, MINUTES_FIELD, -268435456);
        this.fillRect(graphics, SECONDS_FIELD, -268435456);
    }

    private void drawSeedBackground(GuiGraphics graphics) {
        int x = this.guiLeft + SEED_FIELD_AREA.getLogicalX();
        int y = this.guiTop + SEED_FIELD_AREA.getLogicalY();
        int w = SEED_FIELD_AREA.getLogicalWidth();
        int h = SEED_FIELD_AREA.getLogicalHeight();
        graphics.m_280509_(x, y, x + w, y + h, -268435456);
        graphics.m_280509_(x, y, x + w, y + 1, 0x40FFFFFF);
        graphics.m_280509_(x, y + h - 1, x + w, y + h, 0x40666666);
        graphics.m_280509_(x, y, x + 1, y + h, 0x40666666);
        graphics.m_280509_(x + w - 1, y, x + w, y + h, 0x40FFFFFF);
    }

    private void drawInfoPanel(GuiGraphics graphics) {
        int x = this.guiLeft + INFO_PANEL_AREA.getLogicalX();
        int y = this.guiTop + INFO_PANEL_AREA.getLogicalY();
        int w = INFO_PANEL_AREA.getLogicalWidth();
        int h = INFO_PANEL_AREA.getLogicalHeight();
        graphics.m_280509_(x, y, x + w, y + h, -822083584);
        graphics.m_280509_(x, y, x + w, y + 1, 0x40FFFFFF);
        graphics.m_280509_(x, y + h - 1, x + w, y + h, 0x40666666);
        graphics.m_280509_(x, y, x + 1, y + h, 0x40666666);
        graphics.m_280509_(x + w - 1, y, x + w, y + h, 0x40FFFFFF);
        int padding = GuiTextureHelper.toLogicalX(8);
        int cursorY = y + padding;
        int textX = x + padding;
        long configuredSeconds = ExodusTimerItem.getConfiguredTime(this.timerStack);
        graphics.m_280488_(this.f_96547_, "Time set:", textX, cursorY, -1);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280488_(this.f_96547_, this.formatTimeSet(configuredSeconds), textX, cursorY += 9, -1);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280488_(this.f_96547_, "Range:", textX, cursorY += 9 + 4, -1);
        Objects.requireNonNull(this.f_96547_);
        String rangeValue = "1s to " + TimerUpgradeData.formatDurationSeconds(this.maxConfigSeconds);
        graphics.m_280488_(this.f_96547_, rangeValue, textX, cursorY += 9, -1);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280488_(this.f_96547_, "Seed Upgrade:", textX, cursorY += 9 + 6, -1);
        Objects.requireNonNull(this.f_96547_);
        boolean hasSeedUpgrade = TimerUpgradeData.hasSeedUpgrade(this.timerStack);
        String seedStatus = hasSeedUpgrade ? "Installed" : "Required";
        graphics.m_280488_(this.f_96547_, seedStatus, textX, cursorY += 9, -1);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280488_(this.f_96547_, "Seed:", textX, cursorY += 9 + 4, -1);
        Objects.requireNonNull(this.f_96547_);
        String configuredSeed = ExodusTimerItem.getConfiguredSeed(this.timerStack);
        String currentSeed = !hasSeedUpgrade ? "Upgrade required" : (configuredSeed.isEmpty() ? "Random destination" : configuredSeed);
        graphics.m_280488_(this.f_96547_, currentSeed, textX, cursorY += 9, -1);
    }

    private void renderTimerTexture(GuiGraphics graphics) {
        graphics.m_280411_(GUI_TEXTURE, this.guiLeft, this.guiTop, GUI_WIDTH, GUI_HEIGHT, 0.0f, 0.0f, 500, 500, 500, 500);
        if (this.isTimerActive) {
            this.renderExodusActiveOverlay(graphics);
        }
    }

    private void drawDebugOverlay(GuiGraphics graphics) {
        graphics.m_280509_(this.guiLeft, this.guiTop, this.guiLeft + GUI_WIDTH, this.guiTop + GUI_HEIGHT, 0x2000FFFF);
        for (int i = 0; i <= GUI_WIDTH; i += 10) {
            graphics.m_280509_(this.guiLeft + i, this.guiTop, this.guiLeft + i + 1, this.guiTop + GUI_HEIGHT, 0x20000000);
            graphics.m_280509_(this.guiLeft, this.guiTop + i, this.guiLeft + GUI_WIDTH, this.guiTop + i + 1, 0x20000000);
        }
    }

    private EditBox createLedInputField(GuiTextureHelper.TextureRect rect, Component label) {
        int rectWidth = rect.getLogicalWidth();
        int rectHeight = rect.getLogicalHeight();
        int fieldWidth = Math.max(14, rectWidth - LED_INSET * 2);
        int fieldHeight = Math.max(14, rectHeight - LED_INSET * 2);
        int x = this.guiLeft + rect.getLogicalX() + Math.max(0, (rectWidth - fieldWidth) / 2);
        int y = this.guiTop + rect.getLogicalY() + Math.max(0, (rectHeight - fieldHeight) / 2);
        EditBox field = new EditBox(this.f_96547_, x, y, fieldWidth, fieldHeight, label);
        field.m_94182_(false);
        field.m_94202_(-50130);
        field.m_94205_(-10867925);
        field.m_94199_(2);
        return field;
    }

    private EditBox createSeedInputField(GuiTextureHelper.TextureRect rect, Component label) {
        int x = this.guiLeft + rect.getLogicalX() + GuiTextureHelper.toLogicalX(6);
        int y = this.guiTop + rect.getLogicalY() + GuiTextureHelper.toLogicalY(6);
        int w = rect.getLogicalWidth() - GuiTextureHelper.toLogicalX(12);
        int h = rect.getLogicalHeight() - GuiTextureHelper.toLogicalY(12);
        EditBox field = new EditBox(this.f_96547_, x, y, Math.max(40, w), Math.max(14, h), label);
        field.m_94182_(false);
        field.m_94199_(8);
        field.m_94202_(-50130);
        field.m_94205_(-10867925);
        return field;
    }

    private Button buildButton(GuiTextureHelper.TextureRect rect, Component label, Button.OnPress onPress) {
        return Button.m_253074_((Component)label, (Button.OnPress)onPress).m_252987_(this.guiLeft + rect.getLogicalX(), this.guiTop + rect.getLogicalY(), rect.getLogicalWidth(), rect.getLogicalHeight()).m_253136_();
    }

    private void fillRect(GuiGraphics graphics, GuiTextureHelper.TextureRect rect, int color) {
        int x1 = this.guiLeft + rect.getLogicalX();
        int y1 = this.guiTop + rect.getLogicalY();
        int x2 = x1 + rect.getLogicalWidth();
        int y2 = y1 + rect.getLogicalHeight();
        graphics.m_280509_(x1, y1, x2, y2, color);
    }

    private String formatTimeSet(long totalSeconds) {
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    private void onConfirm(Button button) {
        String seed = this.seedInput.m_94155_();
        if (!seed.isEmpty()) {
            if (seed.length() != 8) {
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)"Seed must be exactly 8 digits or left empty!").m_130940_(ChatFormatting.RED), true);
                return;
            }
            try {
                Integer.parseInt(seed);
            }
            catch (NumberFormatException e) {
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)"Seed must contain only numbers!").m_130940_(ChatFormatting.RED), true);
                return;
            }
        }
        try {
            int hours = this.parseInput(this.hoursInput.m_94155_(), 0, 23);
            int minutes = this.parseInput(this.minutesInput.m_94155_(), 0, 59);
            int seconds = this.parseInput(this.secondsInput.m_94155_(), 0, 59);
            long totalSeconds = (long)hours * 3600L + (long)minutes * 60L + (long)seconds;
            if (totalSeconds < 1L) {
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)"Time must be at least 1 second!").m_130940_(ChatFormatting.RED), true);
                return;
            }
            ModNetworking.CHANNEL.sendToServer((Object)new ExodusTimerConfigPacket(seed, totalSeconds));
            this.m_7379_();
        }
        catch (NumberFormatException e) {
            this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)"Invalid input! Please enter valid numbers.").m_130940_(ChatFormatting.RED), true);
        }
    }

    private void onCancel(Button button) {
        this.m_7379_();
    }

    private int parseInput(String input, int min, int max) throws NumberFormatException {
        if (input.isEmpty()) {
            return 0;
        }
        int value = Integer.parseInt(input);
        if (value < min || value > max) {
            throw new NumberFormatException("Value out of range: " + value);
        }
        return value;
    }

    public boolean m_7043_() {
        return false;
    }

    private void renderExodusActiveOverlay(GuiGraphics graphics) {
        int x = this.guiLeft + EXODUS_ON_AREA.getLogicalX();
        int y = this.guiTop + EXODUS_ON_AREA.getLogicalY();
        int width = EXODUS_ON_AREA.getLogicalWidth();
        int height = EXODUS_ON_AREA.getLogicalHeight();
        int textureWidth = ExodusTimerConfigScreen.EXODUS_ON_AREA.x2 - ExodusTimerConfigScreen.EXODUS_ON_AREA.x1;
        int textureHeight = ExodusTimerConfigScreen.EXODUS_ON_AREA.y2 - ExodusTimerConfigScreen.EXODUS_ON_AREA.y1;
        graphics.m_280411_(EXODUS_ON_TEXTURE, x, y, width, height, 0.0f, 0.0f, textureWidth, textureHeight, textureWidth, textureHeight);
    }
}

