/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.screen;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.gui.EnergyBarRenderer;
import com.michelmuscle.slidersmod.gui.ProgressArrowRenderer;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.menu.ProtoSynchronizerMenu;
import com.michelmuscle.slidersmod.network.ModNetworking;
import com.michelmuscle.slidersmod.network.ProtoSynchronizerSeedPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ProtoSynchronizerScreen
extends AbstractContainerScreen<ProtoSynchronizerMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("slidersmod", "textures/gui/proto_synchronizer.png");
    private EditBox seedInputField;

    public ProtoSynchronizerScreen(ProtoSynchronizerMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.f_97729_ = Math.max(4, this.f_97729_ - 2);
        this.seedInputField = new EditBox(this.f_96547_, x + 80, y + 61, 70, 14, (Component)Component.m_237113_((String)"Seed"));
        this.seedInputField.m_94199_(8);
        this.seedInputField.m_94153_(s -> s.matches("[0-9]*"));
        this.seedInputField.m_257771_((Component)Component.m_237113_((String)"Seed"));
        this.seedInputField.m_94144_("");
        this.seedInputField.m_94182_(true);
        this.seedInputField.m_94202_(0xFFFFFF);
        this.seedInputField.m_94205_(0xA0A0A0);
        this.m_142416_((GuiEventListener)this.seedInputField);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.renderInputOverlay(guiGraphics, x, y);
        this.renderProgressArrow(guiGraphics, x, y);
        this.renderEnergyBar(guiGraphics, x, y);
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        int arrowX = x + 73;
        int arrowY = y + 38;
        if (((ProtoSynchronizerMenu)this.f_97732_).isProcessing()) {
            int progress = ((ProtoSynchronizerMenu)this.f_97732_).getScaledProgress();
            ProgressArrowRenderer.renderProgressArrow(guiGraphics, arrowX, arrowY, progress);
        } else {
            ProgressArrowRenderer.renderProgressArrow(guiGraphics, arrowX, arrowY, 0);
        }
    }

    private void renderEnergyBar(GuiGraphics guiGraphics, int x, int y) {
        int barX = x + 12;
        int barY = y + 18;
        int energyMax = ((ProtoSynchronizerMenu)this.f_97732_).getMaxEnergy();
        int energyPercent = energyMax > 0 ? ((ProtoSynchronizerMenu)this.f_97732_).getEnergy() * 100 / energyMax : 0;
        EnergyBarRenderer.renderEnergyBar(guiGraphics, barX, barY, energyPercent);
    }

    private void renderInputOverlay(GuiGraphics g, int x, int y) {
        ItemStack exodus = new ItemStack((ItemLike)ModItems.EXODUS_TIMER.get());
        ItemStack relocator = new ItemStack((ItemLike)ModItems.QUANTUM_RELOCATOR.get());
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.35f);
        g.m_280203_(exodus, x + 43, y + 16);
        g.m_280203_(relocator, x + 43, y + 52);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        if (this.seedInputField != null && this.seedInputField.m_93696_()) {
            if (keyCode == 257) {
                this.sendSeedToServer();
                return true;
            }
            if (this.seedInputField.m_7933_(keyCode, scanCode, modifiers)) {
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.seedInputField.m_93696_()) {
            return this.seedInputField.m_5534_(codePoint, modifiers);
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.seedInputField != null && this.seedInputField.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)this.seedInputField);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void sendSeedToServer() {
        String seed = this.seedInputField.m_94155_();
        if (seed.isEmpty()) {
            return;
        }
        if (seed.length() != 8) {
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)"Seed must be exactly 8 digits!").m_130940_(ChatFormatting.RED), true);
            }
            return;
        }
        ModNetworking.CHANNEL.sendToServer((Object)new ProtoSynchronizerSeedPacket(((ProtoSynchronizerMenu)this.f_97732_).getBlockPos(), seed));
        SlidersMod.LOGGER.info("Sent seed {} to server for Proto-Synchronizer at {}", (Object)seed, (Object)((ProtoSynchronizerMenu)this.f_97732_).getBlockPos());
    }

    protected void m_280072_(GuiGraphics guiGraphics, int x, int y) {
        super.m_280072_(guiGraphics, x, y);
        int leftPos = (this.f_96543_ - this.f_97726_) / 2;
        int topPos = (this.f_96544_ - this.f_97727_) / 2;
        if (x >= leftPos + 12 && x <= leftPos + 20 && y >= topPos + 18 && y <= topPos + 68) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)(((ProtoSynchronizerMenu)this.f_97732_).getEnergy() + " / " + ((ProtoSynchronizerMenu)this.f_97732_).getMaxEnergy() + " FE")), x, y);
        }
    }
}

