/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.screen;

import com.michelmuscle.slidersmod.item.OriginalTimerItem;
import com.michelmuscle.slidersmod.network.ModNetworking;
import com.michelmuscle.slidersmod.network.TimerConfigPacket;
import com.michelmuscle.slidersmod.screen.component.PortalStabilityUi;
import com.michelmuscle.slidersmod.util.GuiTextureHelper;
import com.michelmuscle.slidersmod.util.TimerUpgradeData;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class TimerConfigScreen
extends Screen {
    private static final int GUI_WIDTH = GuiTextureHelper.DISPLAY_SIZE;
    private static final int GUI_HEIGHT = GuiTextureHelper.DISPLAY_SIZE;
    private static final ResourceLocation ORIGINAL_TIMER_GUI = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/gui/original.png");
    private static final ResourceLocation OGRGBLED_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/gui/ogrgbled.png");
    private static final ResourceLocation OGLEDS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/gui/ogleds.png");
    private static final int OGRGBLED_X = 88;
    private static final int OGRGBLED_Y = 298;
    private static final int OGRGBLED_WIDTH = 51;
    private static final int OGRGBLED_HEIGHT = 94;
    private static final int OGRGBLED_FRAMES = 10;
    private static final int OGRGBLED_TICKS_PER_FRAME = 4;
    private static final int OGLEDS_X = 194;
    private static final int OGLEDS_Y = 300;
    private static final int OGLEDS_WIDTH = 53;
    private static final int OGLEDS_HEIGHT = 92;
    private static final int OGLEDS_FRAMES = 10;
    private static final int OGLEDS_TICKS_PER_FRAME = 2;
    private static final int OGLEDS_PINGPONG_CYCLE = 18;
    private static final GuiTextureHelper.TextureRect DAYS_FIELD = new GuiTextureHelper.TextureRect(127, 22, 220, 65);
    private static final GuiTextureHelper.TextureRect HOURS_FIELD = new GuiTextureHelper.TextureRect(78, 218, 131, 271);
    private static final GuiTextureHelper.TextureRect MINUTES_FIELD = new GuiTextureHelper.TextureRect(146, 218, 200, 271);
    private static final GuiTextureHelper.TextureRect SECONDS_FIELD = new GuiTextureHelper.TextureRect(215, 218, 269, 271);
    private static final GuiTextureHelper.TextureRect CONFIRM_BUTTON_AREA = new GuiTextureHelper.TextureRect(321, 378, 471, 423);
    private static final GuiTextureHelper.TextureRect CANCEL_BUTTON_AREA = new GuiTextureHelper.TextureRect(321, 438, 471, 483);
    private static final GuiTextureHelper.TextureRect INFO_PANEL_AREA = new GuiTextureHelper.TextureRect(293, 23, 496, 358);
    private static final int INPUT_INSET_X = Math.max(2, GuiTextureHelper.toLogicalWidth(6));
    private static final int INPUT_INSET_Y = Math.max(2, GuiTextureHelper.toLogicalHeight(6));
    private static final boolean SHOW_DEBUG_OVERLAY = false;
    private final ItemStack timerStack;
    private final boolean isTimerActive;
    private final long maxConfigSeconds;
    private EditBox daysInput;
    private EditBox hoursInput;
    private EditBox minutesInput;
    private EditBox secondsInput;
    private Button confirmButton;
    private Button cancelButton;
    private int guiLeft;
    private int guiTop;
    private long remainingTime = 0L;
    private int tickCounter = 0;

    public TimerConfigScreen(ItemStack timerStack) {
        super((Component)Component.m_237113_((String)"Timer Configuration"));
        this.timerStack = timerStack;
        this.isTimerActive = OriginalTimerItem.isActive(timerStack);
        this.maxConfigSeconds = TimerUpgradeData.getMaxConfiguredSeconds(timerStack);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - GUI_WIDTH) / 2;
        this.guiTop = (this.f_96544_ - GUI_HEIGHT) / 2;
        long currentSeconds = OriginalTimerItem.getConfiguredTime(this.timerStack);
        int days = (int)(currentSeconds / 86400L);
        int hours = (int)(currentSeconds % 86400L / 3600L);
        int minutes = (int)(currentSeconds % 3600L / 60L);
        int seconds = (int)(currentSeconds % 60L);
        if (this.isTimerActive) {
            this.updateRemainingTime();
            long remainingSeconds = this.remainingTime / 20L;
            days = (int)(remainingSeconds / 86400L);
            hours = (int)(remainingSeconds % 86400L / 3600L);
            minutes = (int)(remainingSeconds % 3600L / 60L);
            seconds = (int)(remainingSeconds % 60L);
        }
        this.daysInput = this.createInputField(DAYS_FIELD, (Component)Component.m_237113_((String)"Days"));
        this.daysInput.m_94144_(String.format("%02d", days));
        this.daysInput.m_94199_(2);
        this.daysInput.m_94186_(!this.isTimerActive);
        this.m_142416_((GuiEventListener)this.daysInput);
        this.hoursInput = this.createInputField(HOURS_FIELD, (Component)Component.m_237113_((String)"Hours"));
        this.hoursInput.m_94144_(String.format("%02d", hours));
        this.hoursInput.m_94199_(2);
        this.hoursInput.m_94186_(!this.isTimerActive);
        this.m_142416_((GuiEventListener)this.hoursInput);
        this.minutesInput = this.createInputField(MINUTES_FIELD, (Component)Component.m_237113_((String)"Minutes"));
        this.minutesInput.m_94144_(String.format("%02d", minutes));
        this.minutesInput.m_94199_(2);
        this.minutesInput.m_94186_(!this.isTimerActive);
        this.m_142416_((GuiEventListener)this.minutesInput);
        this.secondsInput = this.createInputField(SECONDS_FIELD, (Component)Component.m_237113_((String)"Seconds"));
        this.secondsInput.m_94144_(String.format("%02d", seconds));
        this.secondsInput.m_94199_(2);
        this.secondsInput.m_94186_(!this.isTimerActive);
        this.m_142416_((GuiEventListener)this.secondsInput);
        if (!this.isTimerActive) {
            this.confirmButton = Button.m_253074_((Component)Component.m_237113_((String)"Confirm"), this::onConfirm).m_252987_(this.guiLeft + CONFIRM_BUTTON_AREA.getLogicalX(), this.guiTop + CONFIRM_BUTTON_AREA.getLogicalY(), CONFIRM_BUTTON_AREA.getLogicalWidth(), CONFIRM_BUTTON_AREA.getLogicalHeight()).m_253136_();
            this.m_142416_((GuiEventListener)this.confirmButton);
        }
        this.cancelButton = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), this::onCancel).m_252987_(this.guiLeft + CANCEL_BUTTON_AREA.getLogicalX(), this.guiTop + CANCEL_BUTTON_AREA.getLogicalY(), CANCEL_BUTTON_AREA.getLogicalWidth(), CANCEL_BUTTON_AREA.getLogicalHeight()).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelButton);
        this.addPortalStabilityControls();
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.isTimerActive) {
            ++this.tickCounter;
            if (this.tickCounter >= 20) {
                this.tickCounter = 0;
                this.updateRemainingTime();
                this.updateDisplayedTime();
            }
        }
    }

    private void updateRemainingTime() {
        if (this.isTimerActive && this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            long activationTime = OriginalTimerItem.getActivationTime(this.timerStack);
            long configuredTime = OriginalTimerItem.getConfiguredTime(this.timerStack);
            long currentGameTime = this.f_96541_.f_91073_.m_46467_();
            long elapsed = currentGameTime - activationTime;
            this.remainingTime = Math.max(0L, configuredTime * 20L - elapsed);
        }
    }

    private void updateDisplayedTime() {
        long remainingSeconds = this.remainingTime / 20L;
        int days = (int)(remainingSeconds / 86400L);
        int hours = (int)(remainingSeconds % 86400L / 3600L);
        int minutes = (int)(remainingSeconds % 3600L / 60L);
        int seconds = (int)(remainingSeconds % 60L);
        this.daysInput.m_94144_(String.format("%02d", days));
        this.hoursInput.m_94144_(String.format("%02d", hours));
        this.minutesInput.m_94144_(String.format("%02d", minutes));
        this.secondsInput.m_94144_(String.format("%02d", seconds));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        this.renderTimerTexture(graphics);
        this.drawInputBackgrounds(graphics);
        long configuredSeconds = OriginalTimerItem.getConfiguredTime(this.timerStack);
        String timeSetText = this.formatTimeSet(configuredSeconds);
        this.drawInfoPanel(graphics, timeSetText);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private String formatTimeSet(long totalSeconds) {
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        return String.format("%02d:%02d:%02d:%02d", days, hours, minutes, seconds);
    }

    private void onConfirm(Button button) {
        try {
            int days = this.parseInput(this.daysInput.m_94155_(), 0, 99);
            int hours = this.parseInput(this.hoursInput.m_94155_(), 0, 23);
            int minutes = this.parseInput(this.minutesInput.m_94155_(), 0, 59);
            int seconds = this.parseInput(this.secondsInput.m_94155_(), 0, 59);
            long totalSeconds = (long)days * 86400L + (long)hours * 3600L + (long)minutes * 60L + (long)seconds;
            long minSeconds = 30L;
            long maxSeconds = this.maxConfigSeconds;
            if (totalSeconds < minSeconds || totalSeconds > maxSeconds) {
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)("Invalid duration! Must be between 30s and " + TimerUpgradeData.formatDurationSeconds(maxSeconds))).m_130940_(ChatFormatting.RED), true);
                return;
            }
            ModNetworking.CHANNEL.sendToServer((Object)new TimerConfigPacket(totalSeconds));
            this.m_7379_();
        }
        catch (NumberFormatException e) {
            this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)"Invalid input! Please enter valid numbers.").m_130940_(ChatFormatting.RED), true);
        }
    }

    private void onCancel(Button button) {
        this.m_7379_();
    }

    private int parseInput(String input, int min, int max) throws NumberFormatException {
        if (input.isEmpty()) {
            return 0;
        }
        int value = Integer.parseInt(input);
        if (value < min || value > max) {
            throw new NumberFormatException("Value out of range: " + value);
        }
        return value;
    }

    public boolean m_7043_() {
        return false;
    }

    private void drawInputBackgrounds(GuiGraphics graphics) {
        int black = -268435456;
        this.fillRect(graphics, DAYS_FIELD, black);
        this.fillRect(graphics, HOURS_FIELD, black);
        this.fillRect(graphics, MINUTES_FIELD, black);
        this.fillRect(graphics, SECONDS_FIELD, black);
    }

    private void fillRect(GuiGraphics graphics, GuiTextureHelper.TextureRect rect, int color) {
        int x1 = this.guiLeft + rect.getLogicalX();
        int y1 = this.guiTop + rect.getLogicalY();
        int x2 = x1 + rect.getLogicalWidth();
        int y2 = y1 + rect.getLogicalHeight();
        graphics.m_280509_(x1, y1, x2, y2, color);
    }

    private void drawInfoPanel(GuiGraphics graphics, String timeSetText) {
        int x = this.guiLeft + INFO_PANEL_AREA.getLogicalX();
        int y = this.guiTop + INFO_PANEL_AREA.getLogicalY();
        int w = INFO_PANEL_AREA.getLogicalWidth();
        int h = INFO_PANEL_AREA.getLogicalHeight();
        graphics.m_280509_(x, y, x + w, y + h, -1072689136);
        graphics.m_280509_(x, y, x + w, y + 1, 0x40FFFFFF);
        graphics.m_280509_(x, y + h - 1, x + w, y + h, 0x40000000);
        graphics.m_280509_(x, y, x + 1, y + h, 0x40000000);
        graphics.m_280509_(x + w - 1, y, x + w, y + h, 0x40FFFFFF);
        int padding = 6;
        int cursorY = y + padding;
        int textX = x + padding;
        graphics.m_280488_(this.f_96547_, "Time set:", textX, cursorY, -5592406);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280488_(this.f_96547_, timeSetText, textX, cursorY += 9, -1);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280488_(this.f_96547_, "Range:", textX, cursorY += 9 + 4, -3355444);
        Objects.requireNonNull(this.f_96547_);
        String rangeValue = "30s to " + TimerUpgradeData.formatDurationSeconds(this.maxConfigSeconds);
        graphics.m_280488_(this.f_96547_, rangeValue, textX, cursorY += 9, -2105377);
    }

    private EditBox createInputField(GuiTextureHelper.TextureRect rect, Component label) {
        int rectWidth = rect.getLogicalWidth();
        int rectHeight = rect.getLogicalHeight();
        int fieldWidth = Math.max(18, rectWidth - INPUT_INSET_X * 2);
        int fieldHeight = Math.max(16, rectHeight - INPUT_INSET_Y * 2);
        int x = this.guiLeft + rect.getLogicalX() + Math.max(0, (rectWidth - fieldWidth) / 2);
        int y = this.guiTop + rect.getLogicalY() + Math.max(0, (rectHeight - fieldHeight) / 2);
        EditBox field = new EditBox(this.f_96547_, x, y, fieldWidth, fieldHeight, label);
        field.m_94182_(false);
        field.m_94202_(-50130);
        field.m_94205_(-10867925);
        return field;
    }

    private void renderTimerTexture(GuiGraphics graphics) {
        graphics.m_280411_(ORIGINAL_TIMER_GUI, this.guiLeft, this.guiTop, GUI_WIDTH, GUI_HEIGHT, 0.0f, 0.0f, 500, 500, 500, 500);
        if (this.isTimerActive) {
            this.renderOgRgbLed(graphics);
            this.renderOgLeds(graphics);
        }
    }

    private void addPortalStabilityControls() {
        if (!PortalStabilityUi.shouldShow(this.timerStack)) {
            return;
        }
        int width = Math.max(60, INFO_PANEL_AREA.getLogicalWidth() - 16);
        int x = this.guiLeft + INFO_PANEL_AREA.getLogicalX() + 8;
        int baseY = this.guiTop + INFO_PANEL_AREA.getLogicalY() + INFO_PANEL_AREA.getLogicalHeight() - 52;
        this.m_142416_((GuiEventListener)PortalStabilityUi.createPortalButton(this.timerStack, x, baseY, width));
        this.m_142416_((GuiEventListener)PortalStabilityUi.createReturnButton(this.timerStack, x, baseY + 24, width));
    }

    private void renderOgRgbLed(GuiGraphics graphics) {
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            return;
        }
        long gameTime = this.f_96541_.f_91073_.m_46467_();
        int frame = (int)(gameTime / 4L % 10L);
        int screenX = this.guiLeft + GuiTextureHelper.toLogicalWidth(88);
        int screenY = this.guiTop + GuiTextureHelper.toLogicalHeight(298);
        int screenWidth = GuiTextureHelper.toLogicalWidth(51);
        int screenHeight = GuiTextureHelper.toLogicalHeight(94);
        int textureY = frame * 94;
        int textureWidth = 51;
        int textureSheetHeight = 940;
        graphics.m_280411_(OGRGBLED_TEXTURE, screenX, screenY, screenWidth, screenHeight, 0.0f, (float)textureY, 51, 94, textureWidth, textureSheetHeight);
    }

    private void renderOgLeds(GuiGraphics graphics) {
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            return;
        }
        long gameTime = this.f_96541_.f_91073_.m_46467_();
        int cyclePosition = (int)(gameTime / 2L % 18L);
        int frame = cyclePosition < 10 ? cyclePosition : 18 - cyclePosition;
        int screenX = this.guiLeft + GuiTextureHelper.toLogicalWidth(194);
        int screenY = this.guiTop + GuiTextureHelper.toLogicalHeight(300);
        int screenWidth = GuiTextureHelper.toLogicalWidth(53);
        int screenHeight = GuiTextureHelper.toLogicalHeight(92);
        int textureY = frame * 92;
        int textureWidth = 53;
        int textureSheetHeight = 920;
        graphics.m_280411_(OGLEDS_TEXTURE, screenX, screenY, screenWidth, screenHeight, 0.0f, (float)textureY, 53, 92, textureWidth, textureSheetHeight);
    }

    private void drawDebugOverlay(GuiGraphics graphics) {
        graphics.m_280509_(this.guiLeft, this.guiTop, this.guiLeft + GUI_WIDTH, this.guiTop + GUI_HEIGHT, 0x2000FFFF);
        for (int i = 0; i <= GUI_WIDTH; i += 10) {
            graphics.m_280509_(this.guiLeft + i, this.guiTop, this.guiLeft + i + 1, this.guiTop + GUI_HEIGHT, 0x20000000);
            graphics.m_280509_(this.guiLeft, this.guiTop + i, this.guiLeft + GUI_WIDTH, this.guiTop + i + 1, 0x20000000);
        }
    }
}

