/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.screen;

import com.michelmuscle.slidersmod.menu.TimerCustomizerMenu;
import com.michelmuscle.slidersmod.network.ModNetworking;
import com.michelmuscle.slidersmod.network.TimerCustomizerUpdatePacket;
import com.michelmuscle.slidersmod.util.CustomVortexVisuals;
import java.util.Locale;
import java.util.function.IntConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class TimerCustomizerScreen
extends AbstractContainerScreen<TimerCustomizerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/gui/timer_customizer.png");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private CycleButton<CustomVortexVisuals.ModelVariant> modelButton;
    private CycleButton<Boolean> trackingButton;
    private ColorSlider redSlider;
    private ColorSlider greenSlider;
    private ColorSlider blueSlider;
    private CustomVortexVisuals.ModelVariant currentModel;
    private CustomVortexVisuals.TextureVariant currentTexture;
    private int tintValue;
    private boolean trackingMode;
    private boolean trackerAvailable;

    public TimerCustomizerScreen(TimerCustomizerMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 256;
        this.f_97727_ = 256;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.refreshFromMenu();
        this.buildWidgets();
    }

    private void buildWidgets() {
        this.m_169413_();
        super.m_7856_();
        int panelX = this.f_97735_ + 120;
        int panelWidth = 120;
        int panelY = this.f_97736_ + 18;
        this.modelButton = (CycleButton)this.m_142416_((GuiEventListener)CycleButton.m_168894_(TimerCustomizerScreen::modelLabel).m_168961_((Object[])CustomVortexVisuals.ModelVariant.values()).m_168929_().m_168948_((Object)this.currentModel).m_168936_(panelX, panelY, panelWidth, 20, (Component)Component.m_237115_((String)"screen.slidersmod.timer_customizer.model"), (button, value) -> {
            this.currentModel = value;
            this.currentTexture = this.currentModel.defaultTexture();
            this.updateTintControls();
            this.sendUpdate();
        }));
        this.redSlider = (ColorSlider)this.m_142416_((GuiEventListener)new ColorSlider(panelX, panelY + 60, panelWidth, "R", this.getRed()));
        this.greenSlider = (ColorSlider)this.m_142416_((GuiEventListener)new ColorSlider(panelX, panelY + 84, panelWidth, "G", this.getGreen()));
        this.blueSlider = (ColorSlider)this.m_142416_((GuiEventListener)new ColorSlider(panelX, panelY + 108, panelWidth, "B", this.getBlue()));
        IntConsumer redResponder = value -> this.updateTintChannel(value, this.getGreen(), this.getBlue());
        IntConsumer greenResponder = value -> this.updateTintChannel(this.getRed(), value, this.getBlue());
        IntConsumer blueResponder = value -> this.updateTintChannel(this.getRed(), this.getGreen(), value);
        this.redSlider.setResponder(redResponder);
        this.greenSlider.setResponder(greenResponder);
        this.blueSlider.setResponder(blueResponder);
        this.trackingButton = (CycleButton)this.m_142416_((GuiEventListener)CycleButton.m_168896_((Component)Component.m_237115_((String)"options.on"), (Component)Component.m_237115_((String)"options.off")).m_168929_().m_168948_((Object)this.trackingMode).m_168936_(panelX, panelY + 140, panelWidth, 20, (Component)Component.m_237115_((String)"screen.slidersmod.timer_customizer.tracking"), (button, value) -> {
            this.trackingMode = value;
            this.sendUpdate();
        }));
        this.trackingButton.f_93623_ = this.trackerAvailable;
        this.updateTintControls();
    }

    private static Component modelLabel(CustomVortexVisuals.ModelVariant variant) {
        return Component.m_237113_((String)variant.id().toUpperCase(Locale.ROOT));
    }

    private void updateTintChannel(int red, int green, int blue) {
        this.tintValue = Mth.m_14045_((int)red, (int)0, (int)255) << 16 | Mth.m_14045_((int)green, (int)0, (int)255) << 8 | Mth.m_14045_((int)blue, (int)0, (int)255);
        this.sendUpdate();
    }

    private void refreshFromMenu() {
        CustomVortexVisuals.ModelVariant[] models = CustomVortexVisuals.ModelVariant.values();
        CustomVortexVisuals.TextureVariant[] textures = CustomVortexVisuals.TextureVariant.values();
        int modelIndex = Mth.m_14045_((int)((TimerCustomizerMenu)this.f_97732_).getModelIndex(), (int)0, (int)(models.length - 1));
        int textureIndex = Mth.m_14045_((int)((TimerCustomizerMenu)this.f_97732_).getTextureIndex(), (int)0, (int)(textures.length - 1));
        this.currentModel = models[modelIndex];
        this.currentTexture = CustomVortexVisuals.enforceTexture(this.currentModel, textures[textureIndex]);
        this.tintValue = ((TimerCustomizerMenu)this.f_97732_).getTintValue();
        this.trackingMode = ((TimerCustomizerMenu)this.f_97732_).isTrackingMode();
        this.trackerAvailable = ((TimerCustomizerMenu)this.f_97732_).isTrackerAvailable();
    }

    public void m_181908_() {
        super.m_181908_();
        CustomVortexVisuals.ModelVariant prevModel = this.currentModel;
        CustomVortexVisuals.TextureVariant prevTexture = this.currentTexture;
        int prevTint = this.tintValue;
        boolean prevTracking = this.trackingMode;
        boolean prevTrackerAvailable = this.trackerAvailable;
        this.refreshFromMenu();
        if (this.modelButton != null && this.currentModel != prevModel) {
            this.modelButton.m_168892_((Object)this.currentModel);
        }
        if (this.currentTexture != prevTexture) {
            this.updateTintControls();
        }
        if (this.tintValue != prevTint) {
            this.redSlider.setChannelValue(this.getRed());
            this.greenSlider.setChannelValue(this.getGreen());
            this.blueSlider.setChannelValue(this.getBlue());
        }
        if (this.trackingButton != null) {
            if (this.trackingMode != prevTracking) {
                this.trackingButton.m_168892_((Object)this.trackingMode);
            }
            if (this.trackerAvailable != prevTrackerAvailable) {
                this.trackingButton.f_93623_ = this.trackerAvailable;
            }
        }
    }

    private void updateTintControls() {
        boolean tintable = this.currentModel.tintable();
        if (this.redSlider != null) {
            this.redSlider.f_93623_ = tintable;
            this.greenSlider.f_93623_ = tintable;
            this.blueSlider.f_93623_ = tintable;
        }
    }

    private void sendUpdate() {
        this.currentTexture = this.currentModel.defaultTexture();
        ModNetworking.CHANNEL.sendToServer((Object)new TimerCustomizerUpdatePacket(((TimerCustomizerMenu)this.f_97732_).getBlockPos(), this.currentModel.ordinal(), this.currentTexture.ordinal(), this.tintValue, this.trackingMode));
    }

    private int getRed() {
        return this.tintValue >> 16 & 0xFF;
    }

    private int getGreen() {
        return this.tintValue >> 8 & 0xFF;
    }

    private int getBlue() {
        return this.tintValue & 0xFF;
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.m_280163_(TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, 8, 6, 0x404040, false);
        graphics.m_280614_(this.f_96547_, this.f_169604_, 8, this.f_97727_ - 96 + 2, 0x404040, false);
        int previewX = this.f_97735_ + 210;
        int previewY = this.f_97736_ + 82;
        graphics.m_280509_(previewX, previewY, previewX + 20, previewY + 20, 0xFF000000 | this.tintValue);
    }

    private static class ColorSlider
    extends AbstractSliderButton {
        private final String label;
        private IntConsumer responder = value -> {};

        ColorSlider(int x, int y, int width, String label, int channelValue) {
            super(x, y, width, 20, (Component)Component.m_237113_((String)label), (double)channelValue / 255.0);
            this.label = label;
            this.m_5695_();
        }

        void setResponder(IntConsumer responder) {
            this.responder = responder;
        }

        protected void m_5695_() {
            this.m_93666_((Component)Component.m_237113_((String)(this.label + ": " + this.getChannelValue())));
        }

        protected void m_5697_() {
            this.responder.accept(this.getChannelValue());
        }

        int getChannelValue() {
            return (int)Math.round(this.f_93577_ * 255.0);
        }

        void setChannelValue(int channel) {
            this.f_93577_ = Mth.m_14008_((double)((double)channel / 255.0), (double)0.0, (double)1.0);
            this.m_5695_();
        }
    }
}

