/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.screen;

import com.michelmuscle.slidersmod.gui.EnergyBarRenderer;
import com.michelmuscle.slidersmod.gui.ProgressArrowRenderer;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.menu.TimerSlotExpanderMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TimerSlotExpanderScreen
extends AbstractContainerScreen<TimerSlotExpanderMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("slidersmod", "textures/gui/analyzer_station.png");

    public TimerSlotExpanderScreen(TimerSlotExpanderMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        this.f_97730_ = 8;
        this.f_97731_ = this.f_97727_ - 92;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = 8;
        this.f_97729_ = 6;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.renderProgress(guiGraphics, x, y);
        this.renderEnergy(guiGraphics, x, y);
        this.renderInputOverlay(guiGraphics, x, y);
    }

    private void renderProgress(GuiGraphics guiGraphics, int x, int y) {
        int arrowX = x + 101;
        int arrowY = y + 38;
        if (((TimerSlotExpanderMenu)this.f_97732_).isProcessing()) {
            int max;
            int scaledProgress = ((TimerSlotExpanderMenu)this.f_97732_).getScaledProgress();
            int progressPercent = scaledProgress * 100 / (max = ((TimerSlotExpanderMenu)this.f_97732_).getMaxProgress());
            if (progressPercent > 100) {
                progressPercent = 100;
            }
            ProgressArrowRenderer.renderProgressArrow(guiGraphics, arrowX, arrowY, progressPercent);
        } else {
            ProgressArrowRenderer.renderProgressArrow(guiGraphics, arrowX, arrowY, 0);
        }
    }

    private void renderEnergy(GuiGraphics guiGraphics, int x, int y) {
        int barX = x + 12;
        int barY = y + 18;
        int energyMax = ((TimerSlotExpanderMenu)this.f_97732_).getMaxEnergy();
        int energyPercent = energyMax > 0 ? ((TimerSlotExpanderMenu)this.f_97732_).getEnergy() * 100 / energyMax : 0;
        EnergyBarRenderer.renderEnergyBar(guiGraphics, barX, barY, energyPercent);
    }

    private void renderInputOverlay(GuiGraphics g, int x, int y) {
        ItemStack timer = new ItemStack((ItemLike)ModItems.ORIGINAL_TIMER.get());
        ItemStack upgrade = new ItemStack((ItemLike)ModItems.SLOT_EXPANSER_UPGRADE.get());
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.35f);
        g.m_280203_(timer, x + 44, y + 34);
        g.m_280203_(upgrade, x + 80, y + 34);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }
}

