/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.screen;

import com.michelmuscle.slidersmod.block.entity.TimerWorkbenchBlockEntity;
import com.michelmuscle.slidersmod.gui.EnergyBarRenderer;
import com.michelmuscle.slidersmod.gui.ProgressArrowRenderer;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.menu.TimerWorkbenchMenu;
import com.michelmuscle.slidersmod.network.ModNetworking;
import com.michelmuscle.slidersmod.network.TimerWorkbenchApplyPacket;
import com.michelmuscle.slidersmod.util.TimerUpgradeSlots;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TimerWorkbenchScreen
extends AbstractContainerScreen<TimerWorkbenchMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("slidersmod", "textures/gui/timer_workbench.png");
    private static final ResourceLocation SLOT_TEXTURE = new ResourceLocation("slidersmod", "textures/gui/slot.png");
    private static final int[] CATEGORY_Y = new int[]{27, 52, 77, 102, 127};
    private static final int[] SLOT_X = new int[]{125, 148, 171, 194, 217};
    private static final int DECOR_OFFSET = -3;

    public TimerWorkbenchScreen(TimerWorkbenchMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.f_97726_ = 256;
        this.f_97727_ = 197;
        this.f_97730_ = Integer.MAX_VALUE;
        this.f_97731_ = Integer.MAX_VALUE;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = 8;
        this.f_97729_ = 6;
        int btnX = this.f_97735_ + 32;
        int btnY = this.f_97736_ + 73 + 25;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Apply"), b -> this.sendApply()).m_252987_(btnX, btnY, 60, 20).m_253136_());
    }

    private void sendApply() {
        ModNetworking.CHANNEL.sendToServer((Object)new TimerWorkbenchApplyPacket(((TimerWorkbenchMenu)this.f_97732_).getBlockPos()));
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.renderProgress(guiGraphics, x, y);
        this.renderEnergy(guiGraphics, x, y);
        this.renderSlots(guiGraphics, x, y);
        RenderSystem.disableBlend();
    }

    private void renderProgress(GuiGraphics guiGraphics, int x, int y) {
        int arrowX = x + 71;
        int arrowY = y + 53;
        int state = ((TimerWorkbenchMenu)this.f_97732_).getState();
        int percent = 0;
        if (state == TimerWorkbenchBlockEntity.State.ANALYZING.ordinal()) {
            percent = ((TimerWorkbenchMenu)this.f_97732_).getProgress() * 50 / 100;
        } else if (state == TimerWorkbenchBlockEntity.State.WORKING.ordinal()) {
            percent = 50 + ((TimerWorkbenchMenu)this.f_97732_).getProgress() * 50 / 100;
        }
        percent = Math.min(100, percent);
        ProgressArrowRenderer.renderProgressArrow(guiGraphics, arrowX, arrowY, percent);
    }

    private void renderEnergy(GuiGraphics guiGraphics, int x, int y) {
        int barX = x + 12;
        int barY = y + 18;
        int energyMax = ((TimerWorkbenchMenu)this.f_97732_).getMaxEnergy();
        int energyPercent = energyMax > 0 ? ((TimerWorkbenchMenu)this.f_97732_).getEnergy() * 100 / energyMax : 0;
        EnergyBarRenderer.renderEnergyBar(guiGraphics, barX, barY, energyPercent);
    }

    private void renderSlots(GuiGraphics guiGraphics, int left, int top) {
        ItemStack timer = ((TimerWorkbenchMenu)this.f_97732_).getTimerStack();
        if (timer.m_41619_()) {
            return;
        }
        TimerUpgradeSlots.initializeTimer(timer);
        for (int cat = 0; cat < 5; ++cat) {
            int count = TimerUpgradeSlots.getSlotCount(timer, cat);
            for (int s = 0; s < count && s < SLOT_X.length; ++s) {
                ItemStack hint;
                int px = SLOT_X[s];
                int py = CATEGORY_Y[cat];
                guiGraphics.m_280163_(SLOT_TEXTURE, left + px + -3, top + py + -3, 0.0f, 0.0f, 22, 22, 22, 22);
                int bufferIndex = cat * 5 + s;
                ItemStack current = ((TimerWorkbenchMenu)this.f_97732_).getBlockEntity().getUpgradeHandler().getStackInSlot(bufferIndex);
                if (!current.m_41619_() || (hint = this.getHintStack(cat, s, timer)).m_41619_()) continue;
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.35f);
                guiGraphics.m_280203_(hint, left + px, top + py);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
            }
        }
    }

    private ItemStack getHintStack(int cat, int slot, ItemStack timer) {
        switch (cat) {
            case 0: {
                return new ItemStack((ItemLike)ModItems.OVERHEAT_PROBABILITY_REDUCER.get());
            }
            case 1: {
                return new ItemStack((ItemLike)ModItems.OVERHEAT_COOLDOWN_REDUCER.get());
            }
            case 2: {
                return new ItemStack((ItemLike)ModItems.TEMPORAL_STABILIZER.get());
            }
            case 3: {
                return new ItemStack((ItemLike)ModItems.DIMENSIONAL_BUFFER.get());
            }
            case 4: {
                return switch (slot) {
                    case 0 -> new ItemStack((ItemLike)ModItems.EGYPTIAN_TRACKER_UPGRADE.get());
                    case 1 -> new ItemStack((ItemLike)ModItems.EXODUS_SEED_UPGRADE.get());
                    case 2 -> new ItemStack((ItemLike)ModItems.DIMENSION_ANCHOR.get());
                    case 3 -> new ItemStack((ItemLike)ModItems.PORTAL_STABILITY_UPGRADE.get());
                    case 4 -> new ItemStack((ItemLike)ModItems.CRYSTAL_BUFFER.get());
                    default -> ItemStack.f_41583_;
                };
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }
}

