/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.screen.component;

import com.michelmuscle.slidersmod.network.ModNetworking;
import com.michelmuscle.slidersmod.network.PortalStabilityConfigPacket;
import com.michelmuscle.slidersmod.util.TimerUpgradeData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public final class PortalStabilityUi {
    private static final List<Integer> PORTAL_VALUES = PortalStabilityUi.buildOptions(TimerUpgradeData.getMinPortalDurationTicks(), TimerUpgradeData.getMaxPortalDurationTicks());
    private static final List<Integer> RETURN_VALUES = PortalStabilityUi.buildOptions(TimerUpgradeData.getMinReturnDurationTicks(), TimerUpgradeData.getMaxReturnDurationTicks());

    private PortalStabilityUi() {
    }

    public static boolean shouldShow(ItemStack stack) {
        return TimerUpgradeData.hasPortalStabilityUpgrade(stack);
    }

    public static CycleButton<Integer> createPortalButton(ItemStack stack, int x, int y, int width) {
        return PortalStabilityUi.createButton(stack, x, y, width, (Component)Component.m_237113_((String)"Portal window"), PORTAL_VALUES, TimerUpgradeData.getPortalDurationTicks(stack), true);
    }

    public static CycleButton<Integer> createReturnButton(ItemStack stack, int x, int y, int width) {
        return PortalStabilityUi.createButton(stack, x, y, width, (Component)Component.m_237113_((String)"Return window"), RETURN_VALUES, TimerUpgradeData.getReturnPortalDurationTicks(stack), false);
    }

    private static CycleButton<Integer> createButton(ItemStack stack, int x, int y, int width, Component label, List<Integer> options, int initialValue, boolean editingPortal) {
        int clamped = PortalStabilityUi.clampToOptions(options, initialValue);
        return CycleButton.m_168894_(PortalStabilityUi::formatSecondsComponent).m_232502_(options).m_168948_((Object)clamped).m_168936_(x, y, width, 20, label, (button, value) -> PortalStabilityUi.applySelection(stack, value, editingPortal));
    }

    private static Component formatSecondsComponent(int ticks) {
        int seconds = Math.max(1, ticks / 20);
        return Component.m_237113_((String)(seconds + "s"));
    }

    private static void applySelection(ItemStack stack, int newValue, boolean editingPortal) {
        if (!TimerUpgradeData.hasPortalStabilityUpgrade(stack)) {
            return;
        }
        int portalTicks = editingPortal ? newValue : TimerUpgradeData.getPortalDurationTicks(stack);
        int returnTicks = editingPortal ? TimerUpgradeData.getReturnPortalDurationTicks(stack) : newValue;
        TimerUpgradeData.setPortalDurations(stack, portalTicks, returnTicks);
        ModNetworking.CHANNEL.sendToServer((Object)new PortalStabilityConfigPacket(portalTicks, returnTicks));
    }

    private static int clampToOptions(List<Integer> options, int ticks) {
        if (options.isEmpty()) {
            return ticks;
        }
        int best = options.get(0);
        int bestDiff = Math.abs(best - ticks);
        for (int value : options) {
            int diff = Math.abs(value - ticks);
            if (diff >= bestDiff) continue;
            bestDiff = diff;
            best = value;
        }
        return best;
    }

    private static List<Integer> buildOptions(int minTicks, int maxTicks) {
        if (minTicks > maxTicks) {
            return Collections.emptyList();
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int ticks = minTicks; ticks <= maxTicks; ticks += 20) {
            values.add(ticks);
        }
        return Collections.unmodifiableList(values);
    }
}

