/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.system;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.dimension.DimensionManager;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.init.ModSounds;
import com.michelmuscle.slidersmod.item.EgyptianTimerDamagedItem;
import com.michelmuscle.slidersmod.item.EgyptianTimerItem;
import com.michelmuscle.slidersmod.item.ExodusTimerDamagedItem;
import com.michelmuscle.slidersmod.item.ExodusTimerItem;
import com.michelmuscle.slidersmod.item.LoganTimerDamagedItem;
import com.michelmuscle.slidersmod.item.LoganTimerItem;
import com.michelmuscle.slidersmod.item.OriginalTimerDamagedItem;
import com.michelmuscle.slidersmod.item.OriginalTimerItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1Item;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2Item;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3Item;
import com.michelmuscle.slidersmod.network.ForceVortexWarningPacket;
import com.michelmuscle.slidersmod.network.ModNetworking;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.PacketDistributor;

public class ForceVortexManager {
    private static final Map<UUID, WarningInfo> activeWarnings = new HashMap<UUID, WarningInfo>();
    private static final Map<UUID, BurnoutInfo> scheduledBurnouts = new HashMap<UUID, BurnoutInfo>();

    public static void handleTimerSwingWhileActive(ServerPlayer player, ItemStack timerStack, int slotIndex) {
        UUID playerId = player.m_20148_();
        if (activeWarnings.containsKey(playerId)) {
            SlidersMod.LOGGER.info("Player {} forced vortex opening!", (Object)player.m_7755_().getString());
            ForceVortexManager.forceVortexOpening(player, timerStack);
            activeWarnings.remove(playerId);
        } else {
            SlidersMod.LOGGER.info("Player {} triggered force vortex warning", (Object)player.m_7755_().getString());
            ForceVortexManager.startWarning(player, slotIndex);
        }
    }

    private static void startWarning(ServerPlayer player, int slotIndex) {
        long startTime = player.m_9236_().m_46467_();
        activeWarnings.put(player.m_20148_(), new WarningInfo(startTime, slotIndex));
        ModNetworking.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ForceVortexWarningPacket(true, 5));
    }

    private static void forceVortexOpening(ServerPlayer player, ItemStack timerStack) {
        DimensionManager.clearScheduledReturn(player);
        CompoundTag tag = timerStack.m_41784_();
        boolean wasActive = tag.m_128471_("IsActive");
        tag.m_128379_("IsActive", false);
        tag.m_128379_("IsForcedVortex", true);
        tag.m_128359_("ReturnDimension", player.m_9236_().m_46472_().m_135782_().toString());
        tag.m_128347_("ReturnX", player.m_20185_());
        tag.m_128347_("ReturnY", player.m_20186_());
        tag.m_128347_("ReturnZ", player.m_20189_());
        SlidersMod.LOGGER.info("Force vortex: Reset return coordinates to current position");
        UUID playerId = player.m_20148_();
        activeWarnings.remove(playerId);
        ServerLevel serverLevel = (ServerLevel)player.m_9236_();
        ModNetworking.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ForceVortexWarningPacket(false, 0));
        SlidersMod.LOGGER.info("Sent immediate HUD cancel packet before vortex opening");
        if (timerStack.m_41720_() instanceof UpgradedLoganTimerTier1Item) {
            SlidersMod.LOGGER.info("Force vortex: Calling UpgradedLoganTimerTier1Item.onSwing()");
            UpgradedLoganTimerTier1Item.onSwing((Player)player, timerStack, player.m_9236_());
        } else if (timerStack.m_41720_() instanceof UpgradedLoganTimerTier2Item) {
            SlidersMod.LOGGER.info("Force vortex: Calling UpgradedLoganTimerTier2Item.onSwing()");
            UpgradedLoganTimerTier2Item.onSwing((Player)player, timerStack, player.m_9236_());
        } else if (timerStack.m_41720_() instanceof UpgradedLoganTimerTier3Item) {
            SlidersMod.LOGGER.info("Force vortex: Calling UpgradedLoganTimerTier3Item.onSwing()");
            UpgradedLoganTimerTier3Item.onSwing((Player)player, timerStack, player.m_9236_());
        } else if (timerStack.m_41720_() instanceof ExodusTimerItem) {
            SlidersMod.LOGGER.info("Force vortex: Calling ExodusTimerItem.onSwing()");
            ExodusTimerItem.setConfiguredSeed(timerStack, "");
            ExodusTimerItem.onSwing((Player)player, timerStack, player.m_9236_());
        } else if (timerStack.m_41720_() instanceof EgyptianTimerItem) {
            SlidersMod.LOGGER.info("Force vortex: Calling EgyptianTimerItem.onSwing()");
            EgyptianTimerItem.onSwing((Player)player, timerStack, player.m_9236_());
        } else if (timerStack.m_41720_() instanceof LoganTimerItem) {
            SlidersMod.LOGGER.info("Force vortex: Calling LoganTimerItem.onSwing()");
            LoganTimerItem.onSwing((Player)player, timerStack, player.m_9236_());
        } else {
            SlidersMod.LOGGER.info("Force vortex: Calling OriginalTimerItem.onSwing()");
            OriginalTimerItem.onSwing((Player)player, timerStack, player.m_9236_());
        }
        int i = 1;
        while (i <= 15) {
            int delay = i++;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(delay, () -> {
                ModNetworking.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ForceVortexWarningPacket(false, 0));
                if (delay == 1 || delay == 5 || delay == 15) {
                    SlidersMod.LOGGER.info("Sent HUD cancel packet (attempt {})", (Object)delay);
                }
            }));
        }
        SlidersMod.LOGGER.info("Force vortex opened, burnout will trigger on traversal");
        player.m_5661_((Component)Component.m_237113_((String)"Vortex forced! Timer will be damaged when you traverse it..."), true);
    }

    public static void executeInstantBurnout(ServerPlayer player, ItemStack timerStack) {
        SlidersMod.LOGGER.info("Executing INSTANT burnout for player {} after forced vortex traversal", (Object)player.m_7755_().getString());
        DimensionManager.clearScheduledReturn(player);
        SlidersMod.LOGGER.info("Cleared scheduled return - player must use damaged timer to escape!");
        player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.TIMER_BURNOUT.get(), SoundSource.PLAYERS, 1.5f, 1.0f);
        ForceVortexManager.swapTimerToDamaged(player, timerStack);
        ServerLevel level = (ServerLevel)player.m_9236_();
        long currentTime = level.m_46467_();
        BurnoutInfo info = new BurnoutInfo(currentTime);
        info.soundPlayed = true;
        info.particleEndTime = currentTime + 40L;
        scheduledBurnouts.put(player.m_20148_(), info);
        SlidersMod.LOGGER.info("Instant burnout executed! Particles scheduled for 2 seconds.");
    }

    public static void scheduleBurnoutParticles(UUID playerId, long particleEndTime) {
        BurnoutInfo info = new BurnoutInfo(0L);
        info.soundPlayed = true;
        info.particleEndTime = particleEndTime;
        scheduledBurnouts.put(playerId, info);
        SlidersMod.LOGGER.info("Burnout particles scheduled for player {} until {}", (Object)playerId, (Object)particleEndTime);
    }

    @Deprecated
    public static void scheduleBurnoutAfterForcedTraversal(UUID playerId, long currentGameTime) {
        SlidersMod.LOGGER.warn("scheduleBurnoutAfterForcedTraversal called but obsolete! Use executeInstantBurnout instead.");
    }

    public static void tick(ServerLevel level) {
        long currentTime = level.m_46467_();
        ForceVortexManager.tickWarnings(level, currentTime);
        ForceVortexManager.tickBurnouts(level, currentTime);
    }

    private static void tickWarnings(ServerLevel level, long currentTime) {
        Iterator<Map.Entry<UUID, WarningInfo>> iterator = activeWarnings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, WarningInfo> entry = iterator.next();
            UUID playerId = entry.getKey();
            WarningInfo info = entry.getValue();
            ServerPlayer player = level.m_7654_().m_6846_().m_11259_(playerId);
            if (player == null) {
                iterator.remove();
                continue;
            }
            long elapsed = currentTime - info.startTime;
            long secondsLeft = 5L - elapsed / 20L;
            if (elapsed % 20L == 0L && secondsLeft >= 0L) {
                ModNetworking.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ForceVortexWarningPacket(true, (int)secondsLeft));
            }
            if (elapsed < 100L) continue;
            ModNetworking.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ForceVortexWarningPacket(false, 0));
            iterator.remove();
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7aForce vortex canceled."), true);
        }
    }

    private static void tickBurnouts(ServerLevel level, long currentTime) {
        Iterator<Map.Entry<UUID, BurnoutInfo>> iterator = scheduledBurnouts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, BurnoutInfo> entry = iterator.next();
            UUID playerId = entry.getKey();
            BurnoutInfo info = entry.getValue();
            ServerPlayer player = level.m_7654_().m_6846_().m_11259_(playerId);
            if (player == null) {
                iterator.remove();
                continue;
            }
            if (info.particleEndTime > 0L && currentTime < info.particleEndTime) {
                ForceVortexManager.spawnSmokeParticles(player);
            }
            if (info.particleEndTime <= 0L || currentTime < info.particleEndTime) continue;
            iterator.remove();
            SlidersMod.LOGGER.info("Burnout particles finished for player {}", (Object)playerId);
        }
    }

    private static void spawnSmokeParticles(ServerPlayer player) {
        ServerLevel level = (ServerLevel)player.m_9236_();
        double x = player.m_20185_();
        double y = player.m_20186_() + 1.2;
        double z = player.m_20189_();
        for (int i = 0; i < 3; ++i) {
            double offsetX = (Math.random() - 0.5) * 0.3;
            double offsetY = Math.random() * 0.3;
            double offsetZ = (Math.random() - 0.5) * 0.3;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.05, 0.0, 0.01);
        }
    }

    private static void swapTimerToDamaged(ServerPlayer player, ItemStack timerStack) {
        int timerSlot = -1;
        String timerType = null;
        ItemStack foundTimer = null;
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            CompoundTag tag;
            ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (stack.m_41619_() || !(tag = stack.m_41784_()).m_128471_("IsForcedVortex")) continue;
            foundTimer = stack;
            timerSlot = i;
            SlidersMod.LOGGER.info("Found timer with IsForcedVortex flag at slot {}", (Object)i);
            break;
        }
        if (foundTimer == null) {
            String expectedType = ForceVortexManager.determineTimerType(timerStack);
            SlidersMod.LOGGER.warn("IsForcedVortex flag not found, fallback search for type: {}", (Object)expectedType);
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                CompoundTag tag;
                String stackType;
                ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (stack.m_41619_() || !(stackType = ForceVortexManager.determineTimerType(stack)).equals(expectedType) || !(tag = stack.m_41784_()).m_128471_("IsActive")) continue;
                foundTimer = stack;
                timerSlot = i;
                SlidersMod.LOGGER.info("Fallback: Found {} at slot {}", (Object)expectedType, (Object)i);
                break;
            }
        }
        if (foundTimer != null) {
            timerType = ForceVortexManager.determineTimerType(foundTimer);
            timerStack = foundTimer;
        } else {
            SlidersMod.LOGGER.warn("Could not find timer to damage!");
        }
        if (timerType != null && timerSlot >= 0) {
            ItemStack damagedTimer;
            SlidersMod.LOGGER.info("Found timer at slot {} for burnout (Type={})", (Object)timerSlot, (Object)timerType);
            switch (timerType) {
                case "logan": {
                    damagedTimer = new ItemStack((ItemLike)ModItems.LOGAN_TIMER_DAMAGED.get());
                    LoganTimerDamagedItem.initializeDamagedTimer(damagedTimer, player.m_9236_());
                    SlidersMod.LOGGER.info("Created damaged LOGAN timer");
                    break;
                }
                case "upgraded_tier1": {
                    int tier1X = timerStack.m_41784_().m_128451_("ConfiguredX");
                    int tier1Z = timerStack.m_41784_().m_128451_("ConfiguredZ");
                    damagedTimer = new ItemStack((ItemLike)ModItems.UPGRADED_LOGAN_TIMER_TIER1_DAMAGED.get());
                    UpgradedLoganTimerTier1DamagedItem.initializeDamagedTimer(damagedTimer, player.m_9236_(), tier1X, tier1Z);
                    SlidersMod.LOGGER.info("Created damaged UPGRADED LOGAN TIER 1 timer");
                    break;
                }
                case "upgraded_tier2": {
                    int tier2X = timerStack.m_41784_().m_128451_("ConfiguredX");
                    int tier2Z = timerStack.m_41784_().m_128451_("ConfiguredZ");
                    damagedTimer = new ItemStack((ItemLike)ModItems.UPGRADED_LOGAN_TIMER_TIER2_DAMAGED.get());
                    UpgradedLoganTimerTier2DamagedItem.initializeDamagedTimer(damagedTimer, player.m_9236_(), tier2X, tier2Z);
                    SlidersMod.LOGGER.info("Created damaged UPGRADED LOGAN TIER 2 timer");
                    break;
                }
                case "upgraded_tier3": {
                    int tier3X = timerStack.m_41784_().m_128451_("ConfiguredX");
                    int tier3Z = timerStack.m_41784_().m_128451_("ConfiguredZ");
                    damagedTimer = new ItemStack((ItemLike)ModItems.UPGRADED_LOGAN_TIMER_TIER3_DAMAGED.get());
                    UpgradedLoganTimerTier3DamagedItem.initializeDamagedTimer(damagedTimer, player.m_9236_(), tier3X, tier3Z);
                    SlidersMod.LOGGER.info("Created damaged UPGRADED LOGAN TIER 3 timer");
                    break;
                }
                case "exodus": {
                    damagedTimer = new ItemStack((ItemLike)ModItems.EXODUS_TIMER_DAMAGED.get());
                    ExodusTimerDamagedItem.initializeDamagedTimer(damagedTimer, player.m_9236_(), "");
                    SlidersMod.LOGGER.info("Created damaged EXODUS timer with EMPTY seed (forced vortex = random jumps)");
                    break;
                }
                case "egyptian": {
                    damagedTimer = new ItemStack((ItemLike)ModItems.EGYPTIAN_TIMER_DAMAGED.get());
                    EgyptianTimerDamagedItem.initializeDamagedTimer(damagedTimer, player.m_9236_());
                    SlidersMod.LOGGER.info("Created damaged EGYPTIAN timer");
                    break;
                }
                default: {
                    damagedTimer = new ItemStack((ItemLike)ModItems.ORIGINAL_TIMER_DAMAGED.get());
                    OriginalTimerDamagedItem.initializeDamagedTimer(damagedTimer, player.m_9236_());
                    SlidersMod.LOGGER.info("Created damaged ORIGINAL timer");
                }
            }
            player.m_150109_().m_6836_(timerSlot, damagedTimer);
            player.m_5661_((Component)Component.m_237113_((String)"Timer has been DAMAGED! Random jumps from now on."), false);
            SlidersMod.LOGGER.info("Timer swapped to damaged for player {} (Type: {})", (Object)player.m_7755_().getString(), (Object)timerType);
        } else {
            SlidersMod.LOGGER.warn("Could not find timer {} in inventory or could not determine type!", (Object)timerStack.m_41720_());
        }
    }

    public static boolean hasActiveWarning(UUID playerId) {
        return activeWarnings.containsKey(playerId);
    }

    public static void cancelWarningForPlayer(UUID playerId, MinecraftServer server) {
        if (activeWarnings.remove(playerId) != null) {
            SlidersMod.LOGGER.info("Canceled warning for player {}", (Object)playerId);
            ServerPlayer player = server.m_6846_().m_11259_(playerId);
            if (player != null) {
                int i = 0;
                while (i < 5) {
                    int delay = i++;
                    server.m_6937_((Runnable)new TickTask(delay, () -> ModNetworking.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ForceVortexWarningPacket(false, 0))));
                }
            }
        }
    }

    private static String determineTimerType(ItemStack stack) {
        if (stack.m_41720_() instanceof UpgradedLoganTimerTier1Item) {
            return "upgraded_tier1";
        }
        if (stack.m_41720_() instanceof UpgradedLoganTimerTier2Item) {
            return "upgraded_tier2";
        }
        if (stack.m_41720_() instanceof UpgradedLoganTimerTier3Item) {
            return "upgraded_tier3";
        }
        if (stack.m_41720_() instanceof LoganTimerItem) {
            return "logan";
        }
        if (stack.m_41720_() instanceof ExodusTimerItem) {
            return "exodus";
        }
        if (stack.m_41720_() instanceof EgyptianTimerItem) {
            return "egyptian";
        }
        if (stack.m_41720_() instanceof OriginalTimerItem) {
            return "original";
        }
        return "unknown";
    }

    private static class WarningInfo {
        final long startTime;
        final int slotIndex;

        WarningInfo(long startTime, int slotIndex) {
            this.startTime = startTime;
            this.slotIndex = slotIndex;
        }
    }

    private static class BurnoutInfo {
        final long burnoutTime;
        long particleEndTime;
        boolean soundPlayed;

        BurnoutInfo(long burnoutTime) {
            this.burnoutTime = burnoutTime;
            this.particleEndTime = 0L;
            this.soundPlayed = false;
        }
    }
}

