/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.system;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.advancements.AchievementManager;
import com.michelmuscle.slidersmod.config.SlidersModConfig;
import com.michelmuscle.slidersmod.entity.VortexEntity;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.init.ModSounds;
import com.michelmuscle.slidersmod.item.CustomTimerDamagedItem;
import com.michelmuscle.slidersmod.item.EgyptianTimerDamagedItem;
import com.michelmuscle.slidersmod.item.ExodusTimerDamagedItem;
import com.michelmuscle.slidersmod.item.LoganTimerDamagedItem;
import com.michelmuscle.slidersmod.item.OriginalTimerDamagedItem;
import com.michelmuscle.slidersmod.util.ClassicTimerHelper;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class SlidersRaidManager {
    private static final double TRIGGER_CHANCE_PER_TICK = 2.3148148148148148E-6;
    private static final long PLAYER_COOLDOWN_TICKS = 36000L;
    private static final int MIN_MOBS = 1;
    private static final int MAX_MOBS = 10;
    private static final int FIRST_SPAWN_DELAY = 100;
    private static final int SPAWN_DELAY_MIN = 100;
    private static final int SPAWN_DELAY_MAX = 100;
    private static final int POST_RAID_DELAY = 100;
    private static final double VORTEX_VERTICAL_OFFSET = 2.2;
    private static final int ANNOUNCEMENT_DELAY = 140;
    private static final double EXTRA_REPLICA_CHANCE = 0.35;
    public static final String RAID_DROP_TAG = "RaidFreshDrop";
    private static final Map<ResourceKey<Level>, List<ActiveRaid>> ACTIVE_RAIDS = new HashMap<ResourceKey<Level>, List<ActiveRaid>>();
    private static final Map<UUID, Long> PLAYER_COOLDOWN = new HashMap<UUID, Long>();
    private static final Map<UUID, RaidParticipant> PARTICIPANTS = new HashMap<UUID, RaidParticipant>();

    private SlidersRaidManager() {
    }

    public static void tick(ServerLevel level) {
        SlidersRaidManager.updateRaids(level);
        SlidersRaidManager.maybeStartRandomRaid(level);
    }

    public static boolean forceRaid(ServerPlayer player, @Nullable RaidTheme forcedTheme, @Nullable TimerStyle forcedStyle) {
        ServerLevel level = player.m_284548_();
        RaidTheme theme = forcedTheme != null ? forcedTheme : RaidTheme.random(level.f_46441_);
        TimerStyle style = forcedStyle != null ? forcedStyle : TimerStyle.random(level.f_46441_);
        return SlidersRaidManager.startRaid(level, player, theme, style);
    }

    public static void handleMobDeath(Entity entity, @Nullable Entity killer) {
        RaidParticipant participant = PARTICIPANTS.remove(entity.m_20148_());
        if (participant == null) {
            return;
        }
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (participant.carriesTimer) {
                double dropRate = (Double)SlidersModConfig.RAID_DAMAGED_TIMER_DROP_RATE.get();
                if (serverLevel.m_213780_().m_188500_() <= dropRate) {
                    ItemStack drop = new ItemStack((ItemLike)participant.style.damagedItem.get());
                    SlidersRaidManager.initializeRaidDamagedTimer(drop, serverLevel);
                    drop.m_41784_().m_128379_(RAID_DROP_TAG, true);
                    entity.m_19983_(drop);
                    if (((Boolean)SlidersModConfig.ENABLE_DEBUG_LOGGING.get()).booleanValue()) {
                        SlidersMod.LOGGER.info("Raid mob dropped damaged timer ({}% chance)", (Object)(dropRate * 100.0));
                    }
                }
            }
        }
        if (participant.isReplica && participant.theme == RaidTheme.DOPPLEGANGER) {
            Entity source = killer;
            if (source == null && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                source = living.m_21232_();
            }
            if (source instanceof ServerPlayer) {
                ServerPlayer killerPlayer = (ServerPlayer)source;
                AchievementManager.grantAchievement(killerPlayer, "tier_3_hate_myself", "kill_clone");
            }
        }
    }

    private static void updateRaids(ServerLevel level) {
        List<ActiveRaid> raids = ACTIVE_RAIDS.get(level.m_46472_());
        if (raids == null) {
            return;
        }
        long gameTime = level.m_46467_();
        raids.removeIf(raid -> {
            if (raid.vortexId == null) {
                if (gameTime >= raid.vortexSpawnTick) {
                    UUID uuid = SlidersRaidManager.spawnRaidVortex(level, raid.center, raid.facing, raid.timerStyle);
                    if (uuid == null) {
                        return true;
                    }
                    raid.vortexId = uuid;
                    raid.nextSpawnTick = Math.max(gameTime + 100L, raid.nextSpawnTick);
                }
                return false;
            }
            VortexEntity vortex = SlidersRaidManager.getRaidVortex(level, raid);
            if (vortex == null) {
                return true;
            }
            if (raid.spawnedCount < raid.totalSpawns && gameTime >= raid.nextSpawnTick) {
                SlidersRaidManager.spawnNextMob(level, raid);
            }
            if (raid.spawnedCount >= raid.totalSpawns) {
                if (raid.cleanupTick < 0L) {
                    SlidersMod.LOGGER.info("Raid {} completed all spawns ({})   closing in 5s", (Object)raid.theme.name().toLowerCase(), (Object)raid.totalSpawns);
                    raid.cleanupTick = gameTime + 100L;
                } else if (gameTime >= raid.cleanupTick) {
                    vortex.closeWithAnimation();
                    level.m_6263_(null, raid.center.f_82479_, raid.center.f_82480_, raid.center.f_82481_, (SoundEvent)ModSounds.VORTEX_CLOSE.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
                    return true;
                }
            }
            return false;
        });
        if (raids.isEmpty()) {
            ACTIVE_RAIDS.remove(level.m_46472_());
        }
    }

    private static void maybeStartRandomRaid(ServerLevel level) {
        double raidMultiplier = (Double)SlidersModConfig.RAID_PROBABILITY_MULTIPLIER.get();
        double adjustedChance = 2.3148148148148148E-6 * raidMultiplier;
        RandomSource random = level.f_46441_;
        for (ServerPlayer player : level.m_6907_()) {
            if (player.m_5833_()) continue;
            long last = PLAYER_COOLDOWN.getOrDefault(player.m_20148_(), -36000L);
            if (level.m_46467_() - last < 36000L || !(random.m_188500_() < adjustedChance)) continue;
            RaidTheme theme = RaidTheme.random(random);
            if (theme == RaidTheme.WARDEN && !((Boolean)SlidersModConfig.ENABLE_WARDEN_RAIDS.get()).booleanValue()) {
                if (!((Boolean)SlidersModConfig.ENABLE_DEBUG_LOGGING.get()).booleanValue()) continue;
                SlidersMod.LOGGER.info("Warden raid rolled but disabled in config, skipping");
                continue;
            }
            TimerStyle style = TimerStyle.random(random);
            if (!SlidersRaidManager.startRaid(level, player, theme, style)) continue;
            PLAYER_COOLDOWN.put(player.m_20148_(), level.m_46467_());
            if (!((Boolean)SlidersModConfig.ENABLE_DEBUG_LOGGING.get()).booleanValue()) continue;
            SlidersMod.LOGGER.info("Raid started with multiplier {}: theme={}, player={}", new Object[]{raidMultiplier, theme.name(), player.m_7755_().getString()});
        }
    }

    private static boolean startRaid(ServerLevel level, ServerPlayer source, RaidTheme theme, TimerStyle style) {
        Vec3 center = SlidersRaidManager.findSpawnLocation(level, source);
        if (center == null) {
            return false;
        }
        Vec3 facing = source.m_20182_().m_82546_(center).m_82541_();
        if (facing.m_82556_() < 1.0E-4) {
            facing = source.m_20154_().m_82541_();
        }
        if (facing.m_82556_() < 1.0E-4) {
            facing = new Vec3(0.0, 0.0, 1.0);
        }
        Vec3 normalizedFacing = facing.m_82541_();
        long vortexSpawnTick = level.m_46467_() + 140L;
        int mobCount = SlidersRaidManager.sampleMobCount(level, theme);
        ActiveRaid raid = new ActiveRaid((ResourceKey<Level>)level.m_46472_(), center, normalizedFacing, theme, style, mobCount, vortexSpawnTick, source.m_20148_());
        ACTIVE_RAIDS.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), key -> new ArrayList()).add(raid);
        SlidersMod.LOGGER.info("Sliders raid started: theme={}, style={}, mobs={}", new Object[]{theme.name().toLowerCase(), style.name().toLowerCase(), mobCount});
        level.m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, (SoundEvent)ModSounds.VORTEX_ANNOUNCEMENT.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
        ServerPlayer target = level.m_7654_().m_6846_().m_11259_(source.m_20148_());
        if (target != null) {
            AchievementManager.grantAchievement(target, "tier_3_the_timer_is_aggressive", "raid_spawned");
        }
        PLAYER_COOLDOWN.put(source.m_20148_(), level.m_46467_());
        return true;
    }

    private static int sampleMobCount(ServerLevel level, RaidTheme theme) {
        RandomSource random = level.f_46441_;
        if (theme.replicaOnly()) {
            if (theme == RaidTheme.DOPPLEGANGER && level.m_7654_() != null) {
                int playerCount = Math.max(1, level.m_7654_().m_6846_().m_11309_());
                return Math.max(theme.getMinSpawns(), Math.min(playerCount, theme.getMaxSpawns()));
            }
            return theme.getMinSpawns();
        }
        int min = Math.max(1, theme.getMinSpawns());
        int max = Math.max(min, theme.getMaxSpawns());
        return Mth.m_216271_((RandomSource)random, (int)min, (int)max);
    }

    public static boolean isRaidDamagedTimer(ItemStack stack) {
        return stack.m_41720_() instanceof OriginalTimerDamagedItem || stack.m_41720_() instanceof CustomTimerDamagedItem || stack.m_41720_() instanceof LoganTimerDamagedItem || stack.m_41720_() instanceof EgyptianTimerDamagedItem || stack.m_41720_() instanceof ExodusTimerDamagedItem;
    }

    public static void initializeRaidDamagedTimer(ItemStack stack, ServerLevel level) {
        if (stack.m_41720_() instanceof OriginalTimerDamagedItem) {
            OriginalTimerDamagedItem.initializeDamagedTimer(stack, (Level)level);
        } else if (stack.m_41720_() instanceof CustomTimerDamagedItem) {
            CustomTimerDamagedItem.initializeDamagedTimer(stack, (Level)level);
        } else if (stack.m_41720_() instanceof LoganTimerDamagedItem) {
            LoganTimerDamagedItem.initializeDamagedTimer(stack, (Level)level);
        } else if (stack.m_41720_() instanceof EgyptianTimerDamagedItem) {
            EgyptianTimerDamagedItem.initializeDamagedTimer(stack, (Level)level);
        } else if (stack.m_41720_() instanceof ExodusTimerDamagedItem) {
            ExodusTimerDamagedItem.initializeDamagedTimer(stack, (Level)level, "");
        } else {
            ClassicTimerHelper.initializeDamagedTimer(stack, (Level)level);
        }
    }

    private static UUID spawnRaidVortex(ServerLevel level, Vec3 center, Vec3 facing, TimerStyle style) {
        VortexEntity vortex = new VortexEntity((Level)level, center.f_82479_, center.f_82480_, center.f_82481_, true, true, style.isLogan, style.isExodus, style.isEgyptian, style.isProto);
        vortex.setFrontCollisionEnabled(false);
        vortex.setBackCollisionEnabled(false);
        vortex.setRaidPortal(true);
        level.m_7967_((Entity)vortex);
        Vec3 visualFacing = facing.m_82490_(-1.0);
        vortex.spawnOgVisuals(level, center, visualFacing);
        level.m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, (SoundEvent)ModSounds.VORTEX_INCOMING.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
        return vortex.m_20148_();
    }

    @Nullable
    private static Vec3 findSpawnLocation(ServerLevel level, ServerPlayer player) {
        RandomSource random = level.f_46441_;
        BlockPos playerPos = player.m_20183_();
        for (int i = 0; i < 12; ++i) {
            BlockState below;
            BlockPos base = playerPos.m_7918_(Mth.m_216271_((RandomSource)random, (int)-12, (int)12), 0, Mth.m_216271_((RandomSource)random, (int)-12, (int)12));
            BlockPos ground = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, base);
            if (!level.m_46749_(ground) || (below = level.m_8055_(ground.m_7495_())).m_60795_()) continue;
            double y = (double)ground.m_123342_() + 2.2;
            return new Vec3((double)ground.m_123341_() + 0.5, y, (double)ground.m_123343_() + 0.5);
        }
        return new Vec3(player.m_20185_(), player.m_20186_() + 2.2, player.m_20189_());
    }

    private static VortexEntity getRaidVortex(ServerLevel level, ActiveRaid raid) {
        if (raid.vortexId == null) {
            return null;
        }
        Entity entity = level.m_8791_(raid.vortexId);
        if (entity instanceof VortexEntity) {
            VortexEntity vortex = (VortexEntity)entity;
            return vortex;
        }
        return null;
    }

    private static void spawnNextMob(ServerLevel level, ActiveRaid raid) {
        boolean carriesTimer;
        ServerPlayer target;
        Mob mob = null;
        boolean isReplica = false;
        if (raid.theme.replicaOnly()) {
            mob = SlidersRaidManager.spawnReplicaMob(level, raid);
            boolean bl = isReplica = mob != null;
        }
        if (mob == null) {
            mob = raid.theme.createMob(level, level.f_46441_);
        }
        if (mob == null) {
            ++raid.spawnedCount;
            raid.nextSpawnTick = level.m_46467_() + 100L;
            return;
        }
        Vec3 spawnPos = raid.center;
        float yaw = (float)(Math.atan2(-raid.facing.f_82479_, raid.facing.f_82481_) * 57.29577951308232);
        mob.m_7678_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, yaw, mob.m_146909_());
        mob.m_5616_(yaw);
        mob.m_5618_(yaw);
        mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(BlockPos.m_274446_((Position)spawnPos)), MobSpawnType.EVENT, null, null);
        mob.m_20256_(raid.facing.m_82490_(0.4).m_82520_(0.0, 0.3, 0.0));
        level.m_7967_((Entity)mob);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123759_, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 15, 0.3, 0.3, 0.3, 0.05);
        SlidersMod.LOGGER.info("Raid {} spawning entity {}/{}: {}", new Object[]{raid.theme.name().toLowerCase(), raid.spawnedCount + 1, raid.totalSpawns, EntityType.m_20613_((EntityType)mob.m_6095_())});
        if (!raid.achievementGranted && level.m_7654_() != null && (target = level.m_7654_().m_6846_().m_11259_(raid.targetPlayer)) != null) {
            AchievementManager.grantAchievement(target, "tier_2_dont_slide_alone", "raid_mob_seen");
            raid.achievementGranted = true;
        }
        SlidersRaidManager.playVortexExitSound(level, spawnPos);
        boolean bl = carriesTimer = !raid.timerGiven;
        if (carriesTimer) {
            ItemStack stuck = new ItemStack((ItemLike)raid.timerStyle.stuckItem.get());
            mob.m_8061_(EquipmentSlot.MAINHAND, stuck);
            mob.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
            raid.timerGiven = true;
        }
        SlidersRaidManager.registerParticipant(mob, raid.timerStyle, carriesTimer, raid.theme, isReplica, raid.lastReplicaSource);
        ++raid.spawnedCount;
        raid.nextSpawnTick = level.m_46467_() + (long)Mth.m_216271_((RandomSource)level.f_46441_, (int)100, (int)100);
        if (raid.theme == RaidTheme.TRADER && !raid.camelSpawned) {
            SlidersRaidManager.spawnCamelCompanion(level, raid);
        }
    }

    @Nullable
    private static Mob spawnReplicaMob(ServerLevel level, ActiveRaid raid) {
        if (!raid.replicaSpawned) {
            Mob first = SlidersRaidManager.createTargetReplica(level, raid);
            raid.replicaSpawned = true;
            return first;
        }
        return SlidersRaidManager.maybeCreateAdditionalReplica(level, raid);
    }

    private static void spawnCamelCompanion(ServerLevel level, ActiveRaid raid) {
        Camel camel = (Camel)EntityType.f_243976_.m_20615_((Level)level);
        if (camel == null) {
            return;
        }
        Vec3 spawnPos = raid.center;
        float yaw = (float)(Math.atan2(-raid.facing.f_82479_, raid.facing.f_82481_) * 57.29577951308232);
        camel.m_7678_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, yaw, camel.m_146909_());
        camel.m_6518_((ServerLevelAccessor)level, level.m_6436_(BlockPos.m_274446_((Position)spawnPos)), MobSpawnType.EVENT, null, null);
        camel.m_20256_(raid.facing.m_82490_(0.3).m_82520_(0.0, 0.2, 0.0));
        level.m_7967_((Entity)camel);
        SlidersRaidManager.playVortexExitSound(level, spawnPos);
        raid.camelSpawned = true;
    }

    private static void registerParticipant(Mob mob, TimerStyle style, boolean carriesTimer, RaidTheme theme, boolean isReplica, @Nullable UUID clonedPlayer) {
        PARTICIPANTS.put(mob.m_20148_(), new RaidParticipant(style, carriesTimer, theme, isReplica, clonedPlayer));
    }

    @Nullable
    private static Mob createTargetReplica(ServerLevel level, ActiveRaid raid) {
        if (level.m_7654_() == null) {
            return null;
        }
        PlayerList list = level.m_7654_().m_6846_();
        ServerPlayer target = list.m_11259_(raid.targetPlayer);
        if (target != null && raid.clonedPlayers.add(target.m_20148_())) {
            return SlidersRaidManager.createReplicaMob(level, target.m_36316_(), target.m_20148_(), raid);
        }
        return SlidersRaidManager.createRandomReplica(level, raid, list);
    }

    @Nullable
    private static Mob maybeCreateAdditionalReplica(ServerLevel level, ActiveRaid raid) {
        if (level.m_7654_() == null || level.f_46441_.m_188500_() > 0.35) {
            return null;
        }
        PlayerList list = level.m_7654_().m_6846_();
        return SlidersRaidManager.createRandomReplica(level, raid, list);
    }

    @Nullable
    private static Mob createRandomReplica(ServerLevel level, ActiveRaid raid, PlayerList list) {
        ArrayList<ServerPlayer> candidates = new ArrayList<ServerPlayer>();
        for (ServerPlayer player : list.m_11314_()) {
            if (raid.clonedPlayers.contains(player.m_20148_())) continue;
            candidates.add(player);
        }
        if (candidates.isEmpty()) {
            return SlidersRaidManager.createReplicaMob(level, new GameProfile(UUID.randomUUID(), "Intrus"), null, raid);
        }
        ServerPlayer randomPlayer = (ServerPlayer)candidates.get(level.f_46441_.m_188503_(candidates.size()));
        raid.clonedPlayers.add(randomPlayer.m_20148_());
        return SlidersRaidManager.createReplicaMob(level, randomPlayer.m_36316_(), randomPlayer.m_20148_(), raid);
    }

    @Nullable
    private static Mob createReplicaMob(ServerLevel level, GameProfile profile, @Nullable UUID clonedPlayer, ActiveRaid raid) {
        Mob mob = (Mob)EntityType.f_20493_.m_20615_((Level)level);
        if (mob == null) {
            return null;
        }
        mob.m_6593_((Component)Component.m_237113_((String)profile.getName()));
        ItemStack head = SlidersRaidManager.createPlayerHead(profile);
        mob.m_8061_(EquipmentSlot.HEAD, head);
        mob.m_21409_(EquipmentSlot.HEAD, 0.0f);
        raid.lastReplicaSource = clonedPlayer;
        SlidersRaidManager.registerParticipant(mob, raid.timerStyle, false, raid.theme, true, clonedPlayer);
        return mob;
    }

    private static ItemStack createPlayerHead(GameProfile profile) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42680_);
        CompoundTag skullOwner = NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)profile);
        stack.m_41784_().m_128365_("SkullOwner", (Tag)skullOwner);
        return stack;
    }

    private static void playVortexExitSound(ServerLevel level, Vec3 pos) {
        level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)ModSounds.VORTEX_GO.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
    }

    public static enum RaidTheme {
        SKELETON(true, false, 1, 10, 1.0, EntityType.f_20524_, EntityType.f_20481_, EntityType.f_20497_),
        PIGLIN(true, false, 1, 10, 1.0, EntityType.f_20511_, EntityType.f_20512_, EntityType.f_20531_),
        ZOMBIE(true, false, 1, 10, 1.0, EntityType.f_20501_, EntityType.f_20458_, EntityType.f_20562_),
        CREEPER(true, false, 2, 5, 1.0, EntityType.f_20558_),
        ENDERMAN(true, false, 1, 10, 1.0, EntityType.f_20566_),
        WARDEN(true, false, 1, 1, 0.25, EntityType.f_217015_),
        VILLAGER(false, false, 2, 5, 1.0, EntityType.f_20492_),
        TRADER(false, false, 1, 2, 1.0, EntityType.f_20494_),
        DOPPLEGANGER(true, true, 1, 1, 1.0, new EntityType[0]);

        private final EntityType<? extends Mob>[] variants;
        private final boolean hostile;
        private final boolean replicaOnly;
        private final int minSpawns;
        private final int maxSpawns;
        private final double weight;
        private static final RaidTheme[] NATURAL_THEMES;
        private static final double NATURAL_WEIGHT_SUM;

        @SafeVarargs
        private RaidTheme(boolean hostile, boolean replicaOnly, int minSpawns, int maxSpawns, double weight, EntityType<? extends Mob> ... variants) {
            this.variants = variants;
            this.hostile = hostile;
            this.replicaOnly = replicaOnly;
            this.minSpawns = minSpawns;
            this.maxSpawns = maxSpawns;
            this.weight = weight;
        }

        @SafeVarargs
        private RaidTheme(boolean hostile, boolean replicaOnly, EntityType<? extends Mob> ... variants) {
            this(hostile, replicaOnly, hostile ? 1 : 1, hostile ? 10 : 2, 1.0, variants);
        }

        @Nullable
        public Mob createMob(ServerLevel level, RandomSource random) {
            if (this.replicaOnly || this.variants.length == 0) {
                return null;
            }
            EntityType<? extends Mob> type = this.variants[random.m_188503_(this.variants.length)];
            Mob mob = (Mob)type.m_20615_((Level)level);
            if (mob instanceof Villager) {
                Villager villager = (Villager)mob;
                villager.m_34375_(villager.m_7141_().m_35565_(VillagerProfession.f_35585_));
            }
            if (mob instanceof WanderingTrader) {
                WanderingTrader trader = (WanderingTrader)mob;
                trader.m_35891_(72000);
            }
            return mob;
        }

        public static RaidTheme random(RandomSource random) {
            if (NATURAL_THEMES.length == 0) {
                return RaidTheme.values()[0];
            }
            double totalWeight = NATURAL_WEIGHT_SUM <= 0.0 ? (double)NATURAL_THEMES.length : NATURAL_WEIGHT_SUM;
            double roll = random.m_188500_() * totalWeight;
            for (RaidTheme theme : NATURAL_THEMES) {
                double w = theme.weight <= 0.0 ? 1.0 : theme.weight;
                if (!((roll -= w) <= 0.0)) continue;
                return theme;
            }
            return NATURAL_THEMES[NATURAL_THEMES.length - 1];
        }

        public boolean isHostile() {
            return this.hostile;
        }

        public boolean replicaOnly() {
            return this.replicaOnly;
        }

        public static RaidTheme fromName(String name) {
            for (RaidTheme theme : RaidTheme.values()) {
                if (!theme.name().equalsIgnoreCase(name)) continue;
                return theme;
            }
            return null;
        }

        public static String[] names() {
            return (String[])Arrays.stream(RaidTheme.values()).map(theme -> theme.name().toLowerCase()).toArray(String[]::new);
        }

        public int getMinSpawns() {
            return this.minSpawns;
        }

        public int getMaxSpawns() {
            return this.maxSpawns;
        }

        static {
            ArrayList<RaidTheme> filtered = new ArrayList<RaidTheme>();
            double sum = 0.0;
            for (RaidTheme theme : RaidTheme.values()) {
                if (theme.replicaOnly) continue;
                filtered.add(theme);
                sum += theme.weight;
            }
            NATURAL_THEMES = filtered.toArray(new RaidTheme[0]);
            NATURAL_WEIGHT_SUM = sum;
        }
    }

    public static enum TimerStyle {
        ORIGINAL(false, false, false, false, (Supplier<Item>)ModItems.ORIGINAL_TIMER_STUCK, (Supplier<Item>)ModItems.ORIGINAL_TIMER_DAMAGED),
        CUSTOM(false, false, false, false, (Supplier<Item>)ModItems.CUSTOM_TIMER_STUCK, (Supplier<Item>)ModItems.CUSTOM_TIMER_DAMAGED),
        LOGAN(true, false, false, false, (Supplier<Item>)ModItems.LOGAN_TIMER_STUCK, (Supplier<Item>)ModItems.LOGAN_TIMER_DAMAGED),
        EGYPTIAN(false, false, true, false, (Supplier<Item>)ModItems.EGYPTIAN_TIMER_STUCK, (Supplier<Item>)ModItems.EGYPTIAN_TIMER_DAMAGED),
        EXODUS(false, true, false, false, (Supplier<Item>)ModItems.EXODUS_TIMER_STUCK, (Supplier<Item>)ModItems.EXODUS_TIMER_DAMAGED);

        final boolean isLogan;
        final boolean isExodus;
        final boolean isEgyptian;
        final boolean isProto;
        final Supplier<Item> stuckItem;
        final Supplier<Item> damagedItem;

        private TimerStyle(boolean logan, boolean exodus, boolean egyptian, boolean proto, Supplier<Item> stuckItem, Supplier<Item> damagedItem) {
            this.isLogan = logan;
            this.isExodus = exodus;
            this.isEgyptian = egyptian;
            this.isProto = proto;
            this.stuckItem = stuckItem;
            this.damagedItem = damagedItem;
        }

        public static TimerStyle random(RandomSource random) {
            TimerStyle[] values = TimerStyle.values();
            return values[random.m_188503_(values.length)];
        }

        @Nullable
        public static TimerStyle fromName(String name) {
            for (TimerStyle style : TimerStyle.values()) {
                if (!style.name().equalsIgnoreCase(name)) continue;
                return style;
            }
            return null;
        }

        public static String[] names() {
            return (String[])Arrays.stream(TimerStyle.values()).map(style -> style.name().toLowerCase()).toArray(String[]::new);
        }
    }

    private record RaidParticipant(TimerStyle style, boolean carriesTimer, RaidTheme theme, boolean isReplica, @Nullable UUID clonedPlayer) {
    }

    private static class ActiveRaid {
        final ResourceKey<Level> dimension;
        UUID vortexId;
        final Vec3 center;
        final Vec3 facing;
        final RaidTheme theme;
        final TimerStyle timerStyle;
        final int totalSpawns;
        final long vortexSpawnTick;
        final UUID targetPlayer;
        long nextSpawnTick;
        long cleanupTick = -1L;
        int spawnedCount = 0;
        boolean timerGiven = false;
        boolean camelSpawned = false;
        final Set<UUID> clonedPlayers = new HashSet<UUID>();
        boolean replicaSpawned = false;
        boolean achievementGranted = false;
        UUID lastReplicaSource = null;

        ActiveRaid(ResourceKey<Level> dimension, Vec3 center, Vec3 facing, RaidTheme theme, TimerStyle timerStyle, int totalSpawns, long vortexSpawnTick, UUID targetPlayer) {
            this.dimension = dimension;
            this.center = center;
            this.facing = facing;
            this.theme = theme;
            this.timerStyle = timerStyle;
            this.totalSpawns = totalSpawns;
            this.vortexSpawnTick = vortexSpawnTick;
            this.targetPlayer = targetPlayer;
            this.nextSpawnTick = vortexSpawnTick + 100L;
        }
    }
}

