/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.system;

import com.michelmuscle.slidersmod.SlidersMod;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class VortexRegistry {
    private static final Map<UUID, VortexRecord> vortexRegistry = new ConcurrentHashMap<UUID, VortexRecord>();
    private static final int MAX_RECORDS = 100;

    public static void registerVortex(BlockPos openLocation, ResourceKey<Level> destinationDim, BlockPos destinationPos, long currentGameTime) {
        UUID vortexId = UUID.randomUUID();
        VortexRecord record = new VortexRecord(currentGameTime, openLocation, destinationDim, destinationPos, currentGameTime);
        vortexRegistry.put(vortexId, record);
        if (vortexRegistry.size() > 100) {
            vortexRegistry.entrySet().stream().min(Comparator.comparingLong(e -> ((VortexRecord)e.getValue()).openTime)).ifPresent(entry -> vortexRegistry.remove(entry.getKey()));
        }
        SlidersMod.LOGGER.info("Registered vortex at {} -> {} at {}", new Object[]{openLocation, destinationDim.m_135782_(), destinationPos});
    }

    public static VortexRecord findNearestVortex(BlockPos searchCenter, long currentGameTime) {
        return vortexRegistry.values().stream().filter(record -> record.isValid(currentGameTime)).filter(record -> record.isInSearchRadius(searchCenter)).min(Comparator.comparingDouble(record -> Math.sqrt(Math.pow(record.openLocation.m_123341_() - searchCenter.m_123341_(), 2.0) + Math.pow(record.openLocation.m_123343_() - searchCenter.m_123343_(), 2.0)))).orElse(null);
    }

    public static List<VortexRecord> findAllVortexesInArea(BlockPos searchCenter, long currentGameTime) {
        ArrayList<VortexRecord> results = new ArrayList<VortexRecord>();
        for (VortexRecord record : vortexRegistry.values()) {
            if (!record.isValid(currentGameTime) || !record.isInSearchRadius(searchCenter)) continue;
            results.add(record);
        }
        return results;
    }

    public static void cleanup(long currentGameTime) {
        vortexRegistry.entrySet().removeIf(entry -> !((VortexRecord)entry.getValue()).isValid(currentGameTime));
    }

    public static int getSize() {
        return vortexRegistry.size();
    }

    public static class VortexRecord {
        public final long openTime;
        public final BlockPos openLocation;
        public final ResourceKey<Level> destinationDimension;
        public final BlockPos destinationPosition;
        public final long creationGameTime;

        public VortexRecord(long openTime, BlockPos openLocation, ResourceKey<Level> destinationDimension, BlockPos destinationPosition, long creationGameTime) {
            this.openTime = openTime;
            this.openLocation = openLocation;
            this.destinationDimension = destinationDimension;
            this.destinationPosition = destinationPosition;
            this.creationGameTime = creationGameTime;
        }

        public boolean isValid(long currentGameTime) {
            long ageInTicks = currentGameTime - this.openTime;
            long ageInMinutes = ageInTicks / 20L / 60L;
            return ageInMinutes <= 10L;
        }

        public boolean isInSearchRadius(BlockPos searchCenter) {
            int dx = Math.abs(this.openLocation.m_123341_() - searchCenter.m_123341_());
            int dz = Math.abs(this.openLocation.m_123343_() - searchCenter.m_123343_());
            return dx <= 48 && dz <= 48;
        }
    }
}

