/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.system;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.system.VortexRegistry;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class VortexTrackingSystem {
    private static final Map<UUID, TrackingState> playerTrackingStates = new ConcurrentHashMap<UUID, TrackingState>();
    private static final int SEARCH_DISPLAY_TIME = 100;
    private static final int REOPEN_WINDOW = 12000;

    public static void startTracking(ServerPlayer player, long currentGameTime) {
        UUID playerId = player.m_20148_();
        BlockPos playerPos = player.m_20183_();
        TrackingState state = new TrackingState(playerId, currentGameTime);
        playerTrackingStates.put(playerId, state);
        SlidersMod.LOGGER.info("Player {} started tracking vortex at {}, search will complete at tick {}", new Object[]{player.m_7755_().getString(), playerPos, state.searchCompleteTime});
        player.m_5661_((Component)Component.m_237113_((String)"\u00a76  Searching for vortexes... (5 seconds)"), true);
    }

    private static void performVortexSearch(ServerPlayer player, UUID playerId, TrackingState state, long currentGameTime) {
        BlockPos playerPos = player.m_20183_();
        VortexRegistry.VortexRecord foundVortex = VortexRegistry.findNearestVortex(playerPos, currentGameTime);
        if (foundVortex != null) {
            state.trackedVortex = foundVortex;
            state.state = 1;
            state.expirationTime = currentGameTime + 12000L;
            player.m_5661_((Component)Component.m_237113_((String)"\u00a76  Vortex Found! \u00a77You have 10 minutes to reopen it!"), false);
            SlidersMod.LOGGER.info("Player {} found vortex at {} -> {} (expires at tick {})", new Object[]{player.m_7755_().getString(), foundVortex.openLocation, foundVortex.destinationDimension.m_135782_(), state.expirationTime});
        } else {
            state.state = 4;
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7c  No Vortex Found! \u00a77Try in another location..."), false);
            SlidersMod.LOGGER.info("Player {} found no vortex", (Object)player.m_7755_().getString());
        }
    }

    public static void tickTrackingStates(long currentGameTime) {
        Iterator<Map.Entry<UUID, TrackingState>> iterator = playerTrackingStates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, TrackingState> entry = iterator.next();
            UUID playerId = entry.getKey();
            TrackingState state = entry.getValue();
            if (state.state == 0 && currentGameTime >= state.searchCompleteTime) {
                SlidersMod.LOGGER.info("Search complete time reached for player {}", (Object)playerId);
            }
            if (state.state == 1 && state.expirationTime > 0L && currentGameTime >= state.expirationTime) {
                state.state = 3;
                SlidersMod.LOGGER.info("Tracking expired for player {}", (Object)playerId);
            }
            if (state.state != 3 && state.state != 4 || currentGameTime < state.trackingStartTime + 100L + 12000L + 200L) continue;
            iterator.remove();
        }
    }

    public static void processTrackingSearch(ServerPlayer player, long currentGameTime) {
        UUID playerId = player.m_20148_();
        if (!playerTrackingStates.containsKey(playerId)) {
            return;
        }
        TrackingState state = playerTrackingStates.get(playerId);
        if (state.state == 0 && currentGameTime >= state.searchCompleteTime) {
            VortexTrackingSystem.performVortexSearch(player, playerId, state, currentGameTime);
        }
        if (state.state == 1 && state.expirationTime > 0L && currentGameTime >= state.expirationTime) {
            state.state = 3;
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7c  Tracking expired! Vortex window closed."), true);
            SlidersMod.LOGGER.info("Tracking expired for player {}", (Object)player.m_7755_().getString());
        }
    }

    public static VortexRegistry.VortexRecord getTrackedDestination(ServerPlayer player, long currentGameTime) {
        UUID playerId = player.m_20148_();
        if (!playerTrackingStates.containsKey(playerId)) {
            return null;
        }
        TrackingState state = playerTrackingStates.get(playerId);
        long timeSinceTracking = currentGameTime - state.trackingStartTime - 100L;
        if (timeSinceTracking > 12000L) {
            return null;
        }
        if (state.trackedVortex != null && state.state == 1) {
            state.state = 2;
            return state.trackedVortex;
        }
        return null;
    }

    public static void clearTracking(ServerPlayer player) {
        playerTrackingStates.remove(player.m_20148_());
    }

    public static TrackingState getTrackingState(ServerPlayer player) {
        return playerTrackingStates.getOrDefault(player.m_20148_(), null);
    }

    public static boolean isTracking(ServerPlayer player) {
        return playerTrackingStates.containsKey(player.m_20148_());
    }

    public static class TrackingState {
        public VortexRegistry.VortexRecord trackedVortex;
        public long trackingStartTime;
        public long searchCompleteTime;
        public long expirationTime;
        public int state;
        public UUID playerId;

        public TrackingState(UUID playerId, long currentTime) {
            this.playerId = playerId;
            this.trackedVortex = null;
            this.trackingStartTime = currentTime;
            this.searchCompleteTime = currentTime + 100L;
            this.expirationTime = -1L;
            this.state = 0;
        }
    }
}

