/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.util;

import com.michelmuscle.slidersmod.portal.VortexPortalTargets;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public final class CustomVortexVisuals {
    public static final String TAG_MODEL = "CustomVortexModel";
    public static final String TAG_TEXTURE = "CustomVortexTexture";
    public static final String TAG_TINT = "CustomVortexTint";
    public static final int DEFAULT_TINT = 0xFFFFFF;

    private CustomVortexVisuals() {
    }

    public static ModelVariant readModel(CompoundTag tag) {
        CustomVortexVisuals.ensureDefaults(tag);
        return ModelVariant.byId(tag.m_128461_(TAG_MODEL));
    }

    public static TextureVariant readTexture(CompoundTag tag) {
        CustomVortexVisuals.ensureDefaults(tag);
        return TextureVariant.byId(tag.m_128461_(TAG_TEXTURE));
    }

    public static int readTint(CompoundTag tag) {
        CustomVortexVisuals.ensureDefaults(tag);
        return tag.m_128451_(TAG_TINT);
    }

    public static void storeModel(CompoundTag tag, ModelVariant variant) {
        tag.m_128359_(TAG_MODEL, variant.id());
        variant.applyTimerFlags(tag);
    }

    public static void storeTexture(CompoundTag tag, TextureVariant variant) {
        tag.m_128359_(TAG_TEXTURE, variant.id());
    }

    public static void storeTint(CompoundTag tag, int tint) {
        tag.m_128405_(TAG_TINT, tint);
    }

    private static void ensureDefaults(CompoundTag tag) {
        if (!tag.m_128425_(TAG_MODEL, 8)) {
            CustomVortexVisuals.storeModel(tag, ModelVariant.ORIGINAL);
        }
        if (!tag.m_128425_(TAG_TEXTURE, 8)) {
            CustomVortexVisuals.storeTexture(tag, ModelVariant.ORIGINAL.defaultTexture());
        }
        if (!tag.m_128425_(TAG_TINT, 3)) {
            CustomVortexVisuals.storeTint(tag, 0xFFFFFF);
        }
    }

    public static boolean isTintableTexture(String textureId) {
        return TextureVariant.byId(textureId).tintable();
    }

    public static ResourceLocation resolveEntityTexture(String textureId, ResourceLocation fallback) {
        TextureVariant variant = TextureVariant.byId(textureId);
        return switch (variant) {
            case TextureVariant.CUSTOM_OG -> ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/entity/customog.png");
            case TextureVariant.CUSTOM_EGYPTIAN -> ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/entity/customegypt.png");
            case TextureVariant.CUSTOM_EXODUS -> ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/entity/customexodus.png");
            default -> fallback;
        };
    }

    public static TextureVariant enforceTexture(ModelVariant model, TextureVariant stored) {
        if (stored == model.defaultTexture()) {
            return stored;
        }
        if (!model.tintable()) {
            return model.defaultTexture();
        }
        if (!stored.tintable()) {
            return model.defaultTexture();
        }
        return stored;
    }

    public static enum ModelVariant {
        ORIGINAL("original", PortalFamily.ORIGINAL, TextureVariant.ORIGINAL, false, 3.0, 3.0),
        CUSTOM_ORIGINAL("custom_original", PortalFamily.ORIGINAL, TextureVariant.CUSTOM_OG, true, 3.0, 3.0),
        LOGAN("logan", PortalFamily.LOGAN, TextureVariant.LOGAN, false, 3.0, 3.0),
        EGYPTIAN("egyptian", PortalFamily.EGYPTIAN, TextureVariant.EGYPTIAN, false, 3.0, 3.0),
        CUSTOM_EGYPTIAN("custom_egyptian", PortalFamily.EGYPTIAN, TextureVariant.CUSTOM_EGYPTIAN, true, 3.0, 3.0),
        PROTO("proto", PortalFamily.PROTO, TextureVariant.PROTO, false, 3.0, 3.0),
        EXODUS("exodus", PortalFamily.EXODUS, TextureVariant.EXODUS, false, 4.2, 3.0),
        CUSTOM_EXODUS("custom_exodus", PortalFamily.EXODUS, TextureVariant.CUSTOM_EXODUS, true, 4.2, 3.0);

        private final String id;
        private final PortalFamily family;
        private final TextureVariant defaultTexture;
        private final boolean custom;
        private final double width;
        private final double height;

        private ModelVariant(String id, PortalFamily family, TextureVariant texture, boolean custom, double width, double height) {
            this.id = id;
            this.family = family;
            this.defaultTexture = texture;
            this.custom = custom;
            this.width = width;
            this.height = height;
        }

        public String id() {
            return this.id;
        }

        public TextureVariant defaultTexture() {
            return this.defaultTexture;
        }

        public boolean tintable() {
            return this.defaultTexture.tintable();
        }

        public boolean isCustom() {
            return this.custom;
        }

        public double portalWidth() {
            return this.width;
        }

        public double portalHeight() {
            return this.height;
        }

        public PortalFamily family() {
            return this.family;
        }

        public void applyTimerFlags(CompoundTag tag) {
            tag.m_128379_("IsLoganVortex", this.family == PortalFamily.LOGAN);
            tag.m_128379_("IsExodusVortex", this.family == PortalFamily.EXODUS);
            tag.m_128379_("IsEgyptianVortex", this.family == PortalFamily.EGYPTIAN || this.family == PortalFamily.PROTO);
            tag.m_128379_("IsProtoVortex", this.family == PortalFamily.PROTO);
        }

        public static ModelVariant byId(String raw) {
            if (raw == null || raw.isEmpty()) {
                return ORIGINAL;
            }
            String normalized = raw.toLowerCase(Locale.ROOT);
            for (ModelVariant variant : ModelVariant.values()) {
                if (!variant.id.equals(normalized)) continue;
                return variant;
            }
            return ORIGINAL;
        }
    }

    public static enum TextureVariant {
        ORIGINAL("original", () -> VortexPortalTargets.ORIGINAL, false),
        LOGAN("logan", () -> VortexPortalTargets.LOGAN, false),
        EGYPTIAN("egyptian", () -> VortexPortalTargets.EGYPTIAN, false),
        PROTO("proto", () -> VortexPortalTargets.PROTO, false),
        EXODUS("exodus", () -> VortexPortalTargets.EXODUS, false),
        CUSTOM_OG("customog", () -> VortexPortalTargets.ORIGINAL, true),
        CUSTOM_EGYPTIAN("customegypt", () -> VortexPortalTargets.EGYPTIAN, true),
        CUSTOM_EXODUS("customexodus", () -> VortexPortalTargets.EXODUS, true);

        private final String id;
        private final Supplier<VortexPortalTargets.ShowcaseTarget> targetSupplier;
        private final boolean tintable;

        private TextureVariant(String id, Supplier<VortexPortalTargets.ShowcaseTarget> targetSupplier, boolean tintable) {
            this.id = id;
            this.targetSupplier = targetSupplier;
            this.tintable = tintable;
        }

        public String id() {
            return this.id;
        }

        public VortexPortalTargets.ShowcaseTarget showcaseTarget() {
            return this.targetSupplier.get();
        }

        public boolean tintable() {
            return this.tintable;
        }

        public static TextureVariant byId(String raw) {
            if (raw == null || raw.isEmpty()) {
                return ORIGINAL;
            }
            String normalized = raw.toLowerCase(Locale.ROOT);
            for (TextureVariant variant : TextureVariant.values()) {
                if (!variant.id.equals(normalized)) continue;
                return variant;
            }
            return ORIGINAL;
        }
    }

    public static enum PortalFamily {
        ORIGINAL,
        LOGAN,
        EGYPTIAN,
        PROTO,
        EXODUS;

    }
}

