/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.util;

public class GuiTextureHelper {
    public static final int TEXTURE_SIZE = 500;
    public static final float DISPLAY_SCALE = 0.48f;
    public static final int DISPLAY_SIZE = Math.round(240.0f);
    public static final float SCALE_RATIO = (float)DISPLAY_SIZE / 500.0f;

    public static int toLogicalX(int textureX) {
        return Math.round((float)textureX * SCALE_RATIO);
    }

    public static int toLogicalY(int textureY) {
        return Math.round((float)textureY * SCALE_RATIO);
    }

    public static int toLogicalWidth(int textureWidth) {
        return Math.round((float)textureWidth * SCALE_RATIO);
    }

    public static int toLogicalHeight(int textureHeight) {
        return Math.round((float)textureHeight * SCALE_RATIO);
    }

    public static class TextureRect {
        public final int x1;
        public final int y1;
        public final int x2;
        public final int y2;

        public TextureRect(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public int getLogicalX() {
            return GuiTextureHelper.toLogicalX(this.x1);
        }

        public int getLogicalY() {
            return GuiTextureHelper.toLogicalY(this.y1);
        }

        public int getLogicalWidth() {
            return GuiTextureHelper.toLogicalWidth(this.x2 - this.x1);
        }

        public int getLogicalHeight() {
            return GuiTextureHelper.toLogicalHeight(this.y2 - this.y1);
        }

        public int getCenterX() {
            return GuiTextureHelper.toLogicalX((this.x1 + this.x2) / 2);
        }

        public int getCenterY() {
            return GuiTextureHelper.toLogicalY((this.y1 + this.y2) / 2);
        }
    }
}

