/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.util;

import com.michelmuscle.slidersmod.dimension.DimensionManager;
import com.michelmuscle.slidersmod.item.EgyptianTimerDamagedItem;
import com.michelmuscle.slidersmod.item.EgyptianTimerItem;
import com.michelmuscle.slidersmod.item.EgyptianTimerStuckItem;
import com.michelmuscle.slidersmod.item.ExodusTimerDamagedItem;
import com.michelmuscle.slidersmod.item.ExodusTimerItem;
import com.michelmuscle.slidersmod.item.ExodusTimerStuckItem;
import com.michelmuscle.slidersmod.item.LoganTimerDamagedItem;
import com.michelmuscle.slidersmod.item.LoganTimerItem;
import com.michelmuscle.slidersmod.item.LoganTimerStuckItem;
import com.michelmuscle.slidersmod.item.OriginalTimerDamagedItem;
import com.michelmuscle.slidersmod.item.OriginalTimerItem;
import com.michelmuscle.slidersmod.item.OriginalTimerStuckItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1Item;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1StuckItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2Item;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2StuckItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3Item;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3StuckItem;
import com.michelmuscle.slidersmod.util.TimerUpgradeData;
import com.michelmuscle.slidersmod.util.TimerUpgradeSlots;
import com.michelmuscle.slidersmod.util.UpgradeInstance;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class TimerUpgradeAnalyzer {
    private static final Set<Class<? extends Item>> SUPPORTED_TIMER_TYPES = new HashSet<Class<? extends Item>>();

    private TimerUpgradeAnalyzer() {
    }

    public static boolean isSupportedTimer(Item item) {
        return SUPPORTED_TIMER_TYPES.contains(item.getClass());
    }

    public static List<Component> buildReport(ItemStack stack) {
        ArrayList<Component> lines = new ArrayList<Component>();
        if (stack.m_41619_()) {
            return lines;
        }
        int tier = DimensionManager.getTimerTier(stack);
        lines.add((Component)Component.m_237110_((String)"gui.slidersmod.analyzer.dimension_tier", (Object[])new Object[]{tier, 5}).m_130940_(ChatFormatting.AQUA));
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            TimerUpgradeAnalyzer.appendUpgradeTiers(lines, stack);
            TimerUpgradeAnalyzer.appendSlotUpgrades(lines, stack);
            TimerUpgradeAnalyzer.appendTrackerData(lines, tag);
            TimerUpgradeAnalyzer.appendSeedSlots(lines, tag);
            TimerUpgradeAnalyzer.appendOverheat(lines, tag);
        } else {
            lines.add((Component)Component.m_237115_((String)"gui.slidersmod.analyzer.no_nbt").m_130940_(ChatFormatting.GRAY));
        }
        return lines;
    }

    private static void appendConfiguredTime(List<Component> lines, CompoundTag tag) {
        long seconds;
        if (tag.m_128441_("ConfiguredTime") && (seconds = tag.m_128454_("ConfiguredTime")) > 0L) {
            lines.add((Component)Component.m_237110_((String)"gui.slidersmod.analyzer.configured_time", (Object[])new Object[]{TimerUpgradeAnalyzer.formatDuration(seconds)}).m_130940_(ChatFormatting.YELLOW));
        }
    }

    private static void appendUpgradeTiers(List<Component> lines, ItemStack stack) {
        int cooldownTier = TimerUpgradeData.getCooldownTier(stack);
        lines.add((Component)Component.m_237113_((String)("Cooldown Tier: " + cooldownTier + "/3")).m_130940_(ChatFormatting.AQUA));
        lines.add((Component)Component.m_237113_((String)("Cooldown Reducer Upgrades: " + cooldownTier)).m_130940_(ChatFormatting.GRAY));
        int overheatTier = TimerUpgradeData.getOverheatReductionTier(stack);
        double chance = TimerUpgradeData.getPermanentOverheatChance(stack) * 100.0;
        lines.add((Component)Component.m_237113_((String)("Overheat Reduction Tier: " + overheatTier + "/4 (" + String.format("%.0f", chance) + "%)")).m_130940_(ChatFormatting.AQUA));
        lines.add((Component)Component.m_237113_((String)("Overheat Mitigation Upgrades: " + overheatTier)).m_130940_(ChatFormatting.GRAY));
        int temporalTier = TimerUpgradeData.getTemporalTier(stack);
        if (temporalTier > 0) {
            lines.add((Component)Component.m_237113_((String)("Temporal Tier: " + temporalTier)).m_130940_(ChatFormatting.AQUA));
        }
        if (TimerUpgradeData.hasPortalStabilityUpgrade(stack)) {
            double portalSeconds = (double)TimerUpgradeData.getPortalDurationTicks(stack) / 20.0;
            double returnSeconds = (double)TimerUpgradeData.getReturnPortalDurationTicks(stack) / 20.0;
            lines.add((Component)Component.m_237113_((String)String.format("Portal Stability: %.1fs / %.1fs", portalSeconds, returnSeconds)).m_130940_(ChatFormatting.GOLD));
        }
        if (TimerUpgradeData.hasSeedUpgrade(stack)) {
            lines.add((Component)Component.m_237113_((String)"Seed Upgrade Installed").m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
        if (TimerUpgradeData.hasTrackerUpgrade(stack)) {
            lines.add((Component)Component.m_237113_((String)"Tracker Upgrade Installed").m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
    }

    private static void appendSlotUpgrades(List<Component> lines, ItemStack stack) {
        if (!TimerUpgradeSlots.isTimer(stack)) {
            return;
        }
        TimerUpgradeSlots.initializeTimer(stack);
        int total = TimerUpgradeSlots.getTotalSlots(stack);
        lines.add((Component)Component.m_237113_((String)("Slot-based upgrades: " + total + " slots")).m_130940_(ChatFormatting.DARK_AQUA));
        for (int cat = 0; cat < 5; ++cat) {
            int unlocked = TimerUpgradeSlots.getSlotCount(stack, cat);
            for (int i = 0; i < unlocked; ++i) {
                UpgradeInstance inst = TimerUpgradeSlots.getUpgrade(stack, cat, i);
                if (inst == null) {
                    lines.add((Component)Component.m_237113_((String)("  [" + TimerUpgradeAnalyzer.categoryName(cat) + "] Slot " + (i + 1) + ": empty")).m_130940_(ChatFormatting.GRAY));
                    continue;
                }
                lines.add((Component)Component.m_237113_((String)("  [" + TimerUpgradeAnalyzer.categoryName(cat) + "] Slot " + (i + 1) + ": " + inst.getType().getDisplayName() + " (" + inst.getFormattedValue() + ", " + inst.getRarity().name() + ")")).m_130940_(ChatFormatting.GREEN));
            }
        }
    }

    private static String categoryName(int cat) {
        return switch (cat) {
            case 0 -> "Overheat Prob.";
            case 1 -> "Overheat Cooldown";
            case 2 -> "Temporal";
            case 3 -> "Dimensional";
            case 4 -> "Special";
            default -> "Unknown";
        };
    }

    private static void appendTrackerData(List<Component> lines, CompoundTag tag) {
        boolean trackerUnlocked = TimerUpgradeAnalyzer.anyTruthy(tag, "HasTrackerUpgrade", "TrackerUnlocked", "TrackerUpgrade", "EgyptianTracker", "TrackerModule");
        MutableComponent trackerStatus = Component.m_237115_((String)(trackerUnlocked ? "gui.slidersmod.analyzer.tracker.active" : "gui.slidersmod.analyzer.tracker.inactive")).m_130940_(trackerUnlocked ? ChatFormatting.GREEN : ChatFormatting.RED);
        lines.add((Component)Component.m_237110_((String)"gui.slidersmod.analyzer.tracker", (Object[])new Object[]{trackerStatus}).m_130940_(ChatFormatting.GRAY));
        if (tag.m_128441_("TrackingMode")) {
            int mode = tag.m_128451_("TrackingMode");
            String key = mode == 1 ? "gui.slidersmod.analyzer.mode.tracking" : "gui.slidersmod.analyzer.mode.random";
            lines.add((Component)Component.m_237110_((String)"gui.slidersmod.analyzer.tracking_mode", (Object[])new Object[]{Component.m_237115_((String)key).m_130940_(ChatFormatting.LIGHT_PURPLE)}).m_130940_(ChatFormatting.GRAY));
        }
    }

    private static void appendSeedSlots(List<Component> lines, CompoundTag tag) {
        int slots = 0;
        if (tag.m_128441_("SeedSlots")) {
            slots = Math.max(slots, tag.m_128451_("SeedSlots"));
        }
        if (tag.m_128441_("DimensionAnchorSlots")) {
            slots = Math.max(slots, tag.m_128451_("DimensionAnchorSlots"));
        }
        if (tag.m_128441_("AnchorSlots")) {
            slots = Math.max(slots, tag.m_128451_("AnchorSlots"));
        }
        if (slots > 0) {
            lines.add((Component)Component.m_237110_((String)"gui.slidersmod.analyzer.seed_slots", (Object[])new Object[]{slots}).m_130940_(ChatFormatting.BLUE));
        }
    }

    private static void appendOverheat(List<Component> lines, CompoundTag tag) {
        boolean overheated = tag.m_128471_("IsOverheated");
        if (tag.m_128441_("IsOverheated")) {
            MutableComponent status = Component.m_237115_((String)(overheated ? "gui.slidersmod.analyzer.overheat.hot" : "gui.slidersmod.analyzer.overheat.cool")).m_130940_(overheated ? ChatFormatting.RED : ChatFormatting.GREEN);
            lines.add((Component)Component.m_237110_((String)"gui.slidersmod.analyzer.overheat", (Object[])new Object[]{status}).m_130940_(ChatFormatting.GRAY));
        }
    }

    private static boolean anyTruthy(CompoundTag tag, String ... keys) {
        for (String key : keys) {
            if (!tag.m_128441_(key)) continue;
            if (tag.m_128471_(key)) {
                return true;
            }
            if (tag.m_128425_(key, 1) || tag.m_128451_(key) <= 0) continue;
            return true;
        }
        return false;
    }

    private static String formatDuration(long totalSeconds) {
        long minutes = totalSeconds / 60L;
        long seconds = totalSeconds % 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        if (hours > 0L) {
            return String.format(Locale.ROOT, "%02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format(Locale.ROOT, "%02d:%02d", minutes, seconds);
    }

    static {
        SUPPORTED_TIMER_TYPES.add(OriginalTimerItem.class);
        SUPPORTED_TIMER_TYPES.add(OriginalTimerDamagedItem.class);
        SUPPORTED_TIMER_TYPES.add(OriginalTimerStuckItem.class);
        SUPPORTED_TIMER_TYPES.add(LoganTimerItem.class);
        SUPPORTED_TIMER_TYPES.add(LoganTimerDamagedItem.class);
        SUPPORTED_TIMER_TYPES.add(LoganTimerStuckItem.class);
        SUPPORTED_TIMER_TYPES.add(UpgradedLoganTimerTier1Item.class);
        SUPPORTED_TIMER_TYPES.add(UpgradedLoganTimerTier1DamagedItem.class);
        SUPPORTED_TIMER_TYPES.add(UpgradedLoganTimerTier1StuckItem.class);
        SUPPORTED_TIMER_TYPES.add(UpgradedLoganTimerTier2Item.class);
        SUPPORTED_TIMER_TYPES.add(UpgradedLoganTimerTier2DamagedItem.class);
        SUPPORTED_TIMER_TYPES.add(UpgradedLoganTimerTier2StuckItem.class);
        SUPPORTED_TIMER_TYPES.add(UpgradedLoganTimerTier3Item.class);
        SUPPORTED_TIMER_TYPES.add(UpgradedLoganTimerTier3DamagedItem.class);
        SUPPORTED_TIMER_TYPES.add(UpgradedLoganTimerTier3StuckItem.class);
        SUPPORTED_TIMER_TYPES.add(ExodusTimerItem.class);
        SUPPORTED_TIMER_TYPES.add(ExodusTimerDamagedItem.class);
        SUPPORTED_TIMER_TYPES.add(ExodusTimerStuckItem.class);
        SUPPORTED_TIMER_TYPES.add(EgyptianTimerItem.class);
        SUPPORTED_TIMER_TYPES.add(EgyptianTimerDamagedItem.class);
        SUPPORTED_TIMER_TYPES.add(EgyptianTimerStuckItem.class);
    }
}

