/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.util;

import com.michelmuscle.slidersmod.config.SlidersModConfig;
import com.michelmuscle.slidersmod.item.CustomTimerDamagedItem;
import com.michelmuscle.slidersmod.item.CustomTimerItem;
import com.michelmuscle.slidersmod.item.CustomTimerStuckItem;
import com.michelmuscle.slidersmod.item.EgyptianTimerDamagedItem;
import com.michelmuscle.slidersmod.item.EgyptianTimerItem;
import com.michelmuscle.slidersmod.item.EgyptianTimerStuckItem;
import com.michelmuscle.slidersmod.item.ExodusTimerDamagedItem;
import com.michelmuscle.slidersmod.item.ExodusTimerItem;
import com.michelmuscle.slidersmod.item.ExodusTimerStuckItem;
import com.michelmuscle.slidersmod.item.LoganTimerDamagedItem;
import com.michelmuscle.slidersmod.item.LoganTimerItem;
import com.michelmuscle.slidersmod.item.LoganTimerStuckItem;
import com.michelmuscle.slidersmod.item.OriginalTimerDamagedItem;
import com.michelmuscle.slidersmod.item.OriginalTimerItem;
import com.michelmuscle.slidersmod.item.OriginalTimerStuckItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1Item;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1StuckItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2Item;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2StuckItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3Item;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3StuckItem;
import com.michelmuscle.slidersmod.util.TimerUpgradeSlots;
import com.michelmuscle.slidersmod.util.UpgradeInstance;
import com.michelmuscle.slidersmod.util.UpgradeType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class TimerUpgradeData {
    private static final String TAG_UPGRADES = "TimerUpgrades";
    private static final String TAG_COOLDOWN_TIER = "CooldownTier";
    private static final String TAG_OVERHEAT_REDUCTION_TIER = "OverheatReductionTier";
    private static final String TAG_TEMPORAL_TIER = "TemporalTier";
    private static final String TAG_HAS_TRACKER_UPGRADE = "HasTrackerUpgrade";
    private static final String TAG_HAS_SEED_UPGRADE = "HasSeedUpgrade";
    private static final String TAG_SEED_SLOTS = "SeedSlots";
    private static final String TAG_HAS_PORTAL_STABILITY = "HasPortalStabilityUpgrade";
    private static final String TAG_PORTAL_DURATION_TICKS = "PortalDurationTicks";
    private static final String TAG_RETURN_DURATION_TICKS = "ReturnPortalDurationTicks";
    private static final int MIN_CONFIG_SECONDS = 30;
    private static final int BASE_MAX_CONFIG_SECONDS = 600;
    private static final int TEMPORAL_STEP_SECONDS = 600;
    private static final int[] COOLDOWN_TIERS_TICKS = new int[]{12000, 8400, 6000, 2400};
    private static final double[] OVERHEAT_CHANCES = new double[]{0.6, 0.4, 0.3, 0.1, 0.05};
    private static final int DEFAULT_PORTAL_DURATION_TICKS = 400;
    private static final int DEFAULT_RETURN_DURATION_TICKS = 200;
    private static final int MIN_PORTAL_DURATION_TICKS = 100;
    private static final int MAX_PORTAL_DURATION_TICKS = 1200;
    private static final int MIN_RETURN_DURATION_TICKS = 100;
    private static final int MAX_RETURN_DURATION_TICKS = 600;

    private TimerUpgradeData() {
    }

    private static CompoundTag getUpgradeTag(ItemStack stack) {
        CompoundTag root = stack.m_41784_();
        CompoundTag upgrades = root.m_128469_(TAG_UPGRADES);
        if (!root.m_128441_(TAG_UPGRADES)) {
            root.m_128365_(TAG_UPGRADES, (Tag)upgrades);
        }
        return upgrades;
    }

    public static int getCooldownTier(ItemStack stack) {
        return TimerUpgradeData.getUpgradeTag(stack).m_128451_(TAG_COOLDOWN_TIER);
    }

    public static boolean canIncreaseCooldownTier(ItemStack stack) {
        return !TimerUpgradeData.isDamagedTimer(stack) && TimerUpgradeData.getCooldownTier(stack) < COOLDOWN_TIERS_TICKS.length - 1;
    }

    public static void increaseCooldownTier(ItemStack stack) {
        if (TimerUpgradeData.canIncreaseCooldownTier(stack)) {
            TimerUpgradeData.getUpgradeTag(stack).m_128405_(TAG_COOLDOWN_TIER, TimerUpgradeData.getCooldownTier(stack) + 1);
        }
    }

    public static int getCooldownDurationTicks(ItemStack stack) {
        TimerUpgradeSlots.initializeTimer(stack);
        int tier = Math.min(TimerUpgradeData.getCooldownTier(stack), COOLDOWN_TIERS_TICKS.length - 1);
        int baseTicks = COOLDOWN_TIERS_TICKS[tier];
        double slotSeconds = TimerUpgradeData.sumSlotValues(stack, 1, UpgradeType.OVERHEAT_COOLDOWN_REDUCER);
        int reduction = (int)(slotSeconds * 20.0);
        int reducedTicks = Math.max(1200, baseTicks - reduction);
        double multiplier = (Double)SlidersModConfig.OVERHEAT_DURATION_MULTIPLIER.get();
        return (int)((double)reducedTicks * multiplier);
    }

    public static int getOverheatReductionTier(ItemStack stack) {
        return TimerUpgradeData.getUpgradeTag(stack).m_128451_(TAG_OVERHEAT_REDUCTION_TIER);
    }

    public static boolean canDecreaseOverheatChance(ItemStack stack) {
        return TimerUpgradeData.getOverheatReductionTier(stack) < OVERHEAT_CHANCES.length - 1;
    }

    public static void increaseOverheatReductionTier(ItemStack stack) {
        if (TimerUpgradeData.canDecreaseOverheatChance(stack)) {
            TimerUpgradeData.getUpgradeTag(stack).m_128405_(TAG_OVERHEAT_REDUCTION_TIER, TimerUpgradeData.getOverheatReductionTier(stack) + 1);
        }
    }

    public static double getPermanentOverheatChance(ItemStack stack) {
        TimerUpgradeSlots.initializeTimer(stack);
        int tier = Math.min(TimerUpgradeData.getOverheatReductionTier(stack), OVERHEAT_CHANCES.length - 1);
        double baseChance = OVERHEAT_CHANCES[tier];
        double bonus = TimerUpgradeData.sumSlotValues(stack, 0, UpgradeType.OVERHEAT_PROBABILITY_REDUCER) / 100.0;
        double result = baseChance - bonus;
        return Math.max(0.0, result);
    }

    public static int getTemporalTier(ItemStack stack) {
        return TimerUpgradeData.getUpgradeTag(stack).m_128451_(TAG_TEMPORAL_TIER);
    }

    public static void increaseTemporalTier(ItemStack stack) {
        TimerUpgradeData.getUpgradeTag(stack).m_128405_(TAG_TEMPORAL_TIER, TimerUpgradeData.getTemporalTier(stack) + 1);
    }

    public static boolean supportsTemporalUpgrade(ItemStack stack) {
        return !TimerUpgradeData.isDamagedTimer(stack) && TimerUpgradeData.isConfigurableTimer(stack.m_41720_());
    }

    public static int getMaxConfiguredSeconds(ItemStack stack) {
        TimerUpgradeSlots.initializeTimer(stack);
        double slotBonusSeconds = TimerUpgradeData.sumSlotValues(stack, 2, UpgradeType.TEMPORAL_STABILIZER) * 60.0;
        return (int)((double)(600 + TimerUpgradeData.getTemporalTier(stack) * 600) + slotBonusSeconds);
    }

    public static long clampConfiguredSeconds(ItemStack stack, long seconds) {
        long max = TimerUpgradeData.getMaxConfiguredSeconds(stack);
        return Math.max(30L, Math.min(max, seconds));
    }

    public static String formatDurationSeconds(long totalSeconds) {
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        return String.format("%02d:%02d:%02d:%02d", days, hours, minutes, seconds);
    }

    public static boolean hasTrackerUpgrade(ItemStack stack) {
        return TimerUpgradeData.getUpgradeTag(stack).m_128471_(TAG_HAS_TRACKER_UPGRADE);
    }

    public static void addTrackerUpgrade(ItemStack stack) {
        TimerUpgradeData.getUpgradeTag(stack).m_128379_(TAG_HAS_TRACKER_UPGRADE, true);
    }

    public static boolean canAddTrackerUpgrade(ItemStack stack) {
        Item item = stack.m_41720_();
        return (item instanceof EgyptianTimerItem || item instanceof EgyptianTimerDamagedItem) && !TimerUpgradeData.hasTrackerUpgrade(stack);
    }

    public static void removeTrackerUpgrade(ItemStack stack) {
        TimerUpgradeData.getUpgradeTag(stack).m_128473_(TAG_HAS_TRACKER_UPGRADE);
    }

    public static boolean hasSeedUpgrade(ItemStack stack) {
        return TimerUpgradeData.getUpgradeTag(stack).m_128471_(TAG_HAS_SEED_UPGRADE);
    }

    public static void addSeedUpgrade(ItemStack stack) {
        TimerUpgradeData.getUpgradeTag(stack).m_128379_(TAG_HAS_SEED_UPGRADE, true);
    }

    public static boolean canAddSeedUpgrade(ItemStack stack) {
        Item item = stack.m_41720_();
        return (item instanceof ExodusTimerItem || item instanceof ExodusTimerDamagedItem) && !TimerUpgradeData.hasSeedUpgrade(stack);
    }

    public static int getSeedSlots(ItemStack stack) {
        return TimerUpgradeData.getUpgradeTag(stack).m_128451_(TAG_SEED_SLOTS);
    }

    public static void increaseSeedSlots(ItemStack stack) {
        int current = TimerUpgradeData.getSeedSlots(stack);
        if (current < 5) {
            TimerUpgradeData.getUpgradeTag(stack).m_128405_(TAG_SEED_SLOTS, current + 1);
        }
    }

    public static boolean canAddSeedSlot(ItemStack stack) {
        Item item = stack.m_41720_();
        return (item instanceof ExodusTimerItem || item instanceof ExodusTimerDamagedItem) && TimerUpgradeData.getSeedSlots(stack) < 5;
    }

    public static void clearSeedData(ItemStack stack) {
        CompoundTag upgrades = TimerUpgradeData.getUpgradeTag(stack);
        upgrades.m_128473_(TAG_HAS_SEED_UPGRADE);
        upgrades.m_128473_(TAG_SEED_SLOTS);
    }

    public static boolean hasPortalStabilityUpgrade(ItemStack stack) {
        return TimerUpgradeData.getUpgradeTag(stack).m_128471_(TAG_HAS_PORTAL_STABILITY);
    }

    public static boolean canAddPortalStabilityUpgrade(ItemStack stack) {
        return TimerUpgradeData.supportsPortalStabilityUpgrade(stack.m_41720_()) && !TimerUpgradeData.hasPortalStabilityUpgrade(stack);
    }

    public static void addPortalStabilityUpgrade(ItemStack stack) {
        if (!TimerUpgradeData.hasPortalStabilityUpgrade(stack)) {
            CompoundTag upgrades = TimerUpgradeData.getUpgradeTag(stack);
            upgrades.m_128379_(TAG_HAS_PORTAL_STABILITY, true);
            upgrades.m_128405_(TAG_PORTAL_DURATION_TICKS, 400);
            upgrades.m_128405_(TAG_RETURN_DURATION_TICKS, 200);
        }
    }

    public static void removePortalStabilityUpgrade(ItemStack stack) {
        CompoundTag upgrades = TimerUpgradeData.getUpgradeTag(stack);
        upgrades.m_128473_(TAG_HAS_PORTAL_STABILITY);
        upgrades.m_128473_(TAG_PORTAL_DURATION_TICKS);
        upgrades.m_128473_(TAG_RETURN_DURATION_TICKS);
    }

    public static int getPortalDurationTicks(ItemStack stack) {
        if (!TimerUpgradeData.hasPortalStabilityUpgrade(stack)) {
            return 400;
        }
        return TimerUpgradeData.clampPortalDurationTicks(TimerUpgradeData.getUpgradeTag(stack).m_128451_(TAG_PORTAL_DURATION_TICKS));
    }

    public static int getReturnPortalDurationTicks(ItemStack stack) {
        if (!TimerUpgradeData.hasPortalStabilityUpgrade(stack)) {
            return 200;
        }
        return TimerUpgradeData.clampReturnDurationTicks(TimerUpgradeData.getUpgradeTag(stack).m_128451_(TAG_RETURN_DURATION_TICKS));
    }

    public static void setPortalDurations(ItemStack stack, int portalTicks, int returnTicks) {
        if (!TimerUpgradeData.hasPortalStabilityUpgrade(stack)) {
            return;
        }
        CompoundTag upgrades = TimerUpgradeData.getUpgradeTag(stack);
        upgrades.m_128405_(TAG_PORTAL_DURATION_TICKS, TimerUpgradeData.clampPortalDurationTicks(portalTicks));
        upgrades.m_128405_(TAG_RETURN_DURATION_TICKS, TimerUpgradeData.clampReturnDurationTicks(returnTicks));
    }

    public static int getDefaultPortalDurationTicks() {
        return 400;
    }

    public static int getDefaultReturnDurationTicks() {
        return 200;
    }

    public static int getMinPortalDurationTicks() {
        return 100;
    }

    public static int getMaxPortalDurationTicks() {
        return 1200;
    }

    public static int getMinReturnDurationTicks() {
        return 100;
    }

    public static int getMaxReturnDurationTicks() {
        return 600;
    }

    private static int clampPortalDurationTicks(int ticks) {
        return Math.max(100, Math.min(1200, ticks));
    }

    private static int clampReturnDurationTicks(int ticks) {
        return Math.max(100, Math.min(600, ticks));
    }

    private static double sumSlotValues(ItemStack stack, int category, UpgradeType type) {
        if (!TimerUpgradeSlots.isTimer(stack)) {
            return 0.0;
        }
        UpgradeInstance[] upgrades = TimerUpgradeSlots.getUpgradesInCategory(stack, category);
        double total = 0.0;
        for (UpgradeInstance inst : upgrades) {
            if (inst == null || inst.getType() != type) continue;
            total += inst.getPrimaryValue();
        }
        return total;
    }

    public static boolean isDamagedTimer(ItemStack stack) {
        Item item = stack.m_41720_();
        return item instanceof OriginalTimerDamagedItem || item instanceof LoganTimerDamagedItem || item instanceof ExodusTimerDamagedItem || item instanceof EgyptianTimerDamagedItem || item instanceof UpgradedLoganTimerTier1DamagedItem || item instanceof UpgradedLoganTimerTier2DamagedItem || item instanceof UpgradedLoganTimerTier3DamagedItem || item instanceof OriginalTimerStuckItem || item instanceof LoganTimerStuckItem || item instanceof ExodusTimerStuckItem || item instanceof EgyptianTimerStuckItem || item instanceof UpgradedLoganTimerTier1StuckItem || item instanceof UpgradedLoganTimerTier2StuckItem || item instanceof UpgradedLoganTimerTier3StuckItem || item instanceof CustomTimerDamagedItem || item instanceof CustomTimerStuckItem;
    }

    private static boolean isConfigurableTimer(Item item) {
        return item instanceof OriginalTimerItem || item instanceof LoganTimerItem || item instanceof ExodusTimerItem || item instanceof EgyptianTimerItem || item instanceof UpgradedLoganTimerTier1Item || item instanceof UpgradedLoganTimerTier2Item || item instanceof UpgradedLoganTimerTier3Item || item instanceof CustomTimerItem;
    }

    private static boolean supportsPortalStabilityUpgrade(Item item) {
        return item instanceof OriginalTimerItem || item instanceof OriginalTimerDamagedItem || item instanceof LoganTimerItem || item instanceof LoganTimerDamagedItem || item instanceof UpgradedLoganTimerTier1Item || item instanceof UpgradedLoganTimerTier1DamagedItem || item instanceof UpgradedLoganTimerTier2Item || item instanceof UpgradedLoganTimerTier2DamagedItem || item instanceof UpgradedLoganTimerTier3Item || item instanceof UpgradedLoganTimerTier3DamagedItem || item instanceof ExodusTimerItem || item instanceof ExodusTimerDamagedItem || item instanceof EgyptianTimerItem || item instanceof EgyptianTimerDamagedItem || item instanceof CustomTimerItem || item instanceof CustomTimerDamagedItem || item instanceof CustomTimerStuckItem;
    }
}

