/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.util;

import com.michelmuscle.slidersmod.util.UpgradeRarity;
import com.michelmuscle.slidersmod.util.UpgradeType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;

public class UpgradeInstance {
    private final UpgradeType type;
    private final UpgradeRarity rarity;
    private final double primaryValue;
    private final long creationTime;

    public UpgradeInstance(UpgradeType type, UpgradeRarity rarity, double primaryValue) {
        this.type = type;
        this.rarity = rarity;
        this.primaryValue = primaryValue;
        this.creationTime = System.currentTimeMillis();
    }

    public UpgradeType getType() {
        return this.type;
    }

    public UpgradeRarity getRarity() {
        return this.rarity;
    }

    public double getPrimaryValue() {
        return this.primaryValue;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Type", this.type.getRegistryName());
        tag.m_128359_("Rarity", this.rarity.name());
        tag.m_128347_("Value", this.primaryValue);
        tag.m_128356_("Created", this.creationTime);
        return tag;
    }

    public static UpgradeInstance deserializeNBT(CompoundTag tag) {
        if (!(tag.m_128441_("Type") && tag.m_128441_("Rarity") && tag.m_128441_("Value"))) {
            return null;
        }
        UpgradeType type = UpgradeType.getByRegistryName(tag.m_128461_("Type"));
        if (type == null) {
            return null;
        }
        try {
            UpgradeRarity rarity = UpgradeRarity.valueOf(tag.m_128461_("Rarity"));
            double value = tag.m_128459_("Value");
            return new UpgradeInstance(type, rarity, value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String toString() {
        return String.format("%s [%s] Value: %.2f", this.type.getDisplayName(), this.rarity.name(), this.primaryValue);
    }

    public String getFormattedValue() {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case UpgradeType.OVERHEAT_COOLDOWN_REDUCER -> String.format("%.0f seconds", this.primaryValue);
            case UpgradeType.OVERHEAT_PROBABILITY_REDUCER -> String.format("%.0f%%", this.primaryValue);
            case UpgradeType.TEMPORAL_STABILIZER -> String.format("%.0f minutes", this.primaryValue);
            case UpgradeType.DIMENSIONAL_BUFFER_TIER1, UpgradeType.DIMENSIONAL_BUFFER_TIER2, UpgradeType.DIMENSIONAL_BUFFER_TIER3, UpgradeType.DIMENSIONAL_BUFFER_TIER4, UpgradeType.DIMENSIONAL_BUFFER_TIER5 -> String.format("%.1f", this.primaryValue);
            case UpgradeType.CRYSTAL_BUFFER -> String.format("%.1fx multiplier", this.primaryValue);
            case UpgradeType.PORTAL_STABILITY -> String.format("%.0f sec window", this.primaryValue);
            case UpgradeType.EGYPTIAN_TRACKER, UpgradeType.EXODUS_SEED, UpgradeType.DIMENSION_ANCHOR -> this.rarity.getDisplayName();
            case UpgradeType.SLOT_EXPANDER -> "Expands slots";
        };
    }

    public static UpgradeInstance createWithGeneratedValue(UpgradeType type, UpgradeRarity rarity, RandomSource random) {
        double value = UpgradeInstance.generateValue(type, rarity, random);
        return new UpgradeInstance(type, rarity, value);
    }

    private static double generateValue(UpgradeType type, UpgradeRarity rarity, RandomSource rnd) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case UpgradeType.OVERHEAT_COOLDOWN_REDUCER -> {
                switch (rarity) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case COMMON: {
                        yield 30.0;
                    }
                    case UNCOMMON: {
                        yield 60.0;
                    }
                    case RARE: {
                        yield 90.0;
                    }
                    case EPIC: {
                        yield 120.0;
                    }
                    case LEGENDARY: 
                }
                yield 300.0;
            }
            case UpgradeType.OVERHEAT_PROBABILITY_REDUCER -> {
                switch (rarity) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case COMMON: {
                        yield 5.0;
                    }
                    case UNCOMMON: {
                        yield 10.0;
                    }
                    case RARE: {
                        yield 15.0;
                    }
                    case EPIC: {
                        yield 20.0;
                    }
                    case LEGENDARY: 
                }
                yield 35.0;
            }
            case UpgradeType.TEMPORAL_STABILIZER -> {
                switch (rarity) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case COMMON: {
                        yield UpgradeInstance.randomRange(rnd, 10.0, 15.0);
                    }
                    case UNCOMMON: {
                        yield UpgradeInstance.randomRange(rnd, 20.0, 30.0);
                    }
                    case RARE: {
                        yield UpgradeInstance.randomRange(rnd, 30.0, 50.0);
                    }
                    case EPIC: {
                        yield UpgradeInstance.randomRange(rnd, 50.0, 90.0);
                    }
                    case LEGENDARY: 
                }
                yield UpgradeInstance.randomRange(rnd, 90.0, 200.0);
            }
            case UpgradeType.DIMENSIONAL_BUFFER_TIER1 -> UpgradeInstance.randomRange(rnd, 0.5, 0.8);
            case UpgradeType.DIMENSIONAL_BUFFER_TIER2 -> UpgradeInstance.randomRange(rnd, 0.9, 1.2);
            case UpgradeType.DIMENSIONAL_BUFFER_TIER3 -> UpgradeInstance.randomRange(rnd, 1.2, 1.4);
            case UpgradeType.DIMENSIONAL_BUFFER_TIER4 -> UpgradeInstance.randomRange(rnd, 1.4, 2.0);
            case UpgradeType.DIMENSIONAL_BUFFER_TIER5 -> 3.0;
            case UpgradeType.CRYSTAL_BUFFER -> {
                switch (rarity) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case COMMON: {
                        yield 0.8;
                    }
                    case UNCOMMON: {
                        yield 0.8;
                    }
                    case RARE: {
                        yield 0.6;
                    }
                    case EPIC: {
                        yield 0.6;
                    }
                    case LEGENDARY: 
                }
                yield 0.4;
            }
            case UpgradeType.PORTAL_STABILITY -> UpgradeInstance.randomRange(rnd, 10.0, 60.0);
            case UpgradeType.EGYPTIAN_TRACKER, UpgradeType.EXODUS_SEED, UpgradeType.DIMENSION_ANCHOR, UpgradeType.SLOT_EXPANDER -> 0.0;
        };
    }

    private static double randomRange(RandomSource rnd, double min, double max) {
        return min + rnd.m_188500_() * (max - min);
    }
}

