/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.util;

public enum UpgradeRarity {
    COMMON(0, "Common", 0x808080),
    UNCOMMON(1, "Uncommon", 4286945),
    RARE(2, "Rare", 10040012),
    EPIC(3, "Epic", 16747520),
    LEGENDARY(4, "Legendary", 16766720);

    private final int tier;
    private final String displayName;
    private final int color;

    private UpgradeRarity(int tier, String displayName, int color) {
        this.tier = tier;
        this.displayName = displayName;
        this.color = color;
    }

    public int getTier() {
        return this.tier;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getColor() {
        return this.color;
    }

    public static UpgradeRarity fromTier(int tier) {
        return switch (tier) {
            case 0 -> COMMON;
            case 1 -> UNCOMMON;
            case 2 -> RARE;
            case 3 -> EPIC;
            case 4 -> LEGENDARY;
            default -> COMMON;
        };
    }

    public double getValueMultiplier() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case COMMON -> 0.8;
            case UNCOMMON -> 1.0;
            case RARE -> 1.2;
            case EPIC -> 1.4;
            case LEGENDARY -> 1.6;
        };
    }

    public static int packColor(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    public static int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getBlue(int color) {
        return color & 0xFF;
    }

    public float[] getColorFloats() {
        float r = (float)UpgradeRarity.getRed(this.color) / 255.0f;
        float g = (float)UpgradeRarity.getGreen(this.color) / 255.0f;
        float b = (float)UpgradeRarity.getBlue(this.color) / 255.0f;
        return new float[]{r, g, b};
    }
}

