/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.util;

import com.michelmuscle.slidersmod.util.TimerUpgradeData;
import com.michelmuscle.slidersmod.util.TimerUpgradeSlots;
import com.michelmuscle.slidersmod.util.UpgradeInstance;
import com.michelmuscle.slidersmod.util.UpgradeType;
import net.minecraft.world.item.ItemStack;

public class UpgradeStatsCalculator {
    public static double getTotalOverheatCooldownReduction(ItemStack timerStack) {
        UpgradeInstance[] upgrades;
        double total = 0.0;
        for (UpgradeInstance upgrade : upgrades = TimerUpgradeSlots.getUpgradesInCategory(timerStack, 1)) {
            if (upgrade == null || upgrade.getType() != UpgradeType.OVERHEAT_COOLDOWN_REDUCER) continue;
            total += upgrade.getPrimaryValue();
        }
        return total;
    }

    public static double getTotalOverheatProbabilityReduction(ItemStack timerStack) {
        UpgradeInstance[] upgrades;
        double total = 0.0;
        for (UpgradeInstance upgrade : upgrades = TimerUpgradeSlots.getUpgradesInCategory(timerStack, 0)) {
            if (upgrade == null || upgrade.getType() != UpgradeType.OVERHEAT_PROBABILITY_REDUCER) continue;
            total += upgrade.getPrimaryValue();
        }
        return Math.max(0.0, total);
    }

    public static double getTotalTemporalBonus(ItemStack timerStack) {
        UpgradeInstance[] upgrades;
        double total = 0.0;
        for (UpgradeInstance upgrade : upgrades = TimerUpgradeSlots.getUpgradesInCategory(timerStack, 2)) {
            if (upgrade == null || upgrade.getType() != UpgradeType.TEMPORAL_STABILIZER) continue;
            total += upgrade.getPrimaryValue();
        }
        return total;
    }

    public static int getMaxDimensionalTier(ItemStack timerStack) {
        UpgradeInstance[] upgrades;
        double total = 0.0;
        for (UpgradeInstance upgrade : upgrades = TimerUpgradeSlots.getUpgradesInCategory(timerStack, 3)) {
            if (upgrade == null) continue;
            if (upgrade.getType() == UpgradeType.DIMENSIONAL_BUFFER_TIER5) {
                return 5;
            }
            if (upgrade.getType().getCategoryIndex() != 3) continue;
            total += upgrade.getPrimaryValue();
        }
        int tier = (int)Math.floor(total);
        return Math.min(tier, 4);
    }

    public static double getCrystalBufferMultiplier(ItemStack timerStack) {
        UpgradeInstance[] upgrades;
        if (!TimerUpgradeData.isDamagedTimer(timerStack)) {
            return 1.0;
        }
        for (UpgradeInstance upgrade : upgrades = TimerUpgradeSlots.getUpgradesInCategory(timerStack, 4)) {
            if (upgrade == null || upgrade.getType() != UpgradeType.CRYSTAL_BUFFER) continue;
            return upgrade.getPrimaryValue();
        }
        return 1.0;
    }

    public static boolean hasEgyptianTracker(ItemStack timerStack) {
        UpgradeInstance[] upgrades;
        for (UpgradeInstance upgrade : upgrades = TimerUpgradeSlots.getUpgradesInCategory(timerStack, 4)) {
            if (upgrade == null || upgrade.getType() != UpgradeType.EGYPTIAN_TRACKER) continue;
            return true;
        }
        return false;
    }

    public static double getExodusSeedBonus(ItemStack timerStack) {
        UpgradeInstance[] upgrades;
        for (UpgradeInstance upgrade : upgrades = TimerUpgradeSlots.getUpgradesInCategory(timerStack, 4)) {
            if (upgrade == null || upgrade.getType() != UpgradeType.EXODUS_SEED) continue;
            return upgrade.getPrimaryValue();
        }
        return 0.0;
    }

    public static double getDimensionAnchorBonus(ItemStack timerStack) {
        UpgradeInstance[] upgrades;
        for (UpgradeInstance upgrade : upgrades = TimerUpgradeSlots.getUpgradesInCategory(timerStack, 4)) {
            if (upgrade == null || upgrade.getType() != UpgradeType.DIMENSION_ANCHOR) continue;
            return upgrade.getPrimaryValue();
        }
        return 0.0;
    }

    public static double getExodusSynergyBonus(ItemStack timerStack) {
        double seedBonus = UpgradeStatsCalculator.getExodusSeedBonus(timerStack);
        double anchorBonus = UpgradeStatsCalculator.getDimensionAnchorBonus(timerStack);
        if (seedBonus > 0.0 && anchorBonus > 0.0) {
            return (seedBonus + anchorBonus) * 1.15;
        }
        return seedBonus + anchorBonus;
    }

    public static int getTotalInstalledUpgrades(ItemStack timerStack) {
        int count = 0;
        for (int category = 0; category < 5; ++category) {
            UpgradeInstance[] upgrades;
            for (UpgradeInstance upgrade : upgrades = TimerUpgradeSlots.getUpgradesInCategory(timerStack, category)) {
                if (upgrade == null) continue;
                ++count;
            }
        }
        return count;
    }

    public static String generateStatsReport(ItemStack timerStack) {
        double crystalMult;
        double exodusSynergy;
        StringBuilder report = new StringBuilder();
        double cooldownReduction = UpgradeStatsCalculator.getTotalOverheatCooldownReduction(timerStack);
        double probReduction = UpgradeStatsCalculator.getTotalOverheatProbabilityReduction(timerStack);
        double temporalBonus = UpgradeStatsCalculator.getTotalTemporalBonus(timerStack);
        int dimTier = UpgradeStatsCalculator.getMaxDimensionalTier(timerStack);
        if (cooldownReduction > 0.0) {
            report.append(String.format("Cooldown: %.0fs\n", cooldownReduction));
        }
        if (probReduction > 0.0) {
            report.append(String.format("Overheat Protection: -%.0f%%\n", probReduction));
        }
        if (temporalBonus > 0.0) {
            report.append(String.format("Exploration: +%.0f min\n", temporalBonus));
        }
        if (dimTier > 0) {
            report.append(String.format("Dimension Access: Tier %d\n", dimTier));
        }
        if (UpgradeStatsCalculator.hasEgyptianTracker(timerStack)) {
            report.append("Egyptian Tracker: Active\n");
        }
        if ((exodusSynergy = UpgradeStatsCalculator.getExodusSynergyBonus(timerStack)) > 0.0) {
            report.append(String.format("Dimensional Mastery: +%.0f%%\n", exodusSynergy));
        }
        if ((crystalMult = UpgradeStatsCalculator.getCrystalBufferMultiplier(timerStack)) < 1.0) {
            report.append(String.format("Cooldown Multiplier: %.1fx\n", crystalMult));
        }
        return report.toString();
    }
}

