/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.createterminal;

import net.chaolux.createterminal.client.ClientAdvancementCache;
import net.chaolux.createterminal.common.item.data.RemoteBinding;
import net.chaolux.createterminal.common.utility.StyleUtils;
import net.chaolux.createterminal.registry.item.ModItems;
import net.chaolux.createterminal.registry.recipe.ModDataComponents;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@Mod(value="createterminal", dist={Dist.CLIENT})
@EventBusSubscriber(modid="createterminal", value={Dist.CLIENT})
public class CreateTerminalClient {
    public CreateTerminalClient(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    @SubscribeEvent
    static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)ModItems.CREATIVE_REMOTE_TERMINAL.get(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createterminal", (String)"bound"), (stack, world, entity, seed) -> {
                RemoteBinding binding = (RemoteBinding)stack.getOrDefault(ModDataComponents.REMOTE_BINDING.get(), (Object)RemoteBinding.EMPTY);
                return binding.size() > 0 ? 1.0f : 0.0f;
            });
            ItemProperties.register((Item)ModItems.ADVANCED_REMOTE_TERMINAL.get(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createterminal", (String)"styles"), (stack, world, entity, seed) -> {
                RemoteBinding binding = (RemoteBinding)stack.getOrDefault(ModDataComponents.REMOTE_BINDING.get(), (Object)RemoteBinding.EMPTY);
                if (binding.size() == 0) {
                    return 0.0f;
                }
                String style = (String)stack.getOrDefault(ModDataComponents.STYLE.get(), (Object)"");
                if (style.equals("cardboard") && !StyleUtils.isMod("createcardboardthings")) {
                    return 1.0f;
                }
                if (style.equals("end") && !ClientAdvancementCache.hasDragonKill()) {
                    return 1.0f;
                }
                return switch (style) {
                    case "blaze" -> 1.0f;
                    case "parrot" -> 2.0f;
                    case "cat" -> 3.0f;
                    case "cardboard" -> 4.0f;
                    case "end" -> 5.0f;
                    default -> 0.0f;
                };
            });
            ItemProperties.register((Item)ModItems.REMOTE_TERMINAL.get(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createterminal", (String)"styles"), (stack, world, entity, seed) -> {
                CompoundTag tag = CreateTerminalClient.getCustomTag(stack);
                if (tag == null || !tag.contains("boundPos") || !tag.contains("boundDim")) {
                    return 0.0f;
                }
                String style = (String)stack.getOrDefault(ModDataComponents.STYLE.get(), (Object)"");
                if (style.equals("cardboard") && !StyleUtils.isMod("createcardboardthings")) {
                    return 1.0f;
                }
                if (style.equals("end") && !ClientAdvancementCache.hasDragonKill()) {
                    return 1.0f;
                }
                return switch (style) {
                    case "blaze" -> 1.0f;
                    case "parrot" -> 2.0f;
                    case "cat" -> 3.0f;
                    case "cardboard" -> 4.0f;
                    case "end" -> 5.0f;
                    default -> 0.0f;
                };
            });
        });
    }

    private static CompoundTag getCustomTag(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (!stack.has(DataComponents.CUSTOM_DATA)) {
            return null;
        }
        return ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
    }
}

