/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.createterminal.common.item;

import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.chaolux.createterminal.common.item.data.RemoteBinding;
import net.chaolux.createterminal.common.menu.RemoteStockKeeperMenu;
import net.chaolux.createterminal.common.network.SyncAdvancementPacket;
import net.chaolux.createterminal.common.utility.StyleUtils;
import net.chaolux.createterminal.registry.network.ModNetwork;
import net.chaolux.createterminal.registry.recipe.ModDataComponents;
import net.chaolux.createterminal.registry.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AdvancedRemoteTerminalItem
extends Item {
    private static final int MAX_TERMINALS = 25;

    public AdvancedRemoteTerminalItem(Item.Properties p_41383_) {
        super(p_41383_.stacksTo(1));
    }

    private static int getMaxTerminals(ItemStack stack) {
        int expand = (Integer)stack.getOrDefault(ModDataComponents.EXPAND.get(), (Object)0);
        return 25 + expand * 10;
    }

    public InteractionResult useOn(UseOnContext ctx) {
        String dim;
        RemoteBinding binding;
        BlockPos pos;
        Level level = ctx.getLevel();
        BlockEntity be = level.getBlockEntity(pos = ctx.getClickedPos());
        if (!(be instanceof StockTickerBlockEntity)) {
            return InteractionResult.PASS;
        }
        ItemStack stack = ctx.getItemInHand();
        String style = (String)stack.getOrDefault(ModDataComponents.STYLE.get(), (Object)"");
        if (style.isEmpty()) {
            stack.set(ModDataComponents.STYLE.get(), (Object)"blaze");
        }
        if ((binding = (RemoteBinding)stack.getOrDefault(ModDataComponents.REMOTE_BINDING.get(), (Object)RemoteBinding.EMPTY)).contain(pos, dim = level.dimension().location().toString())) {
            Player player = ctx.getPlayer();
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.createterminal.bound_existing"), true);
            }
            return InteractionResult.FAIL;
        }
        if (binding.size() >= AdvancedRemoteTerminalItem.getMaxTerminals(stack)) {
            level.playSound(null, pos, ModSounds.TERMINAL_LOST.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            Player player = ctx.getPlayer();
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.createterminal.limit"), true);
            }
            return InteractionResult.FAIL;
        }
        stack.set(ModDataComponents.REMOTE_BINDING.get(), (Object)binding.add(pos, dim));
        if (!level.isClientSide) {
            level.playSound(null, pos, ModSounds.TERMINAL_ON.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            Player player = ctx.getPlayer();
            if (player != null) {
                player.getInventory().setChanged();
                if (player.containerMenu != null) {
                    player.containerMenu.broadcastChanges();
                }
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.createterminal.bound_success", (Object[])new Object[]{pos.toShortString()}), true);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        ItemStack stack = player.getItemInHand(hand);
        RemoteBinding binding = (RemoteBinding)stack.getOrDefault(ModDataComponents.REMOTE_BINDING.get(), (Object)RemoteBinding.EMPTY);
        if (binding.size() == 0) {
            player.displayClientMessage((Component)Component.translatable((String)"tooltip.createterminal.not_bound"), true);
            return InteractionResultHolder.pass((Object)stack);
        }
        ArrayList<BlockPos> validPos = new ArrayList<BlockPos>();
        String currentDim = level.dimension().location().toString();
        for (int i = 0; i < binding.dims().size(); ++i) {
            if (!currentDim.equals(binding.dims().get(i))) continue;
            validPos.add(BlockPos.of((long)binding.terminals().get(i)));
        }
        validPos.sort(Comparator.comparingDouble(p -> player.blockPosition().distSqr((Vec3i)p)));
        BlockPos bestPos = null;
        for (BlockPos pos : validPos) {
            BlockEntity be;
            if (!level.hasChunkAt(pos) || !((be = level.getBlockEntity(pos)) instanceof StockTickerBlockEntity) || !level.getBlockState(pos).is((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"stock_ticker")))) continue;
            bestPos = pos;
            break;
        }
        if (bestPos == null) {
            player.level().playSound(null, player.blockPosition(), ModSounds.TERMINAL_LOST.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            player.displayClientMessage((Component)Component.translatable((String)"tooltip.createterminal.lost"), true);
            return InteractionResultHolder.fail((Object)stack);
        }
        boolean unlock = StyleUtils.hasAdvancement((ServerPlayer)player, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"end/kill_dragon"));
        ModNetwork.sendToClient((ServerPlayer)player, new SyncAdvancementPacket(unlock));
        MenuType menuType = (MenuType)BuiltInRegistries.MENU.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"stock_keeper_request"));
        if (menuType == null) {
            return InteractionResultHolder.fail((Object)stack);
        }
        BlockEntity blockEntity = level.getBlockEntity(bestPos);
        if (!(blockEntity instanceof StockTickerBlockEntity)) {
            player.displayClientMessage((Component)Component.translatable((String)"tooltip.createterminal.lost"), true);
            return InteractionResultHolder.fail((Object)stack);
        }
        StockTickerBlockEntity stockTickerBlockEntity = (StockTickerBlockEntity)blockEntity;
        SimpleMenuProvider provider = new SimpleMenuProvider((id, inv, ply) -> new RemoteStockKeeperMenu(menuType, id, inv, stockTickerBlockEntity), (Component)Component.literal((String)"Stock Keeper"));
        BlockPos finalBestPos = bestPos;
        ((ServerPlayer)player).openMenu((MenuProvider)provider, data -> {
            data.writeBoolean(false);
            data.writeBoolean(false);
            data.writeBlockPos(finalBestPos);
        });
        player.displayClientMessage((Component)Component.translatable((String)"tooltip.createterminal.connected", (Object[])new Object[]{bestPos.toShortString()}), true);
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        RemoteBinding binding = (RemoteBinding)stack.getOrDefault(ModDataComponents.REMOTE_BINDING.get(), (Object)RemoteBinding.EMPTY);
        if (binding.size() > 0) {
            tooltip.add((Component)Component.translatable((String)"tooltip.createterminal.header").withStyle(ChatFormatting.DARK_GRAY));
            boolean showAll = Screen.hasShiftDown();
            int show = 0;
            for (int i = 0; i < binding.size(); ++i) {
                if (show >= 5 && !showAll) {
                    tooltip.add(StyleUtils.styleBracket((Component)Component.translatable((String)"tooltip.createterminal.more", (Object[])new Object[]{binding.size() - show}).withStyle(ChatFormatting.DARK_GRAY)));
                    break;
                }
                BlockPos pos = BlockPos.of((long)binding.terminals().get(i));
                tooltip.add((Component)Component.translatable((String)"tooltip.createterminal.bound", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).withStyle(ChatFormatting.GRAY));
                ++show;
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.createterminal.not_bound").withStyle(ChatFormatting.DARK_GRAY));
        }
        boolean showExpand = Screen.hasAltDown();
        if (showExpand) {
            tooltip.add((Component)Component.translatable((String)"tooltip.createterminal.expand", (Object[])new Object[]{AdvancedRemoteTerminalItem.getMaxTerminals(stack)}).withStyle(ChatFormatting.GRAY));
        } else {
            tooltip.add(StyleUtils.styleBracket((Component)Component.translatable((String)"tooltip.createterminal.ctrl_more").withStyle(ChatFormatting.DARK_GRAY)));
        }
        tooltip.add(StyleUtils.styleBracket((Component)Component.translatable((String)"tooltip.createterminal.style").withStyle(ChatFormatting.GRAY)));
    }

    public static void setStyle(ItemStack stack, String style) {
        stack.set(ModDataComponents.STYLE.get(), (Object)style);
    }
}

