/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.createterminal.common.item;

import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import java.util.List;
import net.chaolux.createterminal.common.menu.RemoteStockKeeperMenu;
import net.chaolux.createterminal.common.network.SyncAdvancementPacket;
import net.chaolux.createterminal.common.utility.StyleUtils;
import net.chaolux.createterminal.registry.network.ModNetwork;
import net.chaolux.createterminal.registry.recipe.ModDataComponents;
import net.chaolux.createterminal.registry.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RemoteTerminalItem
extends Item {
    public RemoteTerminalItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockPos pos;
        Level level = ctx.getLevel();
        BlockEntity be = level.getBlockEntity(pos = ctx.getClickedPos());
        if (!(be instanceof StockTickerBlockEntity)) {
            return InteractionResult.PASS;
        }
        ItemStack stack = ctx.getItemInHand();
        CompoundTag tag = RemoteTerminalItem.getOrCreateCustomTag(stack);
        tag.putLong("boundPos", pos.asLong());
        tag.putString("boundDim", level.dimension().location().toString());
        RemoteTerminalItem.setCustomTag(stack, tag);
        String style = (String)stack.getOrDefault(ModDataComponents.STYLE.get(), (Object)"");
        if (style.isEmpty()) {
            stack.set(ModDataComponents.STYLE.get(), (Object)"blaze");
        }
        if (!level.isClientSide) {
            ctx.getPlayer().displayClientMessage((Component)Component.translatable((String)"tooltip.createterminal.bound", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}), true);
            ctx.getLevel().playSound(null, pos, ModSounds.TERMINAL_ON.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide) {
            BlockEntity blockEntity;
            ItemStack stack = player.getItemInHand(hand);
            CompoundTag tag = RemoteTerminalItem.getCustomTag(stack);
            if (tag == null || !tag.contains("boundPos") || !tag.contains("boundDim")) {
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.createterminal.not_bound"), true);
                return InteractionResultHolder.pass((Object)stack);
            }
            BlockPos pos = BlockPos.of((long)tag.getLong("boundPos"));
            String dimId = tag.getString("boundDim");
            ResourceKey dimKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)dimId));
            if (!level.dimension().equals(dimKey)) {
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.createterminal.lost"), true);
                player.level().playSound(null, player.blockPosition(), ModSounds.TERMINAL_LOST.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResultHolder.fail((Object)stack);
            }
            if (!level.hasChunkAt(pos) || !((blockEntity = level.getBlockEntity(pos)) instanceof StockTickerBlockEntity)) {
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.createterminal.lost"), true);
                player.level().playSound(null, player.blockPosition(), ModSounds.TERMINAL_LOST.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResultHolder.fail((Object)stack);
            }
            StockTickerBlockEntity stockTickerBlockEntity = (StockTickerBlockEntity)blockEntity;
            boolean unlock = StyleUtils.hasAdvancement((ServerPlayer)player, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"end/kill_dragon"));
            ModNetwork.sendToClient((ServerPlayer)player, new SyncAdvancementPacket(unlock));
            MenuType menuType = (MenuType)BuiltInRegistries.MENU.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"stock_keeper_request"));
            if (menuType == null) {
                return InteractionResultHolder.fail((Object)stack);
            }
            SimpleMenuProvider provider = new SimpleMenuProvider((id, inv, ply) -> new RemoteStockKeeperMenu(menuType, id, inv, stockTickerBlockEntity), (Component)Component.literal((String)"Stock Keeper"));
            ((ServerPlayer)player).openMenu((MenuProvider)provider, data -> {
                data.writeBoolean(false);
                data.writeBoolean(false);
                data.writeBlockPos(pos);
            });
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        CompoundTag tag = RemoteTerminalItem.getCustomTag(stack);
        if (tag != null && tag.contains("boundPos") && tag.contains("boundDim")) {
            BlockPos pos = BlockPos.of((long)tag.getLong("boundPos"));
            tooltip.add((Component)Component.translatable((String)"tooltip.createterminal.bound", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).withStyle(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.createterminal.not_bound").withStyle(ChatFormatting.GRAY));
        }
        tooltip.add(StyleUtils.styleBracket((Component)Component.translatable((String)"tooltip.createterminal.style").withStyle(ChatFormatting.GRAY)));
    }

    public static void setStyle(ItemStack stack, String style) {
        stack.set(ModDataComponents.STYLE.get(), (Object)style);
    }

    private static CompoundTag getCustomTag(ItemStack stack) {
        if (!stack.has(DataComponents.CUSTOM_DATA)) {
            return null;
        }
        return ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
    }

    private static CompoundTag getOrCreateCustomTag(ItemStack stack) {
        CompoundTag tag = RemoteTerminalItem.getCustomTag(stack);
        if (tag == null) {
            tag = new CompoundTag();
        }
        return tag;
    }

    private static void setCustomTag(ItemStack stack, CompoundTag tag) {
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }
}

