/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.createterminal.common.item.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record RemoteBinding(List<Long> terminals, List<String> dims) {
    public static final RemoteBinding EMPTY = new RemoteBinding(List.of(), List.of());
    public static final Codec<RemoteBinding> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.list((Codec)Codec.LONG).fieldOf("terminals").forGetter(RemoteBinding::terminals), (App)Codec.list((Codec)Codec.STRING).fieldOf("dims").forGetter(RemoteBinding::dims)).apply((Applicative)builder, RemoteBinding::new));
    public static final StreamCodec<ByteBuf, RemoteBinding> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG.apply(ByteBufCodecs.list()), RemoteBinding::terminals, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), RemoteBinding::dims, RemoteBinding::new);

    public boolean contain(BlockPos pos, String dim) {
        for (int i = 0; i < this.terminals.size(); ++i) {
            if (this.terminals.get(i).longValue() != pos.asLong() || !this.dims.get(i).equals(dim)) continue;
            return true;
        }
        return false;
    }

    public RemoteBinding add(BlockPos pos, String dim) {
        ArrayList<Long> terminal = new ArrayList<Long>(this.terminals);
        ArrayList<String> dimension = new ArrayList<String>(this.dims);
        terminal.add(pos.asLong());
        dimension.add(dim);
        return new RemoteBinding(terminal, dimension);
    }

    public RemoteBinding remove(int index) {
        ArrayList<Long> terminal = new ArrayList<Long>(this.terminals);
        ArrayList<String> dimension = new ArrayList<String>(this.dims);
        terminal.remove(index);
        dimension.remove(index);
        return new RemoteBinding(terminal, dimension);
    }

    public int size() {
        return Math.min(this.terminals.size(), this.dims.size());
    }
}

