/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.createterminal.data.recipe;

import net.chaolux.createterminal.registry.item.ModItems;
import net.chaolux.createterminal.registry.recipe.ModDataComponents;
import net.chaolux.createterminal.registry.recipe.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class AdvancedRemoteTerminalRecipe
implements CraftingRecipe {
    private final CraftingBookCategory category;
    private final Ingredient terminal;
    private final Ingredient core;
    private final ItemStack result;

    public AdvancedRemoteTerminalRecipe(CraftingBookCategory category) {
        this.category = category;
        this.terminal = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ADVANCED_REMOTE_TERMINAL.get()});
        this.core = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.MEMORY_CORE.get()});
        this.result = new ItemStack((ItemLike)ModItems.ADVANCED_REMOTE_TERMINAL.get());
    }

    public boolean matches(CraftingInput inv, Level level) {
        int hasTerminal = 0;
        int hasCore = 0;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (this.terminal.test(stack)) {
                ++hasTerminal;
                continue;
            }
            if (this.core.test(stack)) {
                ++hasCore;
                continue;
            }
            return false;
        }
        return hasTerminal == 1 && hasCore == 1;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        ItemStack terminalItem = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (!this.terminal.test(stack)) continue;
            terminalItem = stack;
            break;
        }
        if (terminalItem.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack result = terminalItem.copy();
        DataComponentType<Integer> type = ModDataComponents.EXPAND.get();
        int current = (Integer)result.getOrDefault(type, (Object)0);
        result.set(type, (Object)(current + 1));
        return result;
    }

    public boolean canCraftInDimensions(int w, int h) {
        return w * h >= 2;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.TERMINAL_EXPAND_SERIALIZER.get();
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.create();
        ingredients.add((Object)this.terminal);
        ingredients.add((Object)this.core);
        return ingredients;
    }

    public boolean isSpecial() {
        return true;
    }

    public CraftingBookCategory category() {
        return this.category;
    }
}

