/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.cortex.voxy.client.ClientImportManager;
import me.cortex.voxy.client.compat.FlashbackCompat;
import me.cortex.voxy.client.config.VoxyConfig;
import me.cortex.voxy.client.mixin.sodium.AccessorSodiumWorldRenderer;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.config.ConfigBuildCtx;
import me.cortex.voxy.common.config.Serialization;
import me.cortex.voxy.common.config.compressors.ZSTDCompressor;
import me.cortex.voxy.common.config.section.SectionSerializationStorage;
import me.cortex.voxy.common.config.section.SectionStorage;
import me.cortex.voxy.common.config.section.SectionStorageConfig;
import me.cortex.voxy.common.config.storage.other.CompressionStorageAdaptor;
import me.cortex.voxy.common.config.storage.rocksdb.RocksDBStorageBackend;
import me.cortex.voxy.commonImpl.ImportManager;
import me.cortex.voxy.commonImpl.VoxyInstance;
import me.cortex.voxy.commonImpl.WorldIdentifier;
import net.caffeinemc.mods.sodium.client.render.SodiumWorldRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSectionManager;
import net.minecraft.class_1132;
import net.minecraft.class_310;
import net.minecraft.class_5218;
import net.minecraft.class_636;
import net.minecraft.class_642;

public class VoxyClientInstance
extends VoxyInstance {
    public static boolean isInGame = false;
    private final SectionStorageConfig storageConfig;
    private final Path basePath;
    private final boolean noIngestOverride;
    private static final Config DEFAULT_STORAGE_CONFIG;

    public VoxyClientInstance() {
        Path path = FlashbackCompat.getReplayStoragePath();
        boolean bl = this.noIngestOverride = path != null;
        if (path == null) {
            path = VoxyClientInstance.getBasePath();
        }
        this.basePath = path;
        this.storageConfig = VoxyClientInstance.getCreateStorageConfig(path);
        this.updateDedicatedThreads();
    }

    @Override
    public void updateDedicatedThreads() {
        RenderSectionManager rsm;
        SodiumWorldRenderer swr;
        int target = VoxyConfig.CONFIG.serviceThreads;
        if (!VoxyConfig.CONFIG.dontUseSodiumBuilderThreads && (swr = SodiumWorldRenderer.instanceNullable()) != null && (rsm = ((AccessorSodiumWorldRenderer)swr).getRenderSectionManager()) != null) {
            this.setNumThreads(Math.max(1, target - rsm.getBuilder().getTotalThreadCount()));
            return;
        }
        this.setNumThreads(target);
    }

    @Override
    protected ImportManager createImportManager() {
        return new ClientImportManager();
    }

    @Override
    protected SectionStorage createStorage(WorldIdentifier identifier) {
        ConfigBuildCtx ctx = new ConfigBuildCtx();
        ctx.setProperty("{base_save_path}", this.basePath.toString());
        ctx.setProperty("{world_identifier}", identifier.getWorldId());
        ctx.pushPath("{base_save_path}/{world_identifier}/storage/");
        return this.storageConfig.build(ctx);
    }

    public static SectionStorageConfig getCreateStorageConfig(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Path json = path.resolve("config.json");
        Config config = null;
        if (Files.exists(json, new LinkOption[0])) {
            try {
                config = (Config)Serialization.GSON.fromJson(Files.readString(json), Config.class);
                if (config == null) {
                    Logger.error("Config deserialization null, reverting to default");
                } else if (config.sectionStorageConfig == null) {
                    Logger.error("Config section storage null, reverting to default");
                    config = null;
                }
            }
            catch (Exception e) {
                Logger.error("Failed to load the storage configuration file, resetting it to default, this will probably break your save if you used a custom storage config", e);
            }
        }
        if (config == null) {
            config = DEFAULT_STORAGE_CONFIG;
        }
        try {
            Files.writeString(json, (CharSequence)Serialization.GSON.toJson((Object)config), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed write the config, aborting!", e);
        }
        if (config == null) {
            throw new IllegalStateException("Config is still null\n");
        }
        return config.sectionStorageConfig;
    }

    public Path getStorageBasePath() {
        return this.basePath;
    }

    @Override
    public boolean isIngestEnabled(WorldIdentifier worldId) {
        return !this.noIngestOverride;
    }

    private static Path getBasePath() {
        Path basePath = class_310.method_1551().field_1697.toPath().resolve(".voxy").resolve("saves");
        class_1132 iserver = class_310.method_1551().method_1576();
        if (iserver != null) {
            basePath = iserver.method_27050(class_5218.field_24188).resolve("voxy");
        } else {
            class_636 netHandle = class_310.method_1551().field_1761;
            if (netHandle == null) {
                Logger.error("Network handle null");
                basePath = basePath.resolve("UNKNOWN");
            } else {
                class_642 info = netHandle.field_3720.method_45734();
                if (info == null) {
                    Logger.error("Server info null");
                    basePath = basePath.resolve("UNKNOWN");
                } else {
                    basePath = info.method_52811() ? basePath.resolve("realms") : basePath.resolve(info.field_3761.replace(":", "_"));
                }
            }
        }
        return basePath.toAbsolutePath();
    }

    static {
        Config config = new Config();
        RocksDBStorageBackend.Config baseDB = new RocksDBStorageBackend.Config();
        ZSTDCompressor.Config compressor = new ZSTDCompressor.Config();
        compressor.compressionLevel = 1;
        CompressionStorageAdaptor.Config compression = new CompressionStorageAdaptor.Config();
        compression.delegate = baseDB;
        compression.compressor = compressor;
        SectionSerializationStorage.Config serializer = new SectionSerializationStorage.Config();
        serializer.storage = compression;
        config.sectionStorageConfig = serializer;
        DEFAULT_STORAGE_CONFIG = config;
    }

    private static class Config {
        public int version = 1;
        public SectionStorageConfig sectionStorageConfig;

        private Config() {
        }
    }
}

